/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api.cr;

import com.cloudbees.api.cr.CloudResource;
import java.net.URL;

public class Capability {
    private final String uri;

    public Capability(String uri) {
        this.uri = uri;
    }

    public String to(URL resource) {
        String base = resource.getHost();
        int p = resource.getPort();
        if (resource.getDefaultPort() != p && p != -1) {
            base = base + ":" + p;
        }
        return this.toScope(base);
    }

    public String toAll() {
        return this.toScope("*");
    }

    private String toScope(String domain) {
        return String.format("crs://%s/!%s", domain, this.uri);
    }

    public String to(CloudResource cr) {
        return this.to(cr.getUrl());
    }

    public String toString() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Capability that = (Capability)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

