/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api;

import com.cloudbees.api.BeesClient;
import com.cloudbees.api.CBObject;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpReply {
    private final HttpMethod method;
    private final int code;
    private final String content;

    public HttpReply(int code, String content) {
        this(null, code, content);
    }

    public HttpReply(HttpMethod method, int code, String content) {
        this.method = method;
        this.code = code;
        this.content = content;
    }

    public int getCode() {
        return this.code;
    }

    public String getContent() {
        return this.content;
    }

    public <T> T bind(Class<T> type, BeesClient root) throws IOException {
        if (this.getCode() >= 300) {
            throw new IOException("Failed to " + this.method.getName() + " : " + this.method.getURI() + " : code=" + this.getCode() + " response=" + this.getContent());
        }
        if (type != null && this.getContent() != null) {
            Object ret = BeesClient.MAPPER.readValue(this.getContent(), type);
            if (ret instanceof CBObject) {
                ((CBObject)ret).root = root;
            }
            return (T)ret;
        }
        return null;
    }

    public String toString() {
        return "HttpReply{code=" + this.code + ", content='" + this.content + '\'' + '}';
    }

    public String toShortString(int max) {
        String str = this.content.length() > max ? this.content.substring(0, max) + "..." : this.content;
        return "Reply{code=" + this.code + ", content='" + str + '\'' + '}';
    }
}

