/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api;

import com.cloudbees.api.UploadProgress;
import java.io.PrintStream;

public class HashWriteProgress
implements UploadProgress {
    private final PrintStream out;
    boolean uploadComplete = false;
    long hashMarkCount = 0L;

    public HashWriteProgress() {
        this(System.out);
    }

    public HashWriteProgress(PrintStream out) {
        this.out = out;
    }

    public void handleBytesWritten(long deltaCount, long totalWritten, long totalToSend) {
        if (this.uploadComplete) {
            return;
        }
        int totalMarks = (int)((float)totalWritten / ((float)totalToSend / 100.0f));
        while (this.hashMarkCount < (long)totalMarks) {
            ++this.hashMarkCount;
            if (this.hashMarkCount % 25L == 0L) {
                if (this.hashMarkCount < 100L) {
                    this.out.println(String.format("uploaded %d%%", this.hashMarkCount));
                    continue;
                }
                this.uploadComplete = true;
                this.out.println("upload completed");
                this.out.println("deploying application to server(s)...");
                continue;
            }
            this.out.print(".");
        }
    }
}

