/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api;

import com.cloudbees.api.DateHelper;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="DatabaseInfo")
public class DatabaseInfo {
    private String name;
    private String owner;
    private String username;
    private String password;
    private String created;
    private String status;
    private String master;
    private String[] slaves;
    private int port;
    private Map<String, String> settings;

    public DatabaseInfo(String name, String owner, String username, String password, Date created, String status, String master, String[] slaves, int port) {
        this.name = name;
        this.owner = owner;
        this.username = username;
        this.password = password;
        this.created = DateHelper.toW3CDateString(created);
        this.status = status;
        this.master = master;
        this.slaves = slaves;
        this.port = port;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Date getCreated() {
        if (this.created == null) {
            return null;
        }
        try {
            return DateHelper.parseW3CDate(this.created);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getMaster() {
        return this.master;
    }

    public String[] getSlaves() {
        return this.slaves;
    }

    public int getPort() {
        return this.port;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }
}

