/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.api;

import com.cloudbees.api.AccountInfo;
import com.cloudbees.api.AccountKeysResponse;
import com.cloudbees.api.AccountListResponse;
import com.cloudbees.api.AccountRegionInfo;
import com.cloudbees.api.AccountRegionListResponse;
import com.cloudbees.api.ApplicationCheckSumsResponse;
import com.cloudbees.api.ApplicationConfigUpdateResponse;
import com.cloudbees.api.ApplicationConfiguration;
import com.cloudbees.api.ApplicationCreateResponse;
import com.cloudbees.api.ApplicationDeleteResponse;
import com.cloudbees.api.ApplicationDeployArchiveResponse;
import com.cloudbees.api.ApplicationDeployArgs;
import com.cloudbees.api.ApplicationDeployResponse;
import com.cloudbees.api.ApplicationGetSourceUrlResponse;
import com.cloudbees.api.ApplicationInfo;
import com.cloudbees.api.ApplicationInfoResponse;
import com.cloudbees.api.ApplicationInstallResponse;
import com.cloudbees.api.ApplicationInstanceInfo;
import com.cloudbees.api.ApplicationInstanceInvokeResponse;
import com.cloudbees.api.ApplicationInstanceListResponse;
import com.cloudbees.api.ApplicationInstanceStatusResponse;
import com.cloudbees.api.ApplicationJarHashesResponse;
import com.cloudbees.api.ApplicationListResponse;
import com.cloudbees.api.ApplicationRestartResponse;
import com.cloudbees.api.ApplicationScaleResponse;
import com.cloudbees.api.ApplicationSetMetaResponse;
import com.cloudbees.api.ApplicationSnapshotInfo;
import com.cloudbees.api.ApplicationSnapshotListResponse;
import com.cloudbees.api.ApplicationSnapshotStatusResponse;
import com.cloudbees.api.ApplicationStatusResponse;
import com.cloudbees.api.BeesClientBase;
import com.cloudbees.api.BeesClientConfiguration;
import com.cloudbees.api.BeesClientException;
import com.cloudbees.api.CBAccount;
import com.cloudbees.api.CBUser;
import com.cloudbees.api.CIInfo;
import com.cloudbees.api.ConfigurationParametersDeleteResponse;
import com.cloudbees.api.ConfigurationParametersResponse;
import com.cloudbees.api.ConfigurationParametersUpdateResponse;
import com.cloudbees.api.DatabaseCreateResponse;
import com.cloudbees.api.DatabaseDeleteResponse;
import com.cloudbees.api.DatabaseInfo;
import com.cloudbees.api.DatabaseInfoResponse;
import com.cloudbees.api.DatabaseListResponse;
import com.cloudbees.api.DatabaseSetPasswordResponse;
import com.cloudbees.api.DatabaseSnapshotDeleteResponse;
import com.cloudbees.api.DatabaseSnapshotDeployResponse;
import com.cloudbees.api.DatabaseSnapshotInfo;
import com.cloudbees.api.DatabaseSnapshotListResponse;
import com.cloudbees.api.ErrorResponse;
import com.cloudbees.api.HttpClientHelper;
import com.cloudbees.api.HttpReply;
import com.cloudbees.api.OauthClientImpl;
import com.cloudbees.api.RepositoryInfo;
import com.cloudbees.api.ResourceBindingInfo;
import com.cloudbees.api.SayHelloResponse;
import com.cloudbees.api.ServerInfo;
import com.cloudbees.api.ServerPoolDeleteResponse;
import com.cloudbees.api.ServerPoolInfo;
import com.cloudbees.api.ServerPoolListResponse;
import com.cloudbees.api.ServerReinitResponse;
import com.cloudbees.api.ServerRestoreResponse;
import com.cloudbees.api.ServerStatusResponse;
import com.cloudbees.api.ServiceListResponse;
import com.cloudbees.api.ServiceResourceBindResponse;
import com.cloudbees.api.ServiceResourceBindingListResponse;
import com.cloudbees.api.ServiceResourceDeleteResponse;
import com.cloudbees.api.ServiceResourceInfo;
import com.cloudbees.api.ServiceResourceInvokeInfo;
import com.cloudbees.api.ServiceResourceInvokeResponse;
import com.cloudbees.api.ServiceResourceListResponse;
import com.cloudbees.api.ServiceResourceResponse;
import com.cloudbees.api.ServiceResourceUnBindResponse;
import com.cloudbees.api.ServiceSubscriptionDeleteResponse;
import com.cloudbees.api.ServiceSubscriptionInfo;
import com.cloudbees.api.ServiceSubscriptionInvokeInfo;
import com.cloudbees.api.ServiceSubscriptionInvokeResponse;
import com.cloudbees.api.ServiceSubscriptionListResponse;
import com.cloudbees.api.ServiceSubscriptionResponse;
import com.cloudbees.api.UploadProgress;
import com.cloudbees.api.config.ConfigParameters;
import com.cloudbees.api.config.ParameterSettings;
import com.cloudbees.api.config.ResourceSettings;
import com.cloudbees.api.oauth.OauthClient;
import com.cloudbees.upload.ArchiveUtils;
import com.cloudbees.upload.JarUtils;
import com.cloudbees.utils.AppConfigHelper;
import com.cloudbees.utils.ZipHelper;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.TraceMethod;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.introspect.VisibilityChecker;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeesClient
extends BeesClientBase {
    private String encodedAccountAuthorization;
    private URL base;
    static Logger logger = Logger.getLogger(BeesClient.class.getSimpleName());
    static final ObjectMapper MAPPER = new ObjectMapper();

    public BeesClient(BeesClientConfiguration beesClientConfiguration) {
        super(beesClientConfiguration);
        this.init();
    }

    public BeesClient(String apikey, String secret) {
        this("https://api.cloudbees.com/api ", apikey, secret);
    }

    public BeesClient(String server, String apikey, String secret) {
        this(server, apikey, secret, null, null);
    }

    public BeesClient(String server, String apikey, String secret, String format, String version) {
        super(server, apikey, BeesClient.encodePassword(secret, version), format, version);
        this.init();
    }

    private void init() {
        BeesClientConfiguration conf = this.getBeesClientConfiguration();
        try {
            this.base = new URL(conf.getServerApiUrl());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid API URL:" + conf.getServerApiUrl(), e);
        }
        this.encodedAccountAuthorization = conf.getAuthorization();
    }

    public OauthClient getOauthClient() {
        String gc = this.base.toExternalForm();
        gc = gc.replace("//api.", "//grandcentral.");
        if ((gc = gc.replace("//api-staging.", "//grandcentral.")).equals(this.base.toExternalForm())) {
            throw new RuntimeException("Unable to determine GrandCentral URL from " + this.base.toExternalForm());
        }
        while (true) {
            int scheme = gc.indexOf("://");
            int path = gc.lastIndexOf(47);
            if (path <= scheme + 3) break;
            gc = gc.substring(0, path);
        }
        return new OauthClientImpl(this, gc);
    }

    public CBUser createUser(CBUser user) throws IOException {
        return this.jsonPOJORequest("v2/users", user, CBUser.class, "POST");
    }

    public CBUser updateUser(String id, CBUser user) throws IOException {
        return this.jsonPOJORequest("v2/users/" + id, user, CBUser.class, "PATCH");
    }

    public void deleteUser(String id) throws IOException {
        this.jsonPOJORequest("v2/users/" + id, null, null, "DELETE");
    }

    public CBUser addUserToAccount(CBAccount account, CBUser user) throws IOException {
        return this.jsonPOJORequest("v2/users/" + user.id + "/accounts/" + account.name + "/users", user, CBUser.class, "POST");
    }

    protected <T> T jsonPOJORequest(String apiTail, Object request, Class<T> type, String method) throws IOException {
        String content = null;
        if (request != null) {
            content = MAPPER.writeValueAsString(request);
        }
        HttpReply resp = this.jsonRequest(apiTail, method, null, content);
        return resp.bind(type, this);
    }

    public HttpReply jsonRequest(String urlTail, String method, Map<String, String> headers, String jsonContent) throws IOException {
        Object httpMethod;
        String urlString = this.absolutize(urlTail);
        this.trace("API call: " + urlString);
        if (method.equalsIgnoreCase("GET")) {
            httpMethod = new GetMethod(urlString);
        } else if (method.equalsIgnoreCase("POST")) {
            httpMethod = new PostMethod(urlString);
        } else if (method.equalsIgnoreCase("PUT")) {
            httpMethod = new PutMethod(urlString);
        } else if (method.equalsIgnoreCase("DELETE")) {
            httpMethod = new DeleteMethod(urlString);
        } else if (method.equalsIgnoreCase("PATCH")) {
            httpMethod = new PatchMethod(urlString);
        } else if (method.equalsIgnoreCase("HEAD")) {
            httpMethod = new HeadMethod(urlString);
        } else if (method.equalsIgnoreCase("TRACE")) {
            httpMethod = new TraceMethod(urlString);
        } else if (method.equalsIgnoreCase("OPTIONS")) {
            httpMethod = new OptionsMethod(urlString);
        } else {
            throw new IOException("Method not supported: " + method);
        }
        httpMethod.setRequestHeader("Accept", "application/json");
        if (jsonContent != null && httpMethod instanceof EntityEnclosingMethod) {
            StringRequestEntity requestEntity = new StringRequestEntity(jsonContent, "application/json", "UTF-8");
            ((EntityEnclosingMethod)httpMethod).setRequestEntity((RequestEntity)requestEntity);
            this.trace("Payload: " + jsonContent);
        }
        return this.executeRequest((HttpMethod)httpMethod, headers);
    }

    HttpReply formUrlEncoded(String urlTail, Map<String, String> headers, Map<String, List<String>> params) throws IOException {
        String urlString = this.absolutize(urlTail);
        this.trace("API call: " + urlString);
        PostMethod httpMethod = new PostMethod(urlString);
        httpMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        for (Map.Entry<String, List<String>> e : params.entrySet()) {
            for (String v : e.getValue()) {
                httpMethod.addParameter(e.getKey(), v);
            }
        }
        return this.executeRequest((HttpMethod)httpMethod, headers);
    }

    private String absolutize(String urlTail) throws IOException {
        String urlString;
        URL url = new URL(this.base, urlTail);
        try {
            urlString = url.toURI().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid API URL:" + url.toString(), e);
        }
        return urlString;
    }

    private HttpReply executeRequest(HttpMethod httpMethod, Map<String, String> headers) throws IOException {
        BeesClientConfiguration conf = this.getBeesClientConfiguration();
        HttpClient httpClient = HttpClientHelper.createClient((BeesClientConfiguration)conf);
        if (this.encodedAccountAuthorization != null) {
            httpMethod.setRequestHeader("Authorization", this.encodedAccountAuthorization);
        }
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpMethod.setRequestHeader(entry.getKey(), entry.getValue());
            }
        }
        int status = 500;
        String rsp = "Error";
        try {
            status = httpClient.executeMethod(httpMethod);
            rsp = IOUtils.toString((InputStream)httpMethod.getResponseBodyAsStream());
        }
        catch (IOException e) {
            throw (IOException)new IOException("Failed to " + httpMethod.getName() + " : " + httpMethod.getURI() + " : code=" + status + " response=" + e.getMessage()).initCause(e);
        }
        finally {
            httpMethod.releaseConnection();
        }
        this.trace(status + ": " + rsp);
        return new HttpReply(httpMethod, status, rsp);
    }

    public CBAccount getAccount(String name) throws IOException {
        return this.jsonPOJORequest("v2/accounts/" + name, null, CBAccount.class, "GET");
    }

    public CBUser getUser(String id) throws IOException {
        return this.jsonPOJORequest("v2/users/" + id, null, CBUser.class, "GET");
    }

    public CBUser getSelfUser() throws IOException {
        return this.getUser("self");
    }

    public CBUser getUserByFingerprint(String sshPublicKeyFingerprint) throws IOException {
        return this.jsonPOJORequest("v2/users/fingerprint/" + sshPublicKeyFingerprint, null, CBUser.class, "GET");
    }

    public SayHelloResponse sayHello(String message) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("message", message);
        String url = this.getRequestURL("say.hello", params);
        String response = this.executeRequest(url);
        return (SayHelloResponse)this.readResponse(response);
    }

    public ApplicationGetSourceUrlResponse applicationGetSourceUrl(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.getSourceUrl", params);
        String response = this.executeRequest(url);
        return (ApplicationGetSourceUrlResponse)this.readResponse(response);
    }

    public ApplicationDeleteResponse applicationDelete(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.delete", params);
        String response = this.executeRequest(url);
        return (ApplicationDeleteResponse)this.readResponse(response);
    }

    public ApplicationRestartResponse applicationRestart(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.restart", params);
        String response = this.executeRequest(url);
        return (ApplicationRestartResponse)this.readResponse(response);
    }

    public ApplicationStatusResponse applicationStart(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.start", params);
        String response = this.executeRequest(url);
        return (ApplicationStatusResponse)this.readResponse(response);
    }

    public ApplicationStatusResponse applicationStop(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.stop", params);
        String response = this.executeRequest(url);
        return (ApplicationStatusResponse)this.readResponse(response);
    }

    public ApplicationStatusResponse applicationHibernate(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.hibernate", params);
        String response = this.executeRequest(url);
        ApplicationStatusResponse apiResponse = (ApplicationStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationListResponse applicationList() throws Exception {
        return this.applicationList(null);
    }

    public ApplicationListResponse applicationList(String account) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (account != null) {
            params.put("account", account);
        }
        String url = this.getRequestURL("application.list", params);
        String response = this.executeRequest(url);
        return (ApplicationListResponse)this.readResponse(response);
    }

    public ApplicationInfo applicationInfo(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.info", params);
        String response = this.executeRequest(url);
        ApplicationInfoResponse apiResponse = (ApplicationInfoResponse)this.readResponse(response);
        return apiResponse.getApplicationInfo();
    }

    public ApplicationSetMetaResponse applicationSetMeta(String appId, Map<String, String> metaAttrs) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(metaAttrs);
        params.put("app_id", appId);
        String url = this.getRequestURL("application.setMeta", params);
        String response = this.executeRequest(url);
        return (ApplicationSetMetaResponse)this.readResponse(response);
    }

    public ApplicationJarHashesResponse applicationJarCrcs(String appId, Map<String, String> hashes) throws Exception {
        return this.applicationJarHashes(appId, hashes);
    }

    public ApplicationJarHashesResponse applicationJarHashes(String appId, Map<String, String> hashes) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        params.put("hashes", this.createParameter(hashes));
        String url = this.getApiUrl("application.jarHashes").toString();
        params.put("action", "application.jarHashes");
        String response = this.executeUpload(url, params, new HashMap<String, File>(), null);
        return (ApplicationJarHashesResponse)this.readResponse(response);
    }

    @Deprecated
    public ApplicationDeployArchiveResponse applicationDeployEar(String appId, String environment, String description, String earFile, String srcFile, UploadProgress progress) throws Exception {
        return this.applicationDeployEar(appId, environment, description, BeesClient.asFile(earFile), BeesClient.asFile(srcFile), progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployEar(String appId, String environment, String description, File earFile, File srcFile, UploadProgress progress) throws Exception {
        String archiveType = "ear";
        return this.applicationDeployArchive(appId, environment, description, earFile, srcFile, archiveType, false, progress);
    }

    @Deprecated
    public ApplicationDeployArchiveResponse applicationDeployWar(String appId, String environment, String description, String warFile, String srcFile, UploadProgress progress) throws Exception {
        return this.applicationDeployWar(appId, environment, description, BeesClient.asFile(warFile), BeesClient.asFile(srcFile), progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployWar(String appId, String environment, String description, File warFile, File srcFile, UploadProgress progress) throws Exception {
        return this.applicationDeployWar(appId, environment, description, warFile, srcFile, true, progress);
    }

    @Deprecated
    public ApplicationDeployArchiveResponse applicationDeployWar(String appId, String environment, String description, String warFile, String srcFile, boolean deltaDeploy, UploadProgress progress) throws Exception {
        return this.applicationDeployWar(appId, environment, description, BeesClient.asFile(warFile), BeesClient.asFile(srcFile), deltaDeploy, progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployWar(String appId, String environment, String description, File warFile, File srcFile, boolean deltaDeploy, UploadProgress progress) throws Exception {
        String archiveType = "war";
        return this.applicationDeployArchive(appId, environment, description, warFile, srcFile, archiveType, deltaDeploy, progress);
    }

    @Deprecated
    public ApplicationDeployArchiveResponse applicationDeployArchive(String appId, String environment, String description, String earFile, String srcFile, String archiveType, UploadProgress progress) throws Exception {
        return this.applicationDeployArchive(appId, environment, description, BeesClient.asFile(earFile), BeesClient.asFile(srcFile), archiveType, progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployArchive(String appId, String environment, String description, File earFile, File srcFile, String archiveType, UploadProgress progress) throws Exception {
        return this.applicationDeployArchive(appId, environment, description, earFile, srcFile, archiveType, false, progress);
    }

    @Deprecated
    public ApplicationDeployArchiveResponse applicationDeployArchive(String appId, String environment, String description, String earFile, String srcFile, String archiveType, boolean deltaDeploy, UploadProgress progress) throws Exception {
        return this.applicationDeployArchive(appId, environment, description, BeesClient.asFile(earFile), BeesClient.asFile(srcFile), archiveType, deltaDeploy, progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployArchive(String appId, String environment, String description, File earFile, File srcFile, String archiveType, boolean deltaDeploy, UploadProgress progress) throws Exception {
        return this.applicationDeployArchive(appId, environment, description, earFile, srcFile, archiveType, deltaDeploy, null, progress);
    }

    @Deprecated
    public ApplicationDeployArchiveResponse applicationDeployArchive(String appId, String environment, String description, String earFile, String srcFile, String archiveType, boolean deltaDeploy, Map<String, String> parameters, UploadProgress progress) throws Exception {
        return this.applicationDeployArchive(appId, environment, description, BeesClient.asFile(earFile), BeesClient.asFile(srcFile), archiveType, deltaDeploy, parameters, progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployArchive(String appId, String environment, String description, File earFile, File srcFile, String archiveType, boolean deltaDeploy, Map<String, String> parameters, UploadProgress progress) throws Exception {
        return this.applicationDeployArchive(new ApplicationDeployArgs.Builder(appId).environment(environment).description(description).deployPackage(earFile, archiveType).srcFile(srcFile).incrementalDeployment(deltaDeploy).withParams(parameters).withProgressFeedback(progress).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationDeployArchiveResponse applicationDeployArchive(ApplicationDeployArgs args) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, File> fileParams = new HashMap<String, File>();
        params.put("app_id", args.appId);
        File archiveFile = args.archiveFile;
        boolean deployDelta = false;
        boolean deployJarDelta = false;
        if (args.deltaDeploy && !args.archiveType.equals("ear")) {
            this.trace("Get existing checksums");
            ApplicationCheckSumsResponse applicationCheckSumsResponse = this.applicationCheckSums(args.appId, false);
            if (logger.isLoggable(Level.FINER)) {
                for (Map.Entry<String, Long> entry : applicationCheckSumsResponse.getCheckSums().entrySet()) {
                    logger.finer("Entry: " + entry.getKey() + " CRC: " + entry.getValue());
                }
            }
            if (applicationCheckSumsResponse.getCheckSums().size() == 0) {
                this.trace("No existing checksums, upload full archive");
            } else {
                this.trace("Creating Delta archive for: " + archiveFile);
                archiveFile = ArchiveUtils.createDeltaWarFile(applicationCheckSumsResponse.getCheckSums(), archiveFile, archiveFile.getParent());
                deployDelta = true;
                if (applicationCheckSumsResponse.getSnapshotID() != null) {
                    params.put("delta_snapshot_id", applicationCheckSumsResponse.getSnapshotID());
                }
            }
        }
        if (args.deltaDeploy && !args.archiveType.equals("ear")) {
            this.trace("Get existing jar hashes");
            ApplicationJarHashesResponse applicationJarHashesResponse = this.applicationJarHashes(args.appId, JarUtils.getJarHashes(archiveFile));
            if (applicationJarHashesResponse.getJarHash().size() == 0) {
                this.trace("No existing jars");
            } else {
                this.trace("Creating Delta2 archive for: " + archiveFile);
                File archiveFile2 = JarUtils.createDeltaWarFile(applicationJarHashesResponse.getJarHash(), archiveFile, archiveFile.getParent());
                if (deployDelta) {
                    archiveFile.delete();
                }
                archiveFile = archiveFile2;
                deployJarDelta = true;
            }
        }
        if (deployDelta || deployJarDelta) {
            this.trace("Uploading delta archive: " + archiveFile);
        }
        File archiveFileSrc = args.srcFile;
        long uploadSize = archiveFile.length();
        if (archiveFileSrc != null) {
            uploadSize += archiveFileSrc.length();
        }
        fileParams.put("archive", archiveFile);
        params.put("archive_type", args.archiveType);
        params.put("create", Boolean.valueOf(args.create).toString());
        if (args.environment != null) {
            params.put("environment", args.environment);
        }
        if (args.description != null) {
            params.put("description", args.description);
        }
        if (archiveFileSrc != null) {
            fileParams.put("src", archiveFileSrc);
        }
        params.put("parameters", this.createParameter(args.parameters));
        params.put("variables", this.createParameter(args.variables));
        long expireTime = System.currentTimeMillis() + 14400000L;
        params.put("expires", Long.toString(expireTime / 1000L));
        String url = this.getApiUrl("application.deployArchive").toString();
        params.put("action", "application.deployArchive");
        String response = this.executeUpload(url, params, fileParams, args.progress);
        try {
            ApplicationDeployArchiveResponse applicationDeployArchiveResponse = (ApplicationDeployArchiveResponse)this.readResponse(response);
            return applicationDeployArchiveResponse;
        }
        finally {
            if (deployDelta || deployJarDelta) {
                archiveFile.delete();
            }
        }
    }

    public ApplicationCheckSumsResponse applicationCheckSums(String appId) throws Exception {
        return this.applicationCheckSums(appId, true);
    }

    public ApplicationCheckSumsResponse applicationCheckSums(String appId, boolean traceResponse) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.checkSums", params);
        String response = this.executeRequest(url);
        return (ApplicationCheckSumsResponse)this.readResponse(response);
    }

    public ApplicationScaleResponse applicationScale(String appId, int unit) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("unit", "" + unit);
        params.put("app_id", appId);
        String url = this.getRequestURL("application.scale", params);
        String response = this.executeRequest(url);
        return (ApplicationScaleResponse)this.readResponse(response);
    }

    public DatabaseCreateResponse databaseCreate(String domain, String dbId, String username, String password) throws Exception {
        return this.databaseCreate(domain, dbId, username, password, null);
    }

    public DatabaseCreateResponse databaseCreate(String domain, String dbId, String username, String password, String plan) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        params.put("database_username", username);
        params.put("database_password", password);
        params.put("domain", domain);
        if (plan != null) {
            params.put("database_plan", plan);
        }
        String url = this.getRequestURL("database.create", params);
        String response = this.executeRequest(url);
        return (DatabaseCreateResponse)this.readResponse(response);
    }

    public DatabaseDeleteResponse databaseDelete(String dbId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        String url = this.getRequestURL("database.delete", params);
        String response = this.executeRequest(url);
        return (DatabaseDeleteResponse)this.readResponse(response);
    }

    public DatabaseInfo databaseInfo(String dbId, boolean fetchPassword) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        params.put("fetch_password", Boolean.valueOf(fetchPassword).toString());
        String url = this.getRequestURL("database.info", params);
        String response = this.executeRequest(url);
        DatabaseInfoResponse apiResponse = (DatabaseInfoResponse)this.readResponse(response);
        return apiResponse.getDatabaseInfo();
    }

    public DatabaseListResponse databaseList() throws Exception {
        return this.databaseList(null);
    }

    public DatabaseListResponse databaseList(String account) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (account != null) {
            params.put("account", account);
        }
        String url = this.getRequestURL("database.list", params);
        String response = this.executeRequest(url);
        return (DatabaseListResponse)this.readResponse(response);
    }

    public DatabaseSetPasswordResponse databaseSetPassword(String dbId, String password) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        params.put("database_password", password);
        String url = this.getRequestURL("database.setPassword", params);
        String response = this.executeRequest(url);
        return (DatabaseSetPasswordResponse)this.readResponse(response);
    }

    public DatabaseSnapshotListResponse databaseSnapshotList(String dbId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        String url = this.getRequestURL("database.snapshot.list", params);
        String response = this.executeRequest(url);
        return (DatabaseSnapshotListResponse)this.readResponse(response);
    }

    public DatabaseSnapshotDeleteResponse databaseSnapshotDelete(String dbId, String snapshotId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        params.put("snapshot_id", snapshotId);
        String url = this.getRequestURL("database.snapshot.delete", params);
        String response = this.executeRequest(url);
        return (DatabaseSnapshotDeleteResponse)this.readResponse(response);
    }

    public DatabaseSnapshotDeployResponse databaseSnapshotDeploy(String dbId, String snapshotId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        params.put("snapshot_id", snapshotId);
        String url = this.getRequestURL("database.snapshot.deploy", params);
        String response = this.executeRequest(url);
        return (DatabaseSnapshotDeployResponse)this.readResponse(response);
    }

    public DatabaseSnapshotInfo databaseSnapshotCreate(String dbId, String snapshotTitle) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        if (snapshotTitle != null) {
            params.put("snapshot_title", snapshotTitle);
        }
        String url = this.getRequestURL("database.snapshot.create", params);
        String response = this.executeRequest(url);
        return (DatabaseSnapshotInfo)this.readResponse(response);
    }

    public AccountKeysResponse accountKeys(String domain, String user, String password) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", user);
        params.put("password", password);
        if (domain != null) {
            params.put("domain", domain);
        }
        String url = this.getRequestURL("account.keys", params);
        String response = this.executeRequest(url);
        return (AccountKeysResponse)this.readResponse(response);
    }

    public AccountListResponse accountList() throws Exception {
        HashMap params = new HashMap();
        String url = this.getRequestURL("account.list", params);
        String response = this.executeRequest(url);
        return (AccountListResponse)this.readResponse(response);
    }

    public ApplicationConfiguration getApplicationConfiguration(String warFilePath, String account, String[] environments) throws Exception {
        File deployFile = BeesClient.asFile(warFilePath);
        if (!deployFile.exists()) {
            throw new IllegalArgumentException("File not found: " + warFilePath);
        }
        ApplicationConfiguration appConfig = BeesClient.getAppConfig(deployFile, environments, new String[]{"deploy"});
        String appid = appConfig.getApplicationId();
        if (appid == null || appid.equals("")) {
            throw new IllegalArgumentException("No application id specified");
        }
        String[] appIdParts = appid.split("/");
        if (appIdParts.length < 2) {
            if (account != null && !account.equals("")) {
                appConfig.setApplicationId(account + "/" + appid);
            } else {
                throw new IllegalArgumentException("Application account not specified");
            }
        }
        return appConfig;
    }

    public ConfigurationParametersUpdateResponse configurationParametersUpdate(String resourceId, String configType, File resourceFile) throws Exception {
        this.assertNotNull(resourceId, "resourceId");
        this.assertNotNull(configType, "configType");
        this.assertNotNull(resourceFile, "resourceFile");
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, File> fileParams = new HashMap<String, File>();
        params.put("resource_id", resourceId);
        params.put("config_type", configType);
        fileParams.put("resources", resourceFile);
        String url = this.getApiUrl("configuration.parameters.update").toString();
        params.put("action", "configuration.parameters.update");
        String response = this.executeUpload(url, params, fileParams, null);
        return (ConfigurationParametersUpdateResponse)this.readResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationParametersUpdateResponse configurationParametersUpdate(String resourceId, String configType, ConfigParameters model) throws Exception {
        ConfigurationParametersUpdateResponse configurationParametersUpdateResponse;
        File xmlFile = File.createTempFile("conf", "xml");
        FileWriter fos = null;
        try {
            fos = new FileWriter(xmlFile);
            fos.write(model.toXML());
            fos.close();
            configurationParametersUpdateResponse = this.configurationParametersUpdate(resourceId, configType, xmlFile);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            xmlFile.delete();
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fos);
        xmlFile.delete();
        return configurationParametersUpdateResponse;
    }

    public ConfigurationParametersDeleteResponse configurationParametersDelete(String resourceId, String configType) throws Exception {
        this.assertNotNull(resourceId, "resourceId");
        this.assertNotNull(configType, "configType");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource_id", resourceId);
        params.put("config_type", configType);
        String url = this.getRequestURL("configuration.parameters.delete", params);
        String response = this.executeRequest(url);
        return (ConfigurationParametersDeleteResponse)this.readResponse(response);
    }

    public ConfigurationParametersResponse configurationParameters(String resourceId, String configType) throws Exception {
        this.assertNotNull(resourceId, "resourceId");
        this.assertNotNull(configType, "configType");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource_id", resourceId);
        params.put("config_type", configType);
        String url = this.getRequestURL("configuration.parameters", params);
        String response = this.executeRequest(url);
        return (ConfigurationParametersResponse)this.readResponse(response);
    }

    public ConfigParameters configurationParametersAsObject(String resourceId, String configType) throws Exception {
        return ConfigParameters.parse(this.configurationParameters(resourceId, configType).getConfiguration());
    }

    public ServiceListResponse serviceList(String account) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        String url = this.getRequestURL("service.list", params);
        String response = this.executeRequest(url);
        return (ServiceListResponse)this.readResponse(response);
    }

    public ServiceSubscriptionInfo serviceSubscribe(String service, String plan, String account, Map<String, String> settings) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        params.put("service", service);
        if (plan != null) {
            params.put("plan", plan);
        }
        params.put("settings", this.createParameter(settings));
        String url = this.getRequestURL("service.subscribe", params);
        String response = this.executeRequest(url);
        return ((ServiceSubscriptionResponse)this.readResponse(response)).getSubscription();
    }

    public ServiceSubscriptionDeleteResponse serviceUnSubscribe(String service, String subscriptionId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscription_id", subscriptionId);
        params.put("service", service);
        String url = this.getRequestURL("service.unsubscribe", params);
        String response = this.executeRequest(url);
        return (ServiceSubscriptionDeleteResponse)this.readResponse(response);
    }

    public ServiceSubscriptionInfo serviceSubscriptionUpdate(String service, String plan, String subscriptionId, Map<String, String> settings) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscription_id", subscriptionId);
        params.put("service", service);
        if (plan != null) {
            params.put("plan", plan);
        }
        params.put("settings", this.createParameter(settings));
        String url = this.getRequestURL("service.subscription.update", params);
        String response = this.executeRequest(url);
        return ((ServiceSubscriptionResponse)this.readResponse(response)).getSubscription();
    }

    public ServiceSubscriptionInfo serviceSubscriptionInfo(String service, String subscriptionId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscription_id", subscriptionId);
        params.put("service", service);
        String url = this.getRequestURL("service.subscription.info", params);
        String response = this.executeRequest(url);
        return ((ServiceSubscriptionResponse)this.readResponse(response)).getSubscription();
    }

    public ServiceSubscriptionListResponse serviceSubscriptionList(String account) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        String url = this.getRequestURL("service.subscription.list", params);
        String response = this.executeRequest(url);
        return (ServiceSubscriptionListResponse)this.readResponse(response);
    }

    public ServiceResourceInfo serviceResourceInfo(String service, String resourceId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("resource_id", resourceId);
        String url = this.getRequestURL("service.resource.info", params);
        String response = this.executeRequest(url);
        return ((ServiceResourceResponse)this.readResponse(response)).getResource();
    }

    public ServiceResourceListResponse serviceResourceList(String service, String account, String resourceType) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        params.put("service", service);
        if (resourceType != null) {
            params.put("resource_type", resourceType);
        }
        String url = this.getRequestURL("service.resource.list", params);
        String response = this.executeRequest(url);
        return (ServiceResourceListResponse)this.readResponse(response);
    }

    public ServiceResourceBindingListResponse resourceBindingList(String service, String resourceId) throws Exception {
        return this.resourceBindingList(service, resourceId, false);
    }

    public ServiceResourceBindingListResponse resourceBindingList(String service, String resourceId, boolean bidirectional) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource_id", resourceId);
        params.put("service", service);
        params.put("bidirectional", Boolean.toString(bidirectional));
        String url = this.getRequestURL("resource.binding.list", params);
        String response = this.executeRequest(url);
        ServiceResourceBindingListResponse apiResponse = (ServiceResourceBindingListResponse)this.readResponse(response);
        return apiResponse;
    }

    public AccountRegionListResponse accountRegionList(String account, String service) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        if (service != null) {
            params.put("service", service);
        }
        String url = this.getRequestURL("account.region.list", params);
        String response = this.executeRequest(url);
        return (AccountRegionListResponse)this.readResponse(response);
    }

    public ApplicationInstanceListResponse applicationInstanceList(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.instance.list", params);
        String response = this.executeRequest(url);
        ApplicationInstanceListResponse apiResponse = (ApplicationInstanceListResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationInstanceStatusResponse applicationInstanceReplace(String instanceId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instance_id", instanceId);
        String url = this.getRequestURL("application.instance.replace", params);
        String response = this.executeRequest(url);
        ApplicationInstanceStatusResponse apiResponse = (ApplicationInstanceStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationInstanceStatusResponse applicationInstanceRestart(String instanceId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instance_id", instanceId);
        String url = this.getRequestURL("application.instance.restart", params);
        String response = this.executeRequest(url);
        ApplicationInstanceStatusResponse apiResponse = (ApplicationInstanceStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationInstanceStatusResponse applicationInstanceDelete(String instanceId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instance_id", instanceId);
        String url = this.getRequestURL("application.instance.delete", params);
        String response = this.executeRequest(url);
        ApplicationInstanceStatusResponse apiResponse = (ApplicationInstanceStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationInstanceInfo applicationInstanceTagsUpdate(String instanceId, Map<String, String> tags, boolean replace) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instance_id", instanceId);
        params.put("reset", Boolean.toString(replace));
        params.put("parameters", this.createParameter(tags));
        String url = this.getApiUrl("application.instance.update").toString();
        params.put("action", "application.instance.update");
        String response = this.executeUpload(url, params, new HashMap<String, File>(), null);
        ApplicationInstanceInfo apiResponse = (ApplicationInstanceInfo)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationInstanceInfo applicationInstanceInfo(String instanceId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instance_id", instanceId);
        String url = this.getRequestURL("application.instance.info", params);
        String response = this.executeRequest(url);
        ApplicationInstanceInfo apiResponse = (ApplicationInstanceInfo)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationInstanceInvokeResponse applicationInstanceInvoke(String instanceId, String invoke, Map<String, String> parameters) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instance_id", instanceId);
        params.put("invoke", invoke);
        params.put("parameters", this.createParameter(parameters));
        String url = this.getRequestURL("application.instance.invoke", params);
        String response = this.executeRequest(url);
        ApplicationInstanceInvokeResponse apiResponse = (ApplicationInstanceInvokeResponse)this.readResponse(response);
        return apiResponse;
    }

    public void applicationInstanceTailLog(String instanceId, String logName, OutputStream out) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instance_id", instanceId);
        params.put("log_name", logName);
        String url = this.getRequestURL("tail", params, false);
        this.trace("API call: " + url);
        InputStream input = this.executeCometRequest(url);
        byte[] bytes = new byte[1024];
        int numRead = input.read(bytes);
        while (numRead != -1) {
            out.write(bytes, 0, numRead);
            numRead = input.read(bytes);
        }
    }

    public ApplicationSnapshotListResponse applicationSnapshotList(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.snapshot.list", params);
        String response = this.executeRequest(url);
        return (ApplicationSnapshotListResponse)this.readResponse(response);
    }

    public ApplicationSnapshotStatusResponse applicationSnapshotDelete(String snapshotId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("snapshot_id", snapshotId);
        String url = this.getRequestURL("application.snapshot.delete", params);
        String response = this.executeRequest(url);
        ApplicationSnapshotStatusResponse apiResponse = (ApplicationSnapshotStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationSnapshotInfo applicationSnapshotInfo(String snapshotId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("snapshot_id", snapshotId);
        String url = this.getRequestURL("application.snapshot.info", params);
        String response = this.executeRequest(url);
        ApplicationSnapshotInfo apiResponse = (ApplicationSnapshotInfo)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationSnapshotStatusResponse applicationSnapshotUpdate(String snapshotId, Map<String, String> parameters) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("snapshot_id", snapshotId);
        params.put("parameters", this.createParameter(parameters));
        String url = this.getRequestURL("application.snapshot.update", params);
        String response = this.executeRequest(url);
        ApplicationSnapshotStatusResponse apiResponse = (ApplicationSnapshotStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationStatusResponse applicationProxyUpdate(String appId, Map<String, String> parameters) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        params.put("parameters", this.createParameter(parameters));
        String url = this.getRequestURL("application.proxy.update", params);
        String response = this.executeRequest(url);
        ApplicationStatusResponse apiResponse = (ApplicationStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationConfigUpdateResponse applicationConfigUpdate(String appId, Map<String, String> parameters) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        params.put("parameters", this.createParameter(parameters));
        String url = this.getRequestURL("application.config.update", params);
        String response = this.executeRequest(url);
        ApplicationConfigUpdateResponse apiResponse = (ApplicationConfigUpdateResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServiceResourceBindResponse resourceBind(String fromService, String fromResourceId, String toService, String toResourceId, String alias, Map<String, String> settings) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("to_service", toService);
        params.put("to_resource_id", toResourceId);
        params.put("from_service", fromService);
        params.put("from_resource_id", fromResourceId);
        params.put("alias", alias);
        params.put("settings", this.createParameter(settings));
        String url = this.getRequestURL("service.resource.bind", params);
        String response = this.executeRequest(url);
        ServiceResourceBindResponse apiResponse = (ServiceResourceBindResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServiceResourceUnBindResponse resourceUnBind(String service, String resourceId, String alias) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("alias", alias);
        params.put("service", service);
        params.put("resource_id", resourceId);
        String url = this.getRequestURL("service.resource.unbind", params);
        String response = this.executeRequest(url);
        ServiceResourceUnBindResponse apiResponse = (ServiceResourceUnBindResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServiceResourceInfo serviceResourceCreate(String service, String account, String resourceType, String resourceName, Map<String, String> settings) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        params.put("service", service);
        if (resourceType != null) {
            params.put("resource_type", resourceType);
        }
        params.put("resource_name", resourceName);
        params.put("settings", this.createParameter(settings));
        ServiceResourceResponse apiResponse = (ServiceResourceResponse)this.apiCall("service.resource.create", settings, params);
        return apiResponse.getResource();
    }

    public ServiceResourceInfo serviceResourceUpdate(String service, String resourceId, Map<String, String> settings) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("resource_id", resourceId);
        params.put("settings", this.createParameter(settings));
        ServiceResourceResponse apiResponse = (ServiceResourceResponse)this.apiCall("service.resource.update", settings, params);
        return apiResponse.getResource();
    }

    public ServiceResourceDeleteResponse serviceResourceDelete(String service, String resourceId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("resource_id", resourceId);
        String url = this.getRequestURL("service.resource.delete", params);
        String response = this.executeRequest(url);
        ServiceResourceDeleteResponse apiResponse = (ServiceResourceDeleteResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationCreateResponse applicationCreate(String appId, Map<String, String> parameters) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        params.put("parameters", this.createParameter(parameters));
        String url = this.getRequestURL("application.create", params);
        String response = this.executeRequest(url);
        ApplicationCreateResponse apiResponse = (ApplicationCreateResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServerPoolInfo serverPoolCreate(String account, String poolName, Map<String, String> parameters) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        params.put("pool_name", poolName);
        params.put("parameters", this.createParameter(parameters));
        String url = this.getRequestURL("server.pool.create", params);
        String response = this.executeRequest(url);
        ServerPoolInfo apiResponse = (ServerPoolInfo)this.readResponse(response);
        return apiResponse;
    }

    public ServerPoolInfo serverPoolInfo(String poolId) throws Exception {
        return this.serverPoolInfo(poolId, false);
    }

    public ServerPoolInfo serverPoolInfo(String poolId, boolean withApplications) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pool_id", poolId);
        if (withApplications) {
            params.put("with_applications", "true");
        }
        String url = this.getRequestURL("server.pool.info", params);
        String response = this.executeRequest(url);
        ServerPoolInfo apiResponse = (ServerPoolInfo)this.readResponse(response);
        return apiResponse;
    }

    public ServerPoolListResponse serverPoolList(String account) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("account", account);
        String url = this.getRequestURL("server.pool.list", params);
        String response = this.executeRequest(url);
        ServerPoolListResponse apiResponse = (ServerPoolListResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServerPoolDeleteResponse serverPoolDelete(String poolId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pool_id", poolId);
        String url = this.getRequestURL("server.pool.delete", params);
        String response = this.executeRequest(url);
        ServerPoolDeleteResponse apiResponse = (ServerPoolDeleteResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServerInfo serverCreate(String poolId, Map<String, String> parameters) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("pool_id", poolId);
        params.put("parameters", this.createParameter(parameters));
        String url = this.getRequestURL("server.create", params);
        String response = this.executeRequest(url);
        ServerInfo apiResponse = (ServerInfo)this.readResponse(response);
        return apiResponse;
    }

    public ServerRestoreResponse serverRestore(String serverId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("server_id", serverId);
        String url = this.getRequestURL("server.restore", params);
        String response = this.executeRequest(url);
        ServerRestoreResponse apiResponse = (ServerRestoreResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServerInfo serverInfo(String serverId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("server_id", serverId);
        String url = this.getRequestURL("server.info", params);
        String response = this.executeRequest(url);
        ServerInfo apiResponse = (ServerInfo)this.readResponse(response);
        return apiResponse;
    }

    public ServerStatusResponse serverStop(String serverId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("server_id", serverId);
        String url = this.getRequestURL("server.stop", params);
        String response = this.executeRequest(url);
        ServerStatusResponse apiResponse = (ServerStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServerStatusResponse serverDelete(String serverId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("server_id", serverId);
        String url = this.getRequestURL("server.delete", params);
        String response = this.executeRequest(url);
        ServerStatusResponse apiResponse = (ServerStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServerStatusResponse serverDeactivate(String serverId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("server_id", serverId);
        String url = this.getRequestURL("server.deactivate", params);
        String response = this.executeRequest(url);
        ServerStatusResponse apiResponse = (ServerStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ServiceSubscriptionInvokeInfo serviceSubscriptionInvoke(String service, String subscriptionId, String invoke, Map<String, String> parameters) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("subscription_id", subscriptionId);
        params.put("invoke", invoke);
        params.put("parameters", this.createParameter(parameters));
        ServiceSubscriptionInvokeResponse apiResponse = (ServiceSubscriptionInvokeResponse)this.apiCall("service.subscription.invoke", parameters, params);
        return apiResponse.getInvokeInfo();
    }

    public ServiceResourceInvokeInfo serviceResourceInvoke(String service, String resourceId, String invoke, Map<String, String> parameters) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", service);
        params.put("resource_id", resourceId);
        params.put("invoke", invoke);
        params.put("parameters", this.createParameter(parameters));
        ServiceResourceInvokeResponse apiResponse = (ServiceResourceInvokeResponse)this.apiCall("service.resource.invoke", parameters, params);
        return apiResponse.getInvokeInfo();
    }

    public ApplicationCreateResponse applicationCreate(String appId, Map<String, String> parameters, Map<String, String> appParameters, Map<String, String> appVariables) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        params.put("parameters", this.createParameter(parameters));
        params.put("app_parameters", this.createParameter(appParameters));
        params.put("app_variables", this.createParameter(appVariables));
        String url = this.getRequestURL("application.create", params);
        String response = this.executeRequest(url);
        ApplicationCreateResponse apiResponse = (ApplicationCreateResponse)this.readResponse(response);
        return apiResponse;
    }

    public List<ResourceSettings> applicationResources(String appId, String resourceType, String configType, String environment) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        if (environment != null) {
            params.put("environment", environment);
        }
        if (resourceType != null) {
            params.put("resource_type", resourceType);
        }
        if (configType != null) {
            params.put("config_type", configType);
        }
        String url = this.getRequestURL("application.resources", params);
        String response = this.executeRequest(url);
        List apiResponse = (List)this.readResponse(response);
        return apiResponse;
    }

    public String executeRequest(String url) throws Exception {
        this.trace("API call: " + url);
        String response = super.executeRequest(url);
        this.traceResponse(response);
        return response;
    }

    protected String executeUpload(String uploadURL, Map<String, String> params, Map<String, File> files, UploadProgress writeListener) throws Exception {
        if (this.isVerbose()) {
            String msg = "API call: " + uploadURL;
            if (params != null && params.size() > 0) {
                msg = msg + ",P" + params;
            }
            if (files != null && files.size() > 0) {
                msg = msg + ",F" + files;
            }
            this.trace(msg);
        }
        return super.executeUpload(uploadURL, params, files, writeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ApplicationConfiguration getAppConfig(File deployZip, final String[] environments, final String[] implicitEnvironments) throws IOException {
        final ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration();
        FileInputStream fin = new FileInputStream(deployZip);
        try {
            ZipHelper.unzipFile(fin, new ZipHelper.ZipEntryHandler(){

                public void unzip(ZipEntry entry, InputStream zis) throws IOException {
                    if (entry.getName().equals("META-INF/stax-application.xml") || entry.getName().equals("WEB-INF/stax-web.xml") || entry.getName().equals("WEB-INF/cloudbees-web.xml")) {
                        AppConfigHelper.load(applicationConfiguration, zis, environments, implicitEnvironments);
                    }
                }
            }, false);
        }
        finally {
            fin.close();
        }
        return applicationConfiguration;
    }

    protected String createParameter(Map<String, String> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, String>();
        }
        JSONObject jsonObject = new JSONObject(parameters);
        return jsonObject.toString();
    }

    public void tailLog(String appId, String logName, OutputStream out) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        params.put("log_name", logName);
        String url = this.getRequestURL("tail", params, false);
        this.trace("API call: " + url);
        InputStream input = this.executeCometRequest(url);
        byte[] bytes = new byte[1024];
        int numRead = input.read(bytes);
        while (numRead != -1) {
            out.write(bytes, 0, numRead);
            numRead = input.read(bytes);
        }
    }

    protected Object apiCall(String apiMethod, Map<String, String> settings, Map<String, String> params) throws Exception {
        String response;
        String url;
        HashMap<String, File> fileParams = new HashMap<String, File>();
        if (settings != null) {
            for (Map.Entry<String, String> entry : settings.entrySet()) {
                int idx;
                String value = entry.getValue().toLowerCase();
                int n = idx = value.startsWith("file://") ? 7 : 0;
                if (idx == 0) {
                    int n2 = idx = value.startsWith("files://") ? 8 : 0;
                }
                if (idx <= 0) continue;
                File file = new File(entry.getValue().substring(idx));
                fileParams.put("FILE." + entry.getKey(), file);
                params.put("FILENAME." + entry.getKey(), file.getName());
            }
        }
        if (fileParams.size() > 0) {
            url = this.getApiUrl(apiMethod).toString();
            params.put("action", apiMethod);
            response = this.executeUpload(url, params, fileParams, new UploadProgress(){

                public void handleBytesWritten(long l, long l1, long l2) {
                }
            });
        } else {
            url = this.getRequestURL(apiMethod, params);
            response = this.executeRequest(url);
        }
        return this.readResponse(response);
    }

    public String call(String action, Map<String, String> params) throws Exception {
        String url = this.getRequestURL(action, params);
        String response = this.executeRequest(url);
        return response;
    }

    protected XStream getXStream() throws Exception {
        XStream xstream;
        if (this.format.equals("json")) {
            xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver()){

                protected MapperWrapper wrapMapper(MapperWrapper next) {
                    return new MapperWrapper((Mapper)next){

                        public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                            return definedIn != Object.class && super.shouldSerializeMember(definedIn, fieldName);
                        }
                    };
                }
            };
        } else if (this.format.equals("xml")) {
            xstream = new XStream(){

                protected MapperWrapper wrapMapper(MapperWrapper next) {
                    return new MapperWrapper((Mapper)next){

                        public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                            return definedIn != Object.class && super.shouldSerializeMember(definedIn, fieldName);
                        }
                    };
                }
            };
        } else {
            throw new Exception("Unknown format: " + this.format);
        }
        xstream.processAnnotations(SayHelloResponse.class);
        xstream.processAnnotations(ApplicationGetSourceUrlResponse.class);
        xstream.processAnnotations(ApplicationDeleteResponse.class);
        xstream.processAnnotations(ApplicationDeployResponse.class);
        xstream.processAnnotations(ApplicationDeployArchiveResponse.class);
        xstream.processAnnotations(ApplicationInstallResponse.class);
        xstream.processAnnotations(ApplicationInfo.class);
        xstream.processAnnotations(ApplicationInfoResponse.class);
        xstream.processAnnotations(ApplicationListResponse.class);
        xstream.processAnnotations(ApplicationRestartResponse.class);
        xstream.processAnnotations(ApplicationStatusResponse.class);
        xstream.processAnnotations(ApplicationSetMetaResponse.class);
        xstream.processAnnotations(ApplicationCheckSumsResponse.class);
        xstream.processAnnotations(ApplicationScaleResponse.class);
        xstream.processAnnotations(ApplicationSnapshotInfo.class);
        xstream.processAnnotations(ApplicationSnapshotListResponse.class);
        xstream.processAnnotations(ApplicationSnapshotStatusResponse.class);
        xstream.processAnnotations(DatabaseCreateResponse.class);
        xstream.processAnnotations(DatabaseSetPasswordResponse.class);
        xstream.processAnnotations(DatabaseDeleteResponse.class);
        xstream.processAnnotations(DatabaseInfo.class);
        xstream.processAnnotations(DatabaseInfoResponse.class);
        xstream.processAnnotations(DatabaseListResponse.class);
        xstream.processAnnotations(DatabaseSnapshotInfo.class);
        xstream.processAnnotations(DatabaseSnapshotListResponse.class);
        xstream.processAnnotations(DatabaseSnapshotDeployResponse.class);
        xstream.processAnnotations(DatabaseSnapshotDeleteResponse.class);
        xstream.processAnnotations(ErrorResponse.class);
        xstream.processAnnotations(AccountKeysResponse.class);
        xstream.processAnnotations(AccountInfo.class);
        xstream.processAnnotations(AccountListResponse.class);
        xstream.processAnnotations(ApplicationJarHashesResponse.class);
        xstream.processAnnotations(ConfigurationParametersResponse.class);
        xstream.processAnnotations(ConfigurationParametersUpdateResponse.class);
        xstream.processAnnotations(ConfigurationParametersDeleteResponse.class);
        xstream.processAnnotations(ServiceSubscriptionResponse.class);
        xstream.processAnnotations(ServiceSubscriptionListResponse.class);
        xstream.processAnnotations(ServiceSubscriptionDeleteResponse.class);
        xstream.processAnnotations(ServiceResourceInfo.class);
        xstream.processAnnotations(ServiceResourceResponse.class);
        xstream.processAnnotations(ServiceResourceListResponse.class);
        xstream.processAnnotations(ServiceResourceBindingListResponse.class);
        xstream.processAnnotations(ResourceBindingInfo.class);
        xstream.processAnnotations(AccountRegionInfo.class);
        xstream.processAnnotations(AccountRegionListResponse.class);
        xstream.processAnnotations(ApplicationInstanceInfo.class);
        xstream.processAnnotations(ApplicationInstanceListResponse.class);
        xstream.processAnnotations(ApplicationInstanceStatusResponse.class);
        xstream.processAnnotations(ApplicationInstanceInvokeResponse.class);
        xstream.processAnnotations(ApplicationConfigUpdateResponse.class);
        xstream.processAnnotations(ServiceResourceDeleteResponse.class);
        xstream.processAnnotations(ServiceResourceBindResponse.class);
        xstream.processAnnotations(ServiceResourceUnBindResponse.class);
        xstream.processAnnotations(RepositoryInfo.class);
        xstream.processAnnotations(CIInfo.class);
        xstream.processAnnotations(ApplicationCreateResponse.class);
        xstream.processAnnotations(ServerPoolInfo.class);
        xstream.processAnnotations(ServerPoolListResponse.class);
        xstream.processAnnotations(ServerPoolDeleteResponse.class);
        xstream.processAnnotations(ServerInfo.class);
        xstream.processAnnotations(ServerStatusResponse.class);
        xstream.processAnnotations(ServerRestoreResponse.class);
        xstream.processAnnotations(ServerReinitResponse.class);
        xstream.processAnnotations(ServiceResourceInvokeInfo.class);
        xstream.processAnnotations(ServiceSubscriptionInvokeInfo.class);
        xstream.processAnnotations(ServiceResourceResponse.class);
        xstream.processAnnotations(ServiceResourceInvokeResponse.class);
        xstream.processAnnotations(ServiceSubscriptionInvokeResponse.class);
        xstream.processAnnotations(ParameterSettings.class);
        xstream.processAnnotations(ResourceSettings.class);
        xstream.alias("net.stax.api.ApplicationStatusResponse", ApplicationStatusResponse.class);
        xstream.alias("net.stax.api.ApplicationSetMetaResponse", ApplicationSetMetaResponse.class);
        xstream.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        return xstream;
    }

    protected Object readResponse(String response) throws Exception {
        Object obj = this.getXStream().fromXML(response);
        if (obj instanceof ErrorResponse) {
            throw new BeesClientException((ErrorResponse)obj);
        }
        return obj;
    }

    public static String encodePassword(String password, String version) {
        if ("0.1".equals(version)) {
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA");
                byte[] passwordDigest = sha.digest(password.getBytes("UTF8"));
                String result = new BigInteger(1, passwordDigest).toString(16);
                if (result.length() < 32) {
                    char[] padded = new char[32];
                    char[] raw = result.toCharArray();
                    Arrays.fill(padded, 0, 32 - raw.length, '0');
                    System.arraycopy(raw, 0, padded, 32 - raw.length, raw.length);
                    result = new String(padded);
                }
                return result;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("JVM is supposed to provide SHA instance of MessageDigest", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("JVM is supposed to provide UTF-8 character encoding", e);
            }
        }
        return password;
    }

    public void mainCall(String[] args) throws Exception {
        String action;
        HashMap<String, String> params = new HashMap<String, String>();
        int argIndex = 0;
        if (argIndex < args.length) {
            action = args[argIndex++];
            while (argIndex < args.length) {
                String arg = args[argIndex];
                String[] pair = arg.split("=", 2);
                if (pair.length < 2) {
                    throw new UsageError("Malformed call parameter pair: " + arg);
                }
                params.put(pair[0], pair[1]);
                ++argIndex;
            }
        } else {
            throw new UsageError("Missing required action argument");
        }
        String response = this.call(action, params);
        System.out.println(response);
    }

    public void main(String[] args) throws Exception {
        String arg;
        int argIndex;
        HashMap<String, String> options = new HashMap<String, String>();
        for (argIndex = 0; argIndex < args.length && (arg = args[argIndex]).startsWith("-"); ++argIndex) {
            if (arg.equals("--call") || arg.equals("-c")) {
                options.put("operation", arg);
                continue;
            }
            if (arg.equals("--username") || arg.equals("-u")) {
                options.put("username", arg);
                continue;
            }
            if (arg.equals("--password") || arg.equals("-p")) {
                options.put("password", arg);
                continue;
            }
            if (arg.equals("--url") || arg.equals("-u")) {
                options.put("url", arg);
                continue;
            }
            throw new UsageError("Unsupported option: " + arg);
        }
        String operation = BeesClient.getRequiredOption("operation", options);
        BeesClient client = new BeesClient(BeesClient.getRequiredOption("url", options), BeesClient.getRequiredOption("username", options), BeesClient.getRequiredOption("password", options), "0.1", "1.0");
        if (operation.equals("call")) {
            String[] subArgs = new String[args.length - argIndex];
            for (int i = 0; i < subArgs.length; ++i) {
                subArgs[i] = args[argIndex++];
            }
            client.main(subArgs);
        }
    }

    private static String getRequiredOption(String optionName, Map<String, String> options) throws UsageError {
        if (options.containsKey(optionName)) {
            return options.get(optionName);
        }
        throw new UsageError("Missing required flag: --" + optionName);
    }

    private static File asFile(String filePath) {
        return filePath == null ? null : new File(filePath);
    }

    <T> T assertNotNull(T value, String arg) {
        if (value == null) {
            throw new IllegalArgumentException("Null is not a valid value for the '" + arg + "' argument");
        }
        return value;
    }

    static {
        MAPPER.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.NONE, JsonAutoDetect.Visibility.ANY));
        MAPPER.getDeserializationConfig().set(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    class PatchMethod
    extends EntityEnclosingMethod {
        PatchMethod() {
        }

        PatchMethod(String uri) {
            super(uri);
        }

        public String getName() {
            return "PATCH";
        }
    }

    public static class UsageError
    extends Exception {
        UsageError(String reason) {
            super(reason);
        }
    }
}

