/*
 * Decompiled with CFR 0.152.
 */
package bboss.org.apache.velocity.runtime.log;

import bboss.org.apache.velocity.runtime.RuntimeServices;
import bboss.org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4JLogChute
implements LogChute {
    public static final String RUNTIME_LOG_LOG4J_LOGGER = "bboss.org.apache.velocity";
    public static final String RUNTIME_LOG_LOG4J_LOGGER_LEVEL = "bboss.org.apache.velocity.level";
    private RuntimeServices rsvc = null;
    private boolean hasTrace = false;
    protected Logger logger = null;

    @Override
    public void init(RuntimeServices rs) throws Exception {
        this.rsvc = rs;
        String name = (String)this.rsvc.getProperty(RUNTIME_LOG_LOG4J_LOGGER);
        if (name != null) {
            this.logger = LoggerFactory.getLogger((String)name);
            this.log(0, "Log4JLogChute using logger '" + name + '\'');
        } else {
            this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        }
    }

    @Override
    public void log(int level, String message) {
        switch (level) {
            case 2: {
                this.logger.warn(message);
                break;
            }
            case 1: {
                this.logger.info(message);
                break;
            }
            case -1: {
                if (this.hasTrace) {
                    this.logger.trace(message);
                    break;
                }
                this.logger.debug(message);
                break;
            }
            case 3: {
                this.logger.error(message);
                break;
            }
            default: {
                this.logger.debug(message);
            }
        }
    }

    @Override
    public void log(int level, String message, Throwable t) {
        switch (level) {
            case 2: {
                this.logger.warn(message, t);
                break;
            }
            case 1: {
                this.logger.info(message, t);
                break;
            }
            case -1: {
                if (this.hasTrace) {
                    this.logger.trace(message, t);
                    break;
                }
                this.logger.debug(message, t);
                break;
            }
            case 3: {
                this.logger.error(message, t);
                break;
            }
            default: {
                this.logger.debug(message, t);
            }
        }
    }

    @Override
    public boolean isLevelEnabled(int level) {
        switch (level) {
            case 0: {
                return this.logger.isDebugEnabled();
            }
            case 1: {
                return this.logger.isInfoEnabled();
            }
            case -1: {
                if (this.hasTrace) {
                    return this.logger.isTraceEnabled();
                }
                return this.logger.isDebugEnabled();
            }
            case 2: {
                return this.logger.isWarnEnabled();
            }
            case 3: {
                return this.logger.isErrorEnabled();
            }
        }
        return true;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void shutdown() {
    }
}

