/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.util;

import com.frameworkset.common.poolman.util.DatasourceUtil;
import com.frameworkset.util.StringUtil;
import java.io.Serializable;
import java.util.Map;

public class JDBCPoolMetaData
implements Serializable {
    protected String poolname;
    transient JDBCPoolMetaData extenalInfo = null;
    private int initialObjects = 1;
    private int minimumSize = 0;
    private int maximumSize = Integer.MAX_VALUE;
    private int objectTimeout = 1200;
    private int userTimeout = 60;
    private int skimmerFrequency = 60;
    private int shrinkBy = 5;
    private boolean emergencyCreates = true;
    private String maxWait = "30";
    private String datasourceFile;
    private String seqfunction;
    private String databaseProductName;
    private String driverName;
    private String databaseProductVersion;
    private String driverVersion;
    private Map<String, Object> datasourceParameters;
    private boolean usepool = true;
    private String logfile;
    private boolean debug = false;
    private String driver;
    private String URL;
    private String username;
    private String password;
    private boolean nativeResults = false;
    private String validationQuery;
    private String initialPoolSQL;
    private String initialConnectionSQL;
    private boolean external = false;
    private String externaljndiName;
    private boolean removeOnExceptions = false;
    private boolean poolingPreparedStatements = false;
    private int maxOpenPreparedStatements = -1;
    private Integer transactionIsolationLevel = null;
    private int transactionTimeout = 60;
    private boolean cacheEnabled = false;
    private int cacheSize = 5;
    private int cacheRefreshInterval = 30;
    private String JNDIName;
    private String interceptor = "com.frameworkset.common.poolman.interceptor.DummyInterceptor";
    private String idGenerator;
    private String jndiclass;
    private String jndiuser;
    private String jndipassword;
    private boolean RETURN_GENERATED_KEYS;
    private boolean encryptdbinfo = false;
    private int queryfetchsize = 0;
    private String jndiurl;
    private String keygenerate = "auto";
    private String dbtype = null;
    private String loadmetadata = "false";
    private boolean autoprimarykey = false;
    private boolean showsql = false;
    private boolean cachequerymetadata = true;
    private boolean robotquery = true;
    private boolean testWhileidle = false;
    private String removeAbandoned = "false";
    private boolean logAbandoned = false;
    private Boolean readOnly = null;
    private boolean enablejta = false;
    public static final String[] driver_names = new String[]{"driverClass", "driverClassName", "driver", "driver-class", "driverName"};
    boolean synsequence = false;

    public String getJndiclass() {
        return this.jndiclass;
    }

    public void setJndiclass(String jndiclass) {
        this.jndiclass = jndiclass;
    }

    public String getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(String interceptor) {
        this.interceptor = interceptor;
    }

    public String getDriver() {
        if (!StringUtil.isEmpty((String)this.driver)) {
            return this.driver;
        }
        if (this.datasourceParameters != null && this.datasourceParameters.size() > 0) {
            String dr = null;
            for (int i = 0; i < driver_names.length; ++i) {
                dr = (String)this.datasourceParameters.get(driver_names[i]);
                if (StringUtil.isEmpty((String)dr)) continue;
                this.driver = dr;
                break;
            }
            return this.driver;
        }
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String URL2) {
        this.URL = URL2;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbname() {
        return this.getName();
    }

    public void setDbname(String n) {
        this.setName(n);
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public void setJNDIName(String n) {
        this.JNDIName = n;
    }

    public boolean isNativeResults() {
        return this.nativeResults;
    }

    public void setNativeResults(boolean b) {
        this.nativeResults = b;
    }

    public boolean isPoolPreparedStatements() {
        return this.poolingPreparedStatements;
    }

    public void setPoolPreparedStatements(boolean poolingPreparedStatements) {
        this.poolingPreparedStatements = poolingPreparedStatements;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String sql) {
        this.validationQuery = sql;
    }

    public String getInitialPoolSQL() {
        return this.initialPoolSQL;
    }

    public void setInitialPoolSQL(String sql) {
        this.initialPoolSQL = sql;
    }

    public String getInitialConnectionSQL() {
        return this.initialConnectionSQL;
    }

    public void setInitialConnectionSQL(String sql) {
        this.initialConnectionSQL = sql;
    }

    public boolean isRemoveOnExceptions() {
        return this.removeOnExceptions;
    }

    public void setRemoveOnExceptions(boolean b) {
        this.removeOnExceptions = b;
    }

    public int getInitialConnections() {
        return this.getInitialObjects();
    }

    public void setInitialConnections(int n) {
        this.setInitialObjects(n);
    }

    public int getConnectionTimeout() {
        return this.getObjectTimeout();
    }

    public void setConnectionTimeout(int n) {
        this.setObjectTimeout(n);
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int n) {
        this.transactionTimeout = n;
    }

    public Integer getIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setIsolationLevel(Integer n) {
        this.transactionIsolationLevel = n;
    }

    public String getTxIsolationLevel() {
        return this.convertIsoToString(this.getIsolationLevel());
    }

    public void setTxIsolationLevel(String s) {
        this.setIsolationLevel(this.convertIsoToInt(s));
    }

    private int convertIsoToInt(String s) {
        if (s == null || s.equals("")) {
            return -100;
        }
        int n = 2;
        if ((s = s.toUpperCase().trim()).equals("NONE")) {
            n = 0;
        } else if (s.equals("READ_COMMITTED")) {
            n = 2;
        } else if (s.equals("READ_UNCOMMITTED")) {
            n = 1;
        } else if (s.equals("REPEATABLE_READ")) {
            n = 4;
        } else if (s.equals("SERIALIZABLE")) {
            n = 8;
        } else {
            System.out.println("Unrecognized isolation level " + s + " using default setting of " + this.convertIsoToString(n));
        }
        return n;
    }

    private String convertIsoToString(Integer n) {
        if (n == null) {
            return null;
        }
        String result = null;
        switch (n) {
            case 0: {
                result = "NONE";
                break;
            }
            case 2: {
                result = "READ_COMMITTED";
                break;
            }
            case 1: {
                result = "READ_UNCOMMITTED";
                break;
            }
            case 4: {
                result = "REPEATABLE_READ";
                break;
            }
            case 8: {
                result = "SERIALIZABLE";
                break;
            }
        }
        return result;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public void setCacheEnabled(boolean b) {
        this.cacheEnabled = b;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public int getCacheRefreshInterval() {
        return this.cacheRefreshInterval;
    }

    public void setCacheRefreshInterval(int seconds) {
        this.cacheRefreshInterval = seconds;
    }

    public String getKeygenerate() {
        return this.keygenerate;
    }

    public String getDbtype() {
        return this.dbtype;
    }

    public void setKeygenerate(String keygenerate) {
        this.keygenerate = keygenerate;
    }

    public void setDbtype(String dbtype) {
        this.dbtype = dbtype;
    }

    public String getLoadmetadata() {
        return this.loadmetadata;
    }

    public void setLoadmetadata(String loadmetadata) {
        this.loadmetadata = loadmetadata;
    }

    public String getName() {
        return this.poolname;
    }

    public void setName(String name) {
        this.poolname = name;
    }

    public int getInitialObjects() {
        return this.initialObjects;
    }

    public void setInitialObjects(int n) {
        this.initialObjects = n;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(int n) {
        this.minimumSize = n;
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int n) {
        this.maximumSize = n;
    }

    public int getObjectTimeout() {
        return this.objectTimeout;
    }

    public void setObjectTimeout(int n) {
        this.objectTimeout = n;
    }

    public int getUserTimeout() {
        return this.userTimeout;
    }

    public void setUserTimeout(int n) {
        this.userTimeout = n;
    }

    public int getSkimmerFrequency() {
        return this.skimmerFrequency;
    }

    public void setSkimmerFrequency(int n) {
        this.skimmerFrequency = n;
    }

    public int getShrinkBy() {
        return this.shrinkBy;
    }

    public void setShrinkBy(int n) {
        this.shrinkBy = n;
    }

    public String getLogFile() {
        return this.logfile;
    }

    public void setLogFile(String filename) {
        this.logfile = filename;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public void setDebugging(boolean b) {
        this.debug = b;
    }

    public boolean isMaximumSoft() {
        return this.emergencyCreates;
    }

    public void setMaximumSoft(boolean b) {
        this.emergencyCreates = b;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public String getExternaljndiName() {
        return this.externaljndiName;
    }

    public void setExternaljndiName(String externaljndiName) {
        this.externaljndiName = externaljndiName;
    }

    public String getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(String maxWait) {
        this.maxWait = maxWait;
    }

    public String getRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(String removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public boolean isRobotquery() {
        return this.robotquery;
    }

    public void setRobotquery(boolean robotquery) {
        this.robotquery = robotquery;
    }

    public boolean isTestWhileidle() {
        return this.testWhileidle;
    }

    public void setTestWhileidle(boolean testWhileidle) {
        this.testWhileidle = testWhileidle;
    }

    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean synsequence() {
        return this.synsequence;
    }

    public void setSynsequence(boolean synsequence) {
        this.synsequence = synsequence;
    }

    public int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public void setMaxOpenPreparedStatements(int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public boolean getAutoprimarykey() {
        return this.autoprimarykey;
    }

    public void setAutoprimarykey(boolean autoprimarykey) {
        this.autoprimarykey = autoprimarykey;
    }

    public boolean isShowsql() {
        return this.showsql;
    }

    public void setShowsql(boolean showsql) {
        this.showsql = showsql;
    }

    public boolean cachequerymetadata() {
        return this.cachequerymetadata;
    }

    public void setCachequerymetadata(boolean cachequerymetadata) {
        this.cachequerymetadata = cachequerymetadata;
    }

    public void setExtenalInfo(JDBCPoolMetaData extenalInfo) {
        this.extenalInfo = extenalInfo;
        if (extenalInfo != null) {
            this.setDriver(extenalInfo.getDriver());
            this.setURL(extenalInfo.getURL());
            this.setUserName(extenalInfo.getUserName());
            this.setPassword(extenalInfo.getPassword());
            this.setNativeResults(extenalInfo.isNativeResults());
            this.setPoolPreparedStatements(extenalInfo.isPoolPreparedStatements());
            this.setValidationQuery(extenalInfo.getValidationQuery());
            this.setInitialPoolSQL(extenalInfo.getInitialPoolSQL());
            this.setInitialConnectionSQL(extenalInfo.getInitialConnectionSQL());
            this.setRemoveOnExceptions(extenalInfo.isRemoveOnExceptions());
            this.setInitialConnections(extenalInfo.getInitialConnections());
            this.setConnectionTimeout(extenalInfo.getConnectionTimeout());
            this.setTransactionTimeout(extenalInfo.getTransactionTimeout());
            this.setIsolationLevel(extenalInfo.getIsolationLevel());
            this.setTxIsolationLevel(extenalInfo.getTxIsolationLevel());
            this.setCacheEnabled(extenalInfo.isCacheEnabled());
            this.setCacheSize(extenalInfo.getCacheSize());
            this.setCacheRefreshInterval(extenalInfo.getCacheRefreshInterval());
            this.setKeygenerate(extenalInfo.getKeygenerate());
            this.setDbtype(extenalInfo.getDbtype());
            this.setLoadmetadata(extenalInfo.getLoadmetadata());
            this.setInitialObjects(extenalInfo.getInitialObjects());
            this.setMinimumSize(extenalInfo.getMinimumSize());
            this.setMaximumSize(extenalInfo.getMaximumSize());
            this.setObjectTimeout(extenalInfo.getObjectTimeout());
            this.setUserTimeout(extenalInfo.getUserTimeout());
            this.setSkimmerFrequency(extenalInfo.getSkimmerFrequency());
            this.setShrinkBy(extenalInfo.getShrinkBy());
            this.setMaximumSoft(extenalInfo.isMaximumSoft());
            this.setMaxWait(extenalInfo.getMaxWait());
            this.setRemoveAbandoned(extenalInfo.getRemoveAbandoned());
            this.setRobotquery(extenalInfo.isRobotquery());
            this.setTestWhileidle(extenalInfo.isTestWhileidle());
            this.setLogAbandoned(extenalInfo.isLogAbandoned());
            this.setReadOnly(extenalInfo.isReadOnly());
            this.setSynsequence(extenalInfo.synsequence());
            this.setMaxOpenPreparedStatements(extenalInfo.getMaxOpenPreparedStatements());
            this.setAutoprimarykey(extenalInfo.getAutoprimarykey());
            this.setCachequerymetadata(extenalInfo.cachequerymetadata());
            this.setDatabaseProductName(extenalInfo.getDatabaseProductName());
            this.setDatabaseProductVersion(extenalInfo.getDatabaseProductVersion());
            this.setDriverName(extenalInfo.getDriverName());
            this.setDriverVersion(extenalInfo.getDriverVersion());
            this.setJndiclass(extenalInfo.getJndiclass());
            this.setJndiurl(extenalInfo.getJndiurl());
            this.setJndiuser(extenalInfo.getJndiuser());
            this.setJndipassword(extenalInfo.getJndipassword());
            this.setUsepool(extenalInfo.isUsepool());
            this.setEncryptdbinfo(extenalInfo.isEncryptdbinfo());
            this.setEnablejta(extenalInfo.isEnablejta());
            this.setDatasourceFile(extenalInfo.getDatasourceFile());
            this.setDatasourceParameters(this.getDatasourceParameters());
            this.setSeqfunction(extenalInfo.getSeqfunction());
            this.setRETURN_GENERATED_KEYS(extenalInfo.getRETURN_GENERATED_KEYS());
            this.setQueryfetchsize(extenalInfo.getQueryfetchsize());
        }
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public void setDriverVersion(String driverVersion) {
        this.driverVersion = driverVersion;
    }

    public boolean isUsepool() {
        return this.usepool;
    }

    public void setUsepool(boolean usepool) {
        this.usepool = usepool;
    }

    public String getJndiurl() {
        return this.jndiurl;
    }

    public void setJndiurl(String jndiurl) {
        this.jndiurl = jndiurl;
    }

    public String getJndiuser() {
        return this.jndiuser;
    }

    public void setJndiuser(String jndiuser) {
        this.jndiuser = jndiuser;
    }

    public String getJndipassword() {
        return this.jndipassword;
    }

    public void setJndipassword(String jndipassword) {
        this.jndipassword = jndipassword;
    }

    public boolean isEncryptdbinfo() {
        return this.encryptdbinfo;
    }

    public void setEncryptdbinfo(boolean encryptdbinfo) {
        this.encryptdbinfo = encryptdbinfo;
    }

    public boolean isEnablejta() {
        return this.enablejta;
    }

    public void setEnablejta(boolean enablejta) {
        this.enablejta = enablejta;
    }

    public String getDatasourceFile() {
        return this.datasourceFile;
    }

    public void setDatasourceFile(String datasourceFile) {
        this.datasourceFile = datasourceFile;
    }

    public Map<String, Object> getDatasourceParameters() {
        return this.datasourceParameters;
    }

    public void setDatasourceParameters(Map<String, Object> datasourceParameters) {
        this.datasourceParameters = datasourceParameters;
    }

    public void initDatasourceParameters() {
        if (!StringUtil.isEmpty((String)this.datasourceFile)) {
            this.datasourceParameters = DatasourceUtil.getDataSourceParameters(this.datasourceFile);
        }
    }

    public String getSeqfunction() {
        return this.seqfunction;
    }

    public void setSeqfunction(String seqfunction) {
        this.seqfunction = seqfunction;
    }

    public String getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(String idGenerator) {
        this.idGenerator = idGenerator;
    }

    public boolean getRETURN_GENERATED_KEYS() {
        return this.RETURN_GENERATED_KEYS;
    }

    public void setRETURN_GENERATED_KEYS(boolean rETURN_GENERATED_KEYS) {
        this.RETURN_GENERATED_KEYS = rETURN_GENERATED_KEYS;
    }

    public int getQueryfetchsize() {
        return this.queryfetchsize;
    }

    public void setQueryfetchsize(int queryfetchsize) {
        this.queryfetchsize = queryfetchsize;
    }
}

