/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman.handle;

import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.util.SQLUtil;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.util.ColumnEditorInf;
import com.frameworkset.util.EditorInf;
import com.frameworkset.util.FieldToColumnEditor;
import com.frameworkset.util.NoSupportTypeCastException;
import com.frameworkset.util.ValueObjectUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Locale;
import org.frameworkset.util.annotations.wraper.ColumnWraper;
import sun.misc.BASE64Encoder;

public class ValueExchange {
    public static byte[] getResultBytes(Blob blob) throws SQLException {
        if (blob != null) {
            byte[] returnValue = ValueExchange.getByteArrayFromBlob(blob);
            return returnValue;
        }
        byte[] returnValue = null;
        return returnValue;
    }

    public static byte[] convertObjectToBytes(Object bytes) throws SQLException {
        if (bytes == null) {
            return null;
        }
        if (bytes instanceof String) {
            return ((String)bytes).getBytes();
        }
        if (bytes instanceof Blob) {
            try {
                return ValueExchange.getResultBytes((Blob)bytes);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NestedSQLException((Throwable)e);
            }
        }
        if (bytes instanceof Clob) {
            try {
                return ValueExchange.getResultBytes((Clob)bytes);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NestedSQLException((Throwable)e);
            }
        }
        return (byte[])bytes;
    }

    public static byte[] getResultBytes(Clob clob) throws SQLException {
        if (clob != null) {
            return ValueExchange.getByteArrayFromClob(clob);
        }
        return null;
    }

    public static Object getValueFromCallableStatement(CallableStatement cs, int columnIndex, int sqltype, Class javaType, String dbname, EditorInf<?> editor) throws SQLException {
        Object value = ValueExchange.getValueFromCallableStatement(cs, columnIndex, sqltype, dbname);
        if (editor == null) {
            if (value == null) {
                return ValueObjectUtil.getDefaultValue((Class)javaType);
            }
            return ValueExchange.convert(value, value.getClass(), javaType);
        }
        return editor.getValueFromObject(value);
    }

    public static Object getValueFromCallableStatement(CallableStatement cs, String parameterName, int sqltype, Class javaType, String dbname, ColumnEditorInf editor, ColumnWraper cl) throws SQLException {
        Object value = ValueExchange.getValueFromCallableStatement(cs, parameterName, sqltype, dbname);
        if (editor == null || editor instanceof FieldToColumnEditor) {
            if (value == null) {
                return value;
            }
            return ValueExchange.convert(value, value.getClass(), javaType);
        }
        return editor.getValueFromObject(cl, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getValueFromCallableStatement(CallableStatement cstmt, int i, int type, String dbname) throws SQLException {
        Object value = null;
        try {
            DB db = SQLUtil.getPool(dbname).getDbAdapter();
            switch (type) {
                case 1: {
                    try {
                        value = cstmt.getString(i);
                        return db.getCharValue(cstmt, i, (String)value);
                    }
                    catch (Exception _e) {
                        try {
                            return cstmt.getObject(i);
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                }
                case -5: {
                    Object reader = null;
                    Object temp = cstmt.getObject(i);
                    return temp;
                }
                case 2004: {
                    Blob blob = cstmt.getBlob(i);
                    return blob;
                }
                case -4: {
                    return db.getLONGVARBINARY(cstmt, i);
                }
                case 2005: {
                    Clob clob = cstmt.getClob(i);
                    return clob;
                }
                case -1: {
                    return db.getLONGVARCHAR(cstmt, i);
                }
                case -102: {
                    return cstmt.getTimestamp(i);
                }
                case -100: {
                    return cstmt.getTimestamp(i);
                }
                case -101: {
                    return cstmt.getTimestamp(i);
                }
                case 93: {
                    return cstmt.getTimestamp(i);
                }
                case 92: {
                    return cstmt.getTime(i);
                }
                case 91: {
                    try {
                        return cstmt.getTimestamp(i);
                    }
                    catch (Exception e) {
                        value = cstmt.getDate(i);
                        if (value == null) return value;
                        return new Timestamp(((Date)value).getTime());
                    }
                }
                default: {
                    try {
                        return cstmt.getObject(i);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            }
        }
        catch (SQLException ee) {
            throw ee;
        }
        catch (Exception ee) {
            throw new NestedSQLException((Throwable)ee);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getValueFromCallableStatement(CallableStatement cstmt, String paramName, int sqltype, String dbname) throws SQLException {
        Object value = null;
        try {
            switch (sqltype) {
                case 1: {
                    try {
                        value = cstmt.getString(paramName);
                        return SQLUtil.getPool(dbname).getDbAdapter().getCharValue(cstmt, paramName, (String)value);
                    }
                    catch (Exception _e) {
                        try {
                            return cstmt.getObject(paramName);
                        }
                        catch (Exception e) {
                            return null;
                        }
                    }
                }
                case -5: {
                    Object reader = null;
                    Object temp = cstmt.getObject(paramName);
                    return temp;
                }
                case -4: 
                case 2004: {
                    Blob blob = cstmt.getBlob(paramName);
                    return blob;
                }
                case -1: 
                case 2005: {
                    Clob clob = cstmt.getClob(paramName);
                    return clob;
                }
                case -102: {
                    return cstmt.getTimestamp(paramName);
                }
                case -100: {
                    return cstmt.getTimestamp(paramName);
                }
                case -101: {
                    return cstmt.getTimestamp(paramName);
                }
                case 93: {
                    return cstmt.getTimestamp(paramName);
                }
                case 92: {
                    return cstmt.getTime(paramName);
                }
                case 91: {
                    try {
                        return cstmt.getTimestamp(paramName);
                    }
                    catch (Exception e) {
                        value = cstmt.getDate(paramName);
                        if (value == null) return value;
                        return new Timestamp(((Date)value).getTime());
                    }
                }
                default: {
                    try {
                        return cstmt.getObject(paramName);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            }
        }
        catch (SQLException ee) {
            throw ee;
        }
        catch (Exception ee) {
            throw new NestedSQLException((Throwable)ee);
        }
    }

    public static byte[] getByteArrayFromBlob(Blob blob) throws SQLException {
        return ValueObjectUtil.getByteArrayFromBlob((Blob)blob);
    }

    public static String getByteStringFromBlob(Blob blob) throws SQLException {
        return ValueObjectUtil.getByteStringFromBlob((Blob)blob);
    }

    public static String getStringFromBlob(Blob blob) throws SQLException {
        return ValueObjectUtil.getStringFromBlob((Blob)blob);
    }

    public static byte[] getByteArrayFromClob(Clob clob) throws SQLException {
        return ValueObjectUtil.getByteArrayFromClob((Clob)clob);
    }

    public static String getStringFromClob(Clob clob) throws SQLException {
        return ValueObjectUtil.getStringFromClob((Clob)clob);
    }

    public static String getStringFromReader(Reader in) throws SQLException {
        StringWriter w = null;
        if (in == null) {
            return null;
        }
        try {
            w = new StringWriter();
            char[] buf = new char[1024];
            int i = 0;
            while ((i = in.read(buf)) > 0) {
                w.write(buf, 0, i);
            }
            String string = w.toString();
            return string;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (w != null) {
                    w.close();
                    w = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getStringFromStream(InputStream in) throws SQLException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, i);
            }
            String string = ((Object)out).toString();
            return string;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                    out = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                    in = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getStringFromObject(Object value) throws SQLException {
        String ret;
        block10: {
            ret = null;
            if (value == null) {
                return null;
            }
            try {
                if (value instanceof String) {
                    return (String)value;
                }
                if (value instanceof Clob) {
                    ret = ValueExchange.getStringFromClob((Clob)value);
                    break block10;
                }
                if (value instanceof Blob) {
                    ret = ValueExchange.getStringFromBlob((Blob)value);
                    break block10;
                }
                if (value instanceof byte[]) {
                    return new String((byte[])value);
                }
                if (value instanceof InputStream) {
                    ret = ValueExchange.getStringFromStream((InputStream)value);
                    break block10;
                }
                if (value instanceof Reader) {
                    ret = ValueExchange.getStringFromReader((Reader)value);
                    break block10;
                }
                return value.toString();
            }
            catch (SQLException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new NestedSQLException((Throwable)e);
            }
        }
        return ret;
    }

    public static Object getValueFromResultSet(ResultSet rs, int columnIndex, int sqltype, Class javaType, DB db, ColumnEditorInf editor, ColumnWraper columnWraper) throws SQLException {
        Object value = ValueExchange.getValueFromRS(rs, columnIndex, sqltype, db);
        if (editor == null || editor instanceof FieldToColumnEditor) {
            if (value == null) {
                return ValueObjectUtil.getDefaultValue((Class)javaType);
            }
            return ValueExchange.convert(value, value.getClass(), javaType);
        }
        return editor.getValueFromObject(columnWraper, value);
    }

    public static Object getValueFromResultSet(ResultSet rs, String column, int sqltype, Class javaType, String dbname, ColumnEditorInf editor, ColumnWraper cl) throws SQLException {
        Object value = ValueExchange.getValueFromRS(rs, column, sqltype, dbname);
        if (editor == null || editor instanceof FieldToColumnEditor) {
            if (value == null) {
                return ValueObjectUtil.getDefaultValue((Class)javaType);
            }
            return ValueExchange.convert(value, value.getClass(), javaType);
        }
        return editor.getValueFromObject(cl, value);
    }

    public static Object convert(Object value, Class type, Class javaType) throws SQLException {
        try {
            if (javaType == null || value == null) {
                return ValueObjectUtil.getDefaultValue((Class)javaType);
            }
            if (Clob.class.isAssignableFrom(type) ? javaType == Clob.class : Blob.class.isAssignableFrom(type) && javaType == Blob.class) {
                return value;
            }
            return ValueObjectUtil.typeCast((Object)value, value.getClass(), (Class)javaType);
        }
        catch (NumberFormatException e) {
            throw new NestedSQLException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new NestedSQLException((Throwable)e);
        }
        catch (NoSupportTypeCastException e) {
            throw new NestedSQLException((Throwable)e);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getValueFromRS(ResultSet res, int i, int type, DB db) throws SQLException {
        Object value = null;
        try {
            switch (type) {
                case 12: {
                    return res.getString(i);
                }
                case -5: {
                    long temp = res.getLong(i);
                    return new Long(temp);
                }
                case 93: {
                    return res.getTimestamp(i);
                }
                case 91: {
                    try {
                        return res.getTimestamp(i);
                    }
                    catch (Exception e) {
                        value = res.getDate(i);
                        if (value == null) return value;
                        return new Timestamp(((Date)value).getTime());
                    }
                }
                case 3: {
                    return res.getBigDecimal(i);
                }
                case 1: {
                    try {
                        return res.getString(i);
                    }
                    catch (SQLException _e) {
                        throw _e;
                    }
                    catch (Exception _e) {
                        throw new NestedSQLException((Throwable)_e);
                    }
                }
                case 2004: {
                    Blob blob = res.getBlob(i);
                    return blob;
                }
                case -4: {
                    return db.getLONGVARBINARY(res, i);
                }
                case 2005: {
                    Clob clob = res.getClob(i);
                    return clob;
                }
                case -1: {
                    return db.getLONGVARCHAR(res, i);
                }
                case -102: {
                    return res.getTimestamp(i);
                }
                case -100: {
                    return res.getTimestamp(i);
                }
                case -101: {
                    return res.getTimestamp(i);
                }
                case 92: {
                    return res.getTime(i);
                }
                default: {
                    return res.getObject(i);
                }
            }
        }
        catch (SQLException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getValueFromRS(ResultSet res, String i, int type, String dbname) throws SQLException {
        Object value = null;
        DB db = SQLUtil.getPool(dbname).getDbAdapter();
        try {
            switch (type) {
                case 12: {
                    return res.getString(i);
                }
                case -5: {
                    long temp = res.getLong(i);
                    return new Long(temp);
                }
                case 93: {
                    return res.getTimestamp(i);
                }
                case 91: {
                    try {
                        return res.getTimestamp(i);
                    }
                    catch (Exception e) {
                        value = res.getDate(i);
                        if (value == null) return value;
                        return new Timestamp(((Date)value).getTime());
                    }
                }
                case 3: {
                    return res.getBigDecimal(i);
                }
                case 1: {
                    try {
                        return res.getString(i);
                    }
                    catch (SQLException _e) {
                        throw _e;
                    }
                    catch (Exception _e) {
                        throw new NestedSQLException((Throwable)_e);
                    }
                }
                case 2004: {
                    Blob blob = res.getBlob(i);
                    return blob;
                }
                case -4: {
                    return db.getLONGVARBINARY(res, i);
                }
                case 2005: {
                    Clob clob = res.getClob(i);
                    return clob;
                }
                case -1: {
                    return db.getLONGVARCHAR(res, i);
                }
                case -102: {
                    return res.getTimestamp(i);
                }
                case -100: {
                    return res.getTimestamp(i);
                }
                case -101: {
                    return res.getTimestamp(i);
                }
                case 92: {
                    return res.getTime(i);
                }
                default: {
                    return res.getObject(i);
                }
            }
        }
        catch (SQLException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
    }

    public static String numberToCN(String column) {
        char[] cnNumbers = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
        if (!"".equals(column)) {
            StringBuilder stringbuffer = new StringBuilder();
            for (int i = 0; i < column.length(); ++i) {
                char temp = column.charAt(i);
                int number = 0;
                if (temp == '.') {
                    stringbuffer.append(".");
                    continue;
                }
                number = Integer.parseInt(String.valueOf(temp));
                stringbuffer.append(cnNumbers[number]);
            }
            return stringbuffer.toString();
        }
        return null;
    }

    public static String toStringNumber(double value, String length, String precision, int numbertocn, String pattern) {
        int idex;
        String ret = "";
        if (numbertocn == 1) {
            return ValueExchange.numberToCN(String.valueOf(value));
        }
        if (pattern != null && !"".equals(pattern)) {
            DecimalFormat form = new DecimalFormat(pattern);
            ret = form.format(value);
        } else {
            ret = value + "";
        }
        int precision_ = -1;
        if (precision != null && !"".equals(precision)) {
            precision_ = Integer.parseInt(precision);
        }
        if (precision_ >= 0 && (idex = ret.indexOf(".")) > 0) {
            String sn = ret.substring(idex + 1);
            if (sn.length() > precision_) {
                sn = sn.substring(0, precision_);
            } else if (sn.length() < precision_) {
                StringBuilder ret_ = new StringBuilder();
                int rap = precision_ - sn.length();
                for (int i = 0; i < rap; ++i) {
                    ret_.append("0");
                }
                sn = sn + ret_;
            }
            String integers = ret.substring(0, idex);
            ret = integers + "." + sn;
        }
        return ret;
    }

    public static String toStringDate(Date date, String dataformat, Locale locale) {
        if (date == null) {
            return null;
        }
        if (dataformat != null && !"".equals(dataformat)) {
            return ValueObjectUtil.getDateFormat((String)dataformat, (Locale)locale).format(date);
        }
        return ValueObjectUtil.getDateFormat(null, (Locale)locale).format(date);
    }

    public static String toStringInteger(int value, String length, int numbertocn, String dataformat) {
        String ret = "";
        if (numbertocn == 1) {
            return ValueExchange.numberToCN(String.valueOf(value));
        }
        if (dataformat != null && !"".equals(dataformat)) {
            DecimalFormat form = new DecimalFormat(dataformat);
            ret = form.format(value);
        } else {
            ret = value + "";
        }
        return ret;
    }

    public static String toStringBigNumber(BigDecimal bigDecimal, String length, int numbertocn, String dataformat) {
        String ret = "";
        if (numbertocn == 1) {
            return ValueExchange.numberToCN(String.valueOf(bigDecimal));
        }
        if (dataformat != null && !"".equals(dataformat)) {
            DecimalFormat form = new DecimalFormat(dataformat);
            ret = form.format(bigDecimal);
        } else {
            ret = bigDecimal + "";
        }
        return ret;
    }

    public static final String rightPad(StringBuilder ret, int limit) {
        int len = ret.length();
        if (len > limit) {
            ret.setLength(limit);
        } else {
            for (int l = len; l < limit; ++l) {
                ret.append(' ');
            }
        }
        return ret.toString();
    }

    public static String toStringString(String origin, int swtich_case, String length) {
        if (origin == null || "".equals(origin)) {
            return null;
        }
        if (swtich_case == 1) {
            origin = origin.toUpperCase();
        }
        String retval = null;
        StringBuilder ret = new StringBuilder(origin);
        int length_ = 0;
        if (length != null && !"".equals(length)) {
            length_ = Integer.parseInt(length);
            if (length_ > 16384) {
                length_ = 16384;
            }
            ValueExchange.rightPad(ret, length_);
        }
        retval = ret.toString();
        return retval;
    }

    public static String toStringTimeStamp(Timestamp timestamp, String dataformat, Locale locale) {
        if (timestamp == null) {
            return null;
        }
        if (dataformat != null && !"".equals(dataformat)) {
            return ValueObjectUtil.getDateFormat((String)dataformat, (Locale)locale).format(timestamp);
        }
        return ValueObjectUtil.getDateFormat(null, (Locale)locale).format(timestamp);
    }

    public static String toStringTime(Time time) {
        if (time != null) {
            return time.toString();
        }
        return null;
    }

    public static String getByteStringFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        BASE64Encoder en = new BASE64Encoder();
        return en.encode(bytes);
    }

    public static String getStringFromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes);
    }
}

