/*
 * Decompiled with CFR 0.152.
 */
package com.frameworkset.common.poolman;

import com.frameworkset.common.poolman.DBUtil;
import com.frameworkset.common.poolman.GetCUDResult;
import com.frameworkset.common.poolman.ListSQLParams;
import com.frameworkset.common.poolman.NestedSQLException;
import com.frameworkset.common.poolman.NewSQLInfo;
import com.frameworkset.common.poolman.Param;
import com.frameworkset.common.poolman.Params;
import com.frameworkset.common.poolman.Record;
import com.frameworkset.common.poolman.ResultMap;
import com.frameworkset.common.poolman.SQLParams;
import com.frameworkset.common.poolman.StatementInfo;
import com.frameworkset.common.poolman.handle.NullRowHandler;
import com.frameworkset.common.poolman.handle.RowHandler;
import com.frameworkset.common.poolman.handle.XMLMark;
import com.frameworkset.common.poolman.sql.PrimaryKey;
import com.frameworkset.common.poolman.util.JDBCPool;
import com.frameworkset.common.poolman.util.SQLManager;
import com.frameworkset.common.poolman.util.StatementParser;
import com.frameworkset.orm.adapter.DB;
import com.frameworkset.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.frameworkset.persitent.util.SQLInfo;
import org.frameworkset.persitent.util.SQLUtil;
import org.frameworkset.util.BigFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedDBUtil
extends DBUtil {
    private boolean more = false;
    protected Params Params = null;
    protected List<Params> batchparams;
    protected boolean batchOptimize = false;
    private static Logger log = LoggerFactory.getLogger(PreparedDBUtil.class);
    protected String prepareDBName = SQLManager.getInstance().getDefaultDBName();
    public static final int INSERT = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    public static final int SELECT = 3;
    public static final int SELECT_COMMON = 4;
    protected long offset;
    protected int pagesize;

    public boolean isMore() {
        return this.more;
    }

    public void setMore(boolean more) {
        this.more = more;
    }

    protected void setUpParams(StatementInfo stmtInfo, Params Params2, PreparedStatement statement, List resources) throws SQLException {
        this.setUpParams(stmtInfo, Params2, statement, null, resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpParams(StatementInfo stmtInfo, Params Params2, PreparedStatement statement, PreparedStatement statement_count, List resources) throws SQLException {
        if (resources == null) {
            resources = new ArrayList<Closeable>();
        }
        for (int i = 0; i < Params2.params.size(); ++i) {
            Reader reader;
            InputStream in;
            Object data;
            Param param = Params2.params.get(i);
            if (param.method.equals("setString(int, String)")) {
                statement.setString(param.index, (String)param.data);
                if (statement_count == null) continue;
                statement_count.setString(param.index, (String)param.data);
                continue;
            }
            if (param.method.equals("setInt(int, int)")) {
                statement.setInt(param.index, (Integer)param.data);
                if (statement_count == null) continue;
                statement_count.setInt(param.index, (Integer)param.data);
                continue;
            }
            if (param.method.equals("setTimestamp(int, Timestamp)")) {
                statement.setTimestamp(param.index, (Timestamp)param.data);
                if (statement_count == null) continue;
                statement_count.setTimestamp(param.index, (Timestamp)param.data);
                continue;
            }
            if (param.method.equals("setObject(int, Object)")) {
                stmtInfo.getDbadapter().setObject(statement, statement_count, param.index, param.data);
                continue;
            }
            if (param.method.equals("setLong(int, long)")) {
                statement.setLong(param.index, (Long)param.data);
                if (statement_count == null) continue;
                statement_count.setLong(param.index, (Long)param.data);
                continue;
            }
            if (param.method.equals("setDouble(int, double)")) {
                statement.setDouble(param.index, (Double)param.data);
                if (statement_count == null) continue;
                statement_count.setDouble(param.index, (Double)param.data);
                continue;
            }
            if (param.method.equals("setFloat(int, float)")) {
                statement.setFloat(param.index, ((Float)param.data).floatValue());
                if (statement_count == null) continue;
                statement_count.setFloat(param.index, ((Float)param.data).floatValue());
                continue;
            }
            if (param.method.equals("setNull(int, int)")) {
                statement.setNull(param.index, (Integer)param.data);
                if (statement_count == null) continue;
                statement_count.setNull(param.index, (Integer)param.data);
                continue;
            }
            if (param.method.equals("setNull(int, int, String)")) {
                data = (Object[])param.data;
                statement.setNull(param.index, (Integer)data[0], (String)data[1]);
                if (statement_count == null) continue;
                statement_count.setNull(param.index, (Integer)data[0], (String)data[1]);
                continue;
            }
            if (param.method.equals("setDate(int, java.sql.Date)")) {
                statement.setDate(param.index, (Date)param.data);
                if (statement_count == null) continue;
                statement_count.setDate(param.index, (Date)param.data);
                continue;
            }
            if (param.method.equals("setDate(int, java.util.Date)")) {
                statement.setDate(param.index, (Date)param.data);
                if (statement_count == null) continue;
                statement_count.setDate(param.index, (Date)param.data);
                continue;
            }
            if (param.method.equals("setDate(int, Date, Calendar)")) {
                data = (Object[])param.data;
                statement.setDate(param.index, (Date)data[0], (Calendar)data[1]);
                if (statement_count == null) continue;
                statement_count.setDate(param.index, (Date)data[0], (Calendar)data[1]);
                continue;
            }
            if (param.method.equals("setShort(int, short)")) {
                statement.setShort(param.index, (Short)param.data);
                if (statement_count == null) continue;
                statement_count.setShort(param.index, (Short)param.data);
                continue;
            }
            if (param.method.equals("setTimestamp(int, Timestamp, Calendar)")) {
                data = (Object[])param.data;
                statement.setTimestamp(param.index, (Timestamp)data[0], (Calendar)data[1]);
                if (statement_count == null) continue;
                statement_count.setTimestamp(param.index, (Timestamp)data[0], (Calendar)data[1]);
                continue;
            }
            if (param.method.equals("setArray(int, Array)")) {
                statement.setArray(param.index, (Array)param.data);
                if (statement_count == null) continue;
                statement_count.setArray(param.index, (Array)param.data);
                continue;
            }
            if (param.method.equals("setAsciiStream(int, InputStream, int)")) {
                data = (Object[])param.data;
                in = null;
                try {
                    in = (InputStream)data[0];
                    statement.setAsciiStream(param.index, in, (Integer)data[1]);
                    if (statement_count == null) continue;
                    statement_count.setAsciiStream(param.index, in, (Integer)data[1]);
                    continue;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new NestedSQLException((Throwable)e);
                }
                finally {
                    if (in != null) {
                        resources.add(in);
                    }
                }
            }
            if (param.method.equals("setBigDecimal(int, BigDecimal)")) {
                statement.setBigDecimal(param.index, (BigDecimal)param.data);
                if (statement_count == null) continue;
                statement_count.setBigDecimal(param.index, (BigDecimal)param.data);
                continue;
            }
            if (param.method.equals("setBinaryStream(int, InputStream, int)") || param.method.equals("setBinaryStream(int, InputStream, int)")) {
                data = null;
                in = null;
                try {
                    data = (Object[])param.data;
                    in = (InputStream)data[0];
                    statement.setBinaryStream(param.index, in, (Integer)data[1]);
                    if (statement_count == null) continue;
                    statement_count.setBinaryStream(param.index, in, (Integer)data[1]);
                    continue;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new NestedSQLException((Throwable)e);
                }
                finally {
                    data = null;
                    if (in != null) {
                        resources.add(in);
                    }
                }
            }
            if (param.method.equals("setBlob(int, byte[])") || param.method.equals("setBlob(int, byte[], String)")) {
                data = null;
                ByteArrayInputStream bis = null;
                try {
                    data = (byte[])param.data;
                    if (data == null) {
                        statement.setNull(param.index, 2004);
                        continue;
                    }
                    bis = new ByteArrayInputStream((byte[])data);
                    statement.setBinaryStream(param.index, (InputStream)bis, ((Object[])data).length);
                    if (statement_count == null) continue;
                    statement_count.setBinaryStream(param.index, (InputStream)bis, ((Object[])data).length);
                    continue;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new NestedSQLException((Throwable)e);
                }
                finally {
                    data = null;
                    if (bis != null) {
                        resources.add(bis);
                    }
                }
            }
            if (param.method.equals("setBlob(int,Blob])")) {
                if (param.data == null) {
                    statement.setNull(param.index, 2004);
                    if (statement_count == null) continue;
                    statement_count.setNull(param.index, 2004);
                    continue;
                }
                if (param.data instanceof String) {
                    ByteArrayInputStream in2 = null;
                    try {
                        String data_str = (String)param.data;
                        int len = data_str.length();
                        in2 = new ByteArrayInputStream(data_str.getBytes());
                        statement.setBinaryStream(param.index, (InputStream)in2, len);
                        if (statement_count == null) continue;
                        statement_count.setBinaryStream(param.index, (InputStream)in2, len);
                        continue;
                    }
                    catch (SQLException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new NestedSQLException((Throwable)e);
                    }
                    finally {
                        if (in2 != null) {
                            resources.add(in2);
                        }
                    }
                }
                statement.setBlob(param.index, (Blob)param.data);
                if (statement_count == null) continue;
                statement_count.setBlob(param.index, (Blob)param.data);
                continue;
            }
            if (param.method.equals("setBlob(int, File)") || param.method.equals("setBlob(int, File, String)")) {
                File x = null;
                in = null;
                try {
                    if (param.data == null) {
                        statement.setNull(param.index, 2004);
                        if (statement_count == null) continue;
                        statement_count.setNull(param.index, 2004);
                        continue;
                    }
                    long len = Integer.MAX_VALUE;
                    if (param.data instanceof File) {
                        x = (File)param.data;
                        in = new BufferedInputStream(new FileInputStream(x));
                        len = x.length();
                    } else if (param.data instanceof BigFile) {
                        BigFile f = (BigFile)param.data;
                        len = f.getSize();
                        in = new BufferedInputStream(f.getInputStream());
                    } else if (param.data instanceof Object[]) {
                        Object[] values = (Object[])param.data;
                        in = new BufferedInputStream((InputStream)values[0]);
                        len = (Long)values[1];
                    } else {
                        in = new BufferedInputStream((InputStream)param.data);
                    }
                    statement.setBinaryStream(param.index, in, (int)len);
                    if (statement_count == null) continue;
                    statement_count.setBinaryStream(param.index, in, (int)len);
                    continue;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new NestedSQLException((Throwable)e);
                }
                finally {
                    x = null;
                    if (in != null) {
                        resources.add(in);
                    }
                }
            }
            if (param.method.equals("setClob(int i, File file)") || param.method.equals("setClob(int i, File file, String string)")) {
                StringReader reader2 = null;
                in = null;
                InputStream dataf = null;
                try {
                    if (param.data == null) {
                        statement.setNull(param.index, 2005);
                        if (statement_count == null) continue;
                        statement_count.setNull(param.index, 2005);
                        continue;
                    }
                    if (param.data instanceof File) {
                        File data2 = null;
                        data2 = (File)param.data;
                        if (param.getCharset() == null) {
                            in = new BufferedInputStream(new FileInputStream(data2));
                            long len = data2.length();
                            statement.setAsciiStream(param.index, in, (int)len);
                            if (statement_count == null) continue;
                            statement_count.setAsciiStream(param.index, in, (int)len);
                            continue;
                        }
                        String content = FileUtil.getFileContent((File)data2, (String)param.getCharset());
                        reader2 = new StringReader(content);
                        statement.setCharacterStream(param.index, (Reader)reader2, content.length());
                        if (statement_count == null) continue;
                        statement_count.setCharacterStream(param.index, (Reader)reader2, content.length());
                        continue;
                    }
                    if (param.data instanceof BigFile) {
                        BigFile f = (BigFile)param.data;
                        long len = f.getSize();
                        in = new BufferedInputStream(f.getInputStream());
                        statement.setAsciiStream(param.index, in, (int)len);
                        if (statement_count == null) continue;
                        statement_count.setAsciiStream(param.index, in, (int)len);
                        continue;
                    }
                    if (param.data instanceof Object[]) {
                        Object[] values = (Object[])param.data;
                        dataf = (InputStream)values[0];
                        long len = (Long)values[1];
                        in = new BufferedInputStream(dataf);
                        statement.setAsciiStream(param.index, in, (int)len);
                        if (statement_count == null) continue;
                        statement_count.setAsciiStream(param.index, in, (int)len);
                        continue;
                    }
                    dataf = (InputStream)param.data;
                    String d = null;
                    d = param.getCharset() == null ? this.getString(dataf, (String)null) : this.getString(dataf, param.getCharset());
                    reader2 = new StringReader(d);
                    statement.setCharacterStream(param.index, (Reader)reader2, d.length());
                    if (statement_count == null) continue;
                    statement_count.setCharacterStream(param.index, (Reader)reader2, d.length());
                    continue;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new NestedSQLException((Throwable)e);
                }
                finally {
                    if (reader2 != null) {
                        resources.add(reader2);
                    }
                    if (in != null) {
                        resources.add(in);
                    }
                    if (dataf != null) {
                        resources.add(dataf);
                    }
                }
            }
            if (param.method.equals("setClob(int, Clob)")) {
                statement.setClob(param.index, (Clob)param.data);
                if (statement_count == null) continue;
                statement_count.setClob(param.index, (Clob)param.data);
                continue;
            }
            if (param.method.equals("setBoolean(int, boolean)")) {
                statement.setBoolean(param.index, (Boolean)param.data);
                if (statement_count == null) continue;
                statement_count.setBoolean(param.index, (Boolean)param.data);
                continue;
            }
            if (param.method.equals("setByte(int, byte)")) {
                statement.setByte(param.index, (Byte)param.data);
                if (statement_count == null) continue;
                statement_count.setByte(param.index, (Byte)param.data);
                continue;
            }
            if (param.method.equals("setBytes(int, byte[])")) {
                statement.setBytes(param.index, (byte[])param.data);
                if (statement_count == null) continue;
                statement_count.setBytes(param.index, (byte[])param.data);
                continue;
            }
            if (param.method.equals("setCharacterStream(int, Reader, int)")) {
                data = null;
                reader = null;
                try {
                    data = (Object[])param.data;
                    reader = (Reader)data[0];
                    statement.setCharacterStream(param.index, reader, (Integer)data[1]);
                    if (statement_count == null) continue;
                    statement_count.setCharacterStream(param.index, reader, (Integer)data[1]);
                    continue;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new NestedSQLException((Throwable)e);
                }
                finally {
                    data = null;
                    if (reader != null) {
                        resources.add(reader);
                    }
                }
            }
            if (param.method.equals("setClob(int, String)") || param.method.equals("setClob(int, String, String)")) {
                data = null;
                reader = null;
                try {
                    data = (String)param.data;
                    if (data == null) {
                        statement.setNull(param.index, 2005);
                        if (statement_count == null) continue;
                        statement_count.setNull(param.index, 2005);
                        continue;
                    }
                    reader = new StringReader((String)data);
                    statement.setCharacterStream(param.index, reader, ((String)data).length());
                    if (statement_count == null) continue;
                    statement_count.setCharacterStream(param.index, reader, ((String)data).length());
                    continue;
                }
                catch (SQLException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new NestedSQLException((Throwable)e);
                }
                finally {
                    data = null;
                    if (reader != null) {
                        resources.add(reader);
                    }
                }
            }
            if (param.method.equals("setObject(int, Object, int)")) {
                data = (Object[])param.data;
                statement.setObject(param.index, data[0], (Integer)data[1]);
                if (statement_count == null) continue;
                statement_count.setObject(param.index, data[0], (Integer)data[1]);
                continue;
            }
            if (param.method.equals("setObject(int, Object, int, int)")) {
                data = (Object[])param.data;
                statement.setObject(param.index, data[0], (Integer)data[1], (int)((Integer)data[2]));
                if (statement_count == null) continue;
                statement_count.setObject(param.index, data[0], (Integer)data[1], (int)((Integer)data[2]));
                continue;
            }
            if (param.method.equals("setRef(int, Ref)")) {
                statement.setRef(param.index, (Ref)param.data);
                if (statement_count == null) continue;
                statement_count.setRef(param.index, (Ref)param.data);
                continue;
            }
            if (param.method.equals("setTime(int, Time)")) {
                statement.setTime(param.index, (Time)param.data);
                if (statement_count == null) continue;
                statement_count.setTime(param.index, (Time)param.data);
                continue;
            }
            if (param.method.equals("setTime(int, Time, Calendar)")) {
                data = (Object[])param.data;
                statement.setTime(param.index, (Time)data[0], (Calendar)data[1]);
                if (statement_count == null) continue;
                statement_count.setTime(param.index, (Time)data[0], (Calendar)data[1]);
                continue;
            }
            if (!param.method.equals("setUnicodeStream(int, InputStream, int)")) continue;
            data = null;
            in = null;
            try {
                data = (Object[])param.data;
                in = (InputStream)data[0];
                statement.setUnicodeStream(param.index, in, (Integer)data[1]);
                if (statement_count == null) continue;
                statement_count.setUnicodeStream(param.index, in, (Integer)data[1]);
                continue;
            }
            finally {
                data = null;
                if (in != null) {
                    resources.add(in);
                }
            }
        }
    }

    public Object executePrepared() throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePrepared(null);
    }

    public Object executePreparedGetCUDResult(boolean getCUDResult) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePrepared(null, getCUDResult);
    }

    public <T> T executePreparedForObject(Class<T> objectType) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForObject(null, objectType);
    }

    public <T> T[] executePreparedForObjectArray(Class<T> objectType) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForObjectArray(null, objectType);
    }

    public <T> List<T> executePreparedForList(Class<T> objectType) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForList(null, objectType);
    }

    public String executePreparedForXML() throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForXML(null, null);
    }

    public <T> T executePreparedForObject(Connection con, Class<T> objectType) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForObject(con, objectType, null);
    }

    public <T> T[] executePreparedForObjectArray(Connection con, Class<T> objectType) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForObjectArray(con, objectType, null);
    }

    public <T> List<T> executePreparedForList(Connection con, Class<T> objectType) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForList(con, objectType, null);
    }

    public String executePreparedForXML(Connection con) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForXML(con, null);
    }

    public void executePreparedWithRowHandler(NullRowHandler rowhandler) throws SQLException {
        this.executePreparedWithRowHandler(null, rowhandler);
    }

    public void executePreparedWithRowHandler(Connection con, NullRowHandler rowhandler) throws SQLException {
        this.executePreparedForObject(con, null, rowhandler);
    }

    public <T> T executePreparedForObject(Class<T> objectType, RowHandler rowhandler) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForObject(null, objectType, rowhandler);
    }

    public <T> T[] executePreparedForObjectArray(Class<T> objectType, RowHandler rowhandler) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForObjectArray(null, objectType, rowhandler);
    }

    public <T> List<T> executePreparedForList(Class<T> objectType, RowHandler rowhandler) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForList(null, objectType, rowhandler);
    }

    public String executePreparedForXML(RowHandler rowhandler) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return this.executePreparedForXML(null, rowhandler);
    }

    public <T> T executePreparedForObject(Connection con, Class<T> objectType, RowHandler rowhandler) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        if (objectType != null) {
            return (T)this.innerExecute(con, objectType, rowhandler, ResultMap.type_objcet, false);
        }
        return (T)this.innerExecute(con, objectType, rowhandler, ResultMap.type_null, false);
    }

    public <T> T[] executePreparedForObjectArray(Connection con, Class<T> objectType, RowHandler rowhandler) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return (Object[])this.innerExecute(con, objectType, rowhandler, ResultMap.type_objectarray, false);
    }

    public <T> List<T> executePreparedForList(Connection con, Class<T> objectType, RowHandler rowhandler) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return (List)this.innerExecute(con, objectType, rowhandler, ResultMap.type_list, false);
    }

    public String executePreparedForXML(Connection con, RowHandler rowhandler) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch()!");
        }
        return (String)this.innerExecute(con, XMLMark.class, rowhandler, ResultMap.type_xml, false);
    }

    private Object innerExecute(Connection con, Class objectType, RowHandler rowhandler, int type, boolean getCUDResult) throws SQLException {
        if (this.batchparams != null && this.batchparams.size() > 0) {
            throw new SQLException("Can not execute batch prepared operations as single prepared operation,Please call method executePreparedBatch(Connection con)!");
        }
        if (this.Params.prepareSqlifo == null || this.Params.prepareSqlifo.getNewsql() == null || this.Params.prepareSqlifo.getNewsql().equals("")) {
            throw new SQLException("\u6267\u884c\u9519\u8bef\uff1a\u8bf7\u5148\u8bbe\u7f6e\u9884\u6267\u884csql\u8bed\u53e5\uff01");
        }
        StatementInfo stmtInfo = null;
        List<Object> result = null;
        PreparedStatement statement = null;
        PreparedStatement statement_count = null;
        ArrayList resources = null;
        try {
            JDBCPool pool = SQLManager.getInstance().getPool(this.prepareDBName);
            if (pool == null) {
                throw new NestedSQLException("\u6267\u884csql[" + (this.Params.prepareSqlifo != null ? this.Params.prepareSqlifo.getNewsql() : "") + "]\u5931\u8d25\uff1a\u6570\u636e\u6e90[" + this.prepareDBName + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u662f\u5426\u6b63\u786e\u542f\u52a8.");
            }
            stmtInfo = new StatementInfo(this.prepareDBName, this.Params.prepareSqlifo, false, this.offset, this.pagesize, pool.isRobotQuery(), con, this.oraclerownum, true);
            stmtInfo.init();
            if (this.Params.action == 0) {
                boolean autokey = PreparedDBUtil.isAutoprimarykey(this.prepareDBName);
                if (autokey) {
                    Object[] temp = StatementParser.refactorInsertStatement(stmtInfo);
                    if (log.isInfoEnabled() && PreparedDBUtil.showsql(stmtInfo.getDbname())) {
                        log.info("Execute JDBC prepared statement:{}", temp[0]);
                    }
                    statement = stmtInfo.prepareStatement(temp[0].toString());
                    if (temp[1] != null) {
                        result = temp[1];
                    }
                    if (this.Params.updateKeyInfo == null) {
                        this.Params.updateKeyInfo = new UpdateKeyInfo();
                    }
                    if (temp[3] != null) {
                        PrimaryKey primaryKey = (PrimaryKey)temp[3];
                        if (this.Params.updateKeyInfo == null) {
                            this.Params.updateKeyInfo = new UpdateKeyInfo();
                        }
                        if (primaryKey.getTableName() != null) {
                            this.Params.updateKeyInfo.tableName = primaryKey.getTableName();
                        }
                        if (primaryKey.getPrimaryKeyName() != null) {
                            this.Params.updateKeyInfo.keyName = primaryKey.getPrimaryKeyName();
                        }
                        if (temp[1] != null && !temp[1].equals("")) {
                            this.Params.updateKeyInfo.keyValue = temp[1].toString();
                        }
                        if (primaryKey.getMetaType() != null) {
                            this.Params.updateKeyInfo.type = primaryKey.getMetaType();
                        }
                    }
                    if (this.Params.updateKeyInfo.keyValue == null && temp[1] != null) {
                        this.Params.updateKeyInfo.keyValue = temp[1].toString();
                    }
                } else {
                    stmtInfo.setRETURN_GENERATED_KEYS(pool.getRETURN_GENERATED_KEYS());
                    if (log.isInfoEnabled() && PreparedDBUtil.showsql(stmtInfo.getDbname())) {
                        log.info("Execute JDBC prepared statement:{}", (Object)stmtInfo.getSql());
                    }
                    statement = stmtInfo.prepareStatement(stmtInfo.getSql(), getCUDResult);
                }
            } else if (this.Params.action == 1) {
                if (log.isInfoEnabled() && PreparedDBUtil.showsql(stmtInfo.getDbname())) {
                    log.info("Execute JDBC prepared update statement:{}", (Object)stmtInfo.getSql());
                }
                statement = stmtInfo.prepareStatement();
            } else if (this.Params.action == 3) {
                boolean showsql = PreparedDBUtil.showsql(stmtInfo.getDbname());
                stmtInfo.setPagineOrderBy(this.Params.getPagineOrderby());
                statement = stmtInfo.preparePagineStatement(showsql);
                if (!this.more) {
                    if (this.Params.totalsize < 0L) {
                        stmtInfo.setTotalsizesql(this.Params.prepareSqlifo.getNewtotalsizesql());
                        statement_count = stmtInfo.prepareCountStatement(showsql);
                    } else {
                        stmtInfo.setTotalsize(this.Params.totalsize);
                    }
                }
            } else {
                if (log.isInfoEnabled() && PreparedDBUtil.showsql(stmtInfo.getDbname())) {
                    log.info("Execute JDBC prepared query statement:{}", (Object)stmtInfo.getSql());
                }
                statement = stmtInfo.prepareQueryStatement();
            }
            if (this.Params.action != 3 && this.Params.action != 4) {
                List<Object> morekeys;
                resources = new ArrayList();
                this.setUpParams(stmtInfo, this.Params, statement, resources);
                statement.execute();
                int updatecount = statement.getUpdateCount();
                if (result == null) {
                    result = new Integer(updatecount);
                }
                GetCUDResult CUDResult = null;
                if (getCUDResult) {
                    morekeys = null;
                    if (this.Params.action == 0) {
                        morekeys = StatementInfo.getGeneratedKeys(statement);
                    }
                    CUDResult = morekeys != null && morekeys.size() == 1 ? new GetCUDResult(result, updatecount, morekeys.get(0)) : new GetCUDResult(result, updatecount, morekeys);
                }
                statement.clearParameters();
                if (CUDResult == null) {
                    morekeys = result;
                    return morekeys;
                }
                morekeys = CUDResult;
                return morekeys;
            }
            if (this.Params.action == 3) {
                boolean haspaginsql;
                resources = new ArrayList();
                this.setUpParams(stmtInfo, this.Params, statement, statement_count, resources);
                long start = stmtInfo.getPaginesql().getStart();
                long end = stmtInfo.getPaginesql().getEnd();
                int startidx = 0;
                int endidx = 0;
                boolean bl = haspaginsql = start >= 0L;
                if (haspaginsql) {
                    startidx = this.Params.params != null ? this.Params.params.size() : 0;
                    endidx = ++startidx + 1;
                    statement.setLong(startidx, start);
                    statement.setLong(endidx, end);
                }
                ResultMap resultMap = this.doPrepareSelect(stmtInfo, statement, statement_count, objectType, rowhandler, type, startidx, endidx, haspaginsql);
                if (type == ResultMap.type_maparray) {
                    this.allResults = (Record[])resultMap.getCommonresult();
                    this.size = this.allResults == null ? 0 : this.allResults.length;
                    resultMap = null;
                    Object var20_26 = null;
                    return var20_26;
                }
                this.size = resultMap.getSize();
                Object object = resultMap.getCommonresult();
                return object;
            }
            if (this.Params.action == 4) {
                Object object;
                resources = new ArrayList();
                this.setUpParams(stmtInfo, this.Params, statement, resources);
                ResultMap resultMap = this.doPrepareSelectCommon(stmtInfo, statement, objectType, rowhandler, type);
                if (type == ResultMap.type_maparray) {
                    this.allResults = (Record[])resultMap.getCommonresult();
                    this.size = this.allResults == null ? 0 : this.allResults.length;
                    object = null;
                    return object;
                }
                this.size = resultMap.getSize();
                object = resultMap.getCommonresult();
                return object;
            }
            Object var12_18 = null;
            return var12_18;
        }
        catch (NestedSQLException e) {
            if (stmtInfo != null) {
                stmtInfo.errorHandle((Exception)((Object)e));
            }
            throw e;
        }
        catch (SQLException e) {
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            throw new NestedSQLException("Execute prepared sql[" + (stmtInfo != null ? stmtInfo.getSql() : null) + "] failed:", (Throwable)e);
        }
        catch (Exception e) {
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            throw new NestedSQLException("Execute prepared sql[" + (stmtInfo != null ? stmtInfo.getSql() : null) + "] failed:", (Throwable)e);
        }
        finally {
            if (resources != null) {
                this.releaseResources(resources);
            }
            if (stmtInfo != null) {
                stmtInfo.dofinally();
                stmtInfo = null;
            }
            this.resetFromSetMethod(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseResources(List resources) {
        if (resources == null) {
            return;
        }
        try {
            for (int i = 0; resources != null && i < resources.size(); ++i) {
                Object obj = resources.get(i);
                if (obj == null) continue;
                try {
                    if (obj instanceof InputStream) {
                        ((InputStream)obj).close();
                        continue;
                    }
                    if (!(obj instanceof Reader)) continue;
                    ((Reader)obj).close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            resources.clear();
        }
    }

    public void executePreparedBatch() throws SQLException {
        if (this.batchparams == null || this.batchparams.size() == 0) {
            log.info("Can not execute single prepared statement as batch prepared operation,Please call method executePrepared()!");
            return;
        }
        this.executePreparedBatch(null);
    }

    public void executePreparedBatchGetCUDResult(GetCUDResult getCUDResult) throws SQLException {
        if (this.batchparams == null || this.batchparams.size() == 0) {
            log.info("Can not execute single prepared statement as batch prepared operation,Please call method executePrepared()!");
            return;
        }
        this.executePreparedBatch(null, getCUDResult);
    }

    public Object executePrepared(Connection con) throws SQLException {
        return this.executePrepared(con, false);
    }

    public Object executePrepared(Connection con, boolean getCUDResult) throws SQLException {
        return this.innerExecute(con, null, null, ResultMap.type_maparray, getCUDResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected ResultMap doPrepareSelect(StatementInfo stmtInfo, PreparedStatement statement, PreparedStatement statement_count, Class objectType, RowHandler rowhandler, int result_type, int startidx, int endidx, boolean haspaginsql) throws SQLException {
        resultMap = new ResultMap();
        res = null;
        rs = null;
        if (!this.more) {
            if (stmtInfo.getTotalsize() < 0L) {
                try {
                    if (statement_count == null) ** GOTO lbl32
                    rs = statement_count.executeQuery();
                    if (rs.next()) {
                        this.totalSize = rs.getInt(1);
                    }
                    oldoffset = this.offset;
                    this.offset = stmtInfo.rebuildOffset(this.totalSize);
                    if (this.offset >= oldoffset || !haspaginsql) ** GOTO lbl32
                    stmtInfo.resetPostion(statement, startidx, endidx, this.offset);
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception var13_15) {}
                        rs = null;
                    }
                    if (statement_count != null) {
                        try {
                            statement_count.close();
                            statement_count = null;
                        }
                        catch (Exception var13_16) {}
                    }
                }
            } else {
                this.totalSize = stmtInfo.getTotalsize();
            }
lbl32:
            // 4 sources

            if (this.totalSize > 0L) {
                res = statement.executeQuery();
                stmtInfo.addResultSet(res);
                stmtInfo.absolute(res);
                stmtInfo.cacheResultSetMetaData(res, true);
                this.meta = stmtInfo.getMeta();
                if (rowhandler != null) {
                    rowhandler.init(stmtInfo, this.meta, stmtInfo.getDbname());
                }
                resultMap = stmtInfo.buildResultMap(res, objectType, rowhandler, stmtInfo.getMaxsize(), true, result_type);
            } else {
                res = statement.executeQuery();
                stmtInfo.addResultSet(res);
                stmtInfo.absolute(res);
                stmtInfo.cacheResultSetMetaData(res, true);
                if (rowhandler != null) {
                    rowhandler.init(stmtInfo, this.meta, stmtInfo.getDbname());
                }
                this.meta = stmtInfo.getMeta();
            }
        } else {
            res = statement.executeQuery();
            stmtInfo.addResultSet(res);
            stmtInfo.absolute(res);
            stmtInfo.cacheResultSetMetaData(res, true);
            this.meta = stmtInfo.getMeta();
            if (rowhandler != null) {
                rowhandler.init(stmtInfo, this.meta, stmtInfo.getDbname());
            }
            resultMap = stmtInfo.buildResultMap(res, objectType, rowhandler, stmtInfo.getMaxsize(), true, result_type);
        }
        var13_17 = resultMap;
        return var13_17;
    }

    protected ResultMap doPrepareSelectCommon(StatementInfo stmtInfo, PreparedStatement statement, Class objectType, RowHandler rowhandler, int result_type) throws SQLException {
        ResultSet res = null;
        res = statement.executeQuery();
        stmtInfo.addResultSet(res);
        stmtInfo.cacheResultSetMetaData(res, false);
        this.meta = stmtInfo.getMeta();
        if (rowhandler != null) {
            rowhandler.init(stmtInfo, this.meta, stmtInfo.getDbname());
        }
        ResultMap resultMap = new ResultMap();
        ResultMap resultMap2 = resultMap = stmtInfo.buildResultMap(res, objectType, rowhandler, 10, false, result_type);
        return resultMap2;
    }

    private void initBigdata() {
        if (this.Params.bigdatas == null) {
            this.Params.bigdatas = new ArrayList();
        }
    }

    private void initConditions() {
        if (this.Params.conditions == null) {
            this.Params.conditions = new ArrayList();
        }
    }

    public void preparedInsert(String sql) throws SQLException {
        this.preparedInsert(this.prepareDBName, sql);
    }

    public void preparedInsert(Params params, NewSQLInfo sql) throws SQLException {
        this.preparedInsert(params, this.prepareDBName, sql);
    }

    public static void updateClob(Object content, Connection conn, String table, String clobColumn, String keyColumn, String keyValue, String dbName) throws SQLException, IOException {
        DBUtil.getDBAdapter(dbName).updateClob(content, conn, table, clobColumn, keyColumn, keyValue, dbName);
    }

    public static void updateBlob(InputStream instream, Connection conn, String table, String blobColumn, String keyColumn, String keyValue, String dbName) throws SQLException, IOException {
        DBUtil.getDBAdapter(dbName).updateBlob(instream, conn, table, blobColumn, keyColumn, keyValue, dbName);
    }

    public static void updateBlob(byte[] value, Connection conn, String table, String blobColumn, String keyColumn, String keyValue, String dbName) throws SQLException, IOException {
        DBUtil.getDBAdapter(dbName).updateBlob(value, conn, table, blobColumn, keyColumn, keyValue, dbName);
    }

    public void setPrimaryKey(int i, long keyvalue) throws SQLException {
        try {
            this.addParam(i, new Long(keyvalue), "setLong(int, long)");
            if (this.Params.updateKeyInfo == null) {
                this.Params.updateKeyInfo = new UpdateKeyInfo();
            }
            this.Params.updateKeyInfo.keyValue = keyvalue + "";
            this.Params.updateKeyInfo.type = "long";
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setPrimaryKey(int i, long keyvalue, String keyname) throws SQLException {
        try {
            this.addParam(i, new Long(keyvalue), "setLong(int, long)");
            if (this.Params.updateKeyInfo == null) {
                this.Params.updateKeyInfo = new UpdateKeyInfo();
            }
            this.Params.updateKeyInfo.keyValue = keyvalue + "";
            this.Params.updateKeyInfo.keyName = keyname;
            this.Params.updateKeyInfo.type = "long";
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setContdition(int i, String value, String filedname) throws SQLException {
        this.setString(i, value);
        this.initConditions();
        BigData condition = new BigData();
        condition.bigdataField = filedname;
        condition.bigdata = new Integer(value);
        condition.type = 3;
        condition.index = i;
        this.Params.conditions.add(condition);
    }

    public void setContdition(int i, int value, String filedname) throws SQLException {
        this.setInt(i, value);
        this.initConditions();
        BigData condition = new BigData();
        condition.bigdataField = filedname;
        condition.bigdata = new Integer(value);
        condition.type = 4;
        condition.index = i;
        this.Params.conditions.add(condition);
    }

    public void setPrimaryKey(int i, int keyvalue) throws SQLException {
        try {
            this.addParam(i, new Integer(keyvalue), "setInt(int, int)");
            if (this.Params.updateKeyInfo == null) {
                this.Params.updateKeyInfo = new UpdateKeyInfo();
            }
            this.Params.updateKeyInfo.keyValue = keyvalue + "";
            this.Params.updateKeyInfo.type = "int";
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setPrimaryKey(int i, int keyvalue, String keyName) throws SQLException {
        try {
            this.addParam(i, new Integer(keyvalue), "setInt(int, int)");
            if (this.Params.updateKeyInfo == null) {
                this.Params.updateKeyInfo = new UpdateKeyInfo();
            }
            this.Params.updateKeyInfo.keyValue = keyvalue + "";
            this.Params.updateKeyInfo.keyName = keyName;
            this.Params.updateKeyInfo.type = "int";
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setPrimaryKey(int i, String keyvalue) throws SQLException {
        try {
            if (this.Params.updateKeyInfo == null) {
                this.Params.updateKeyInfo = new UpdateKeyInfo();
            }
            this.Params.updateKeyInfo.type = "string";
            this.Params.updateKeyInfo.keyValue = keyvalue;
            this.addParam(i, keyvalue, "setString(int, String)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setPrimaryKey(int i, String keyvalue, String keyName) throws SQLException {
        try {
            this.Params.updateKeyInfo = new UpdateKeyInfo();
            this.Params.updateKeyInfo.keyValue = keyvalue;
            this.Params.updateKeyInfo.keyName = keyName;
            this.Params.updateKeyInfo.type = "string";
            this.addParam(i, keyvalue, "setString(int, String)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void preparedInsert(String dbName, String sql) throws SQLException {
        this.preparedInsert((Params)null, dbName, new NewSQLInfo(sql));
    }

    public void preparedInsert(Params params, String dbName, NewSQLInfo sql) throws SQLException {
        this.Params = params == null ? this.buildParams() : params;
        this.Params.action = 0;
        this.preparedSql(this.Params, dbName, sql);
    }

    public void preparedInsert(SQLParams params, String dbName, SQLInfo sql) throws SQLException {
        params.buildParams(sql, dbName);
        this.preparedInsert(params.getRealParams(), dbName, params.getNewsql());
    }

    public void preparedInsert(SQLParams params, String dbName, String sql) throws SQLException {
        params.buildParams(sql, dbName);
        this.preparedInsert(params.getRealParams(), dbName, params.getNewsql());
    }

    public void preparedInsert(SQLParams params, SQLInfo sql) throws SQLException {
        this.preparedInsert(params, this.prepareDBName, sql);
    }

    public void preparedInsert(SQLParams params, String sql) throws SQLException {
        this.preparedInsert(params, this.prepareDBName, sql);
    }

    public void preparedSql(Params Params2, String dbName, NewSQLInfo sql) throws SQLException {
        this.prepareDBName = dbName;
        Params2.prepareSqlifo = sql;
    }

    private void resetFromSetMethod(Exception e) throws SQLException {
        if (this.Params != null) {
            this.Params.clear();
            this.Params = null;
        }
        if (this.batchparams != null) {
            this.batchparams.clear();
            this.batchparams = null;
        }
        this.prepareDBName = SQLManager.getInstance().getDefaultDBName();
        this.oldcommited = true;
        this.oraclerownum = null;
        this.batchOptimize = false;
        if (e != null) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e.getMessage());
        }
    }

    public static String getFileContent(File file) throws IOException {
        StringWriter swriter = null;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            swriter = new StringWriter();
            int len = 0;
            char[] buffer = new char[1024];
            while ((len = reader.read(buffer)) > 0) {
                ((Writer)swriter).write(buffer, 0, len);
            }
            ((Writer)swriter).flush();
            String string = ((Object)swriter).toString();
            return string;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException iOException) {}
            }
            if (swriter != null) {
                try {
                    ((Writer)swriter).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void updateBigDatas(Params params, UpdateKeyInfo updateKeyInfo, Connection preparedCon, String prepareDBName, String[] preparedfields) throws SQLException, IOException {
        block4: for (int i = 0; params.bigdatas != null && i < params.bigdatas.size(); ++i) {
            BigData bigdata = (BigData)params.bigdatas.get(i);
            String bigdataField = bigdata.bigdataField;
            if (bigdataField == null) {
                bigdataField = preparedfields[bigdata.index - 1];
            }
            String msg = "\u6ca1\u6709\u6307\u5b9a\u63d2\u5165\u7684\u5927\u5b57\u6bb5\u540d\u79f0";
            if (params.action == 1) {
                msg = "\u6ca1\u6709\u6307\u5b9a\u63d2\u5165\u7684\u5927\u5b57\u6bb5\u540d\u79f0";
            }
            if (bigdataField == null) {
                throw new SQLException(msg);
            }
            switch (bigdata.type) {
                case 2: {
                    PreparedDBUtil.updateClob(bigdata.bigdata, preparedCon, updateKeyInfo.tableName, bigdataField, updateKeyInfo.keyName, updateKeyInfo.keyValue, prepareDBName);
                    continue block4;
                }
                case 1: {
                    if (bigdata.bigdata instanceof byte[]) {
                        PreparedDBUtil.updateBlob((byte[])bigdata.bigdata, preparedCon, updateKeyInfo.tableName, bigdataField, updateKeyInfo.keyName, updateKeyInfo.keyValue, prepareDBName);
                        continue block4;
                    }
                    if (bigdata.bigdata instanceof File) {
                        PreparedDBUtil.updateBlob(new FileInputStream((File)bigdata.bigdata), preparedCon, updateKeyInfo.tableName, bigdataField, updateKeyInfo.keyName, updateKeyInfo.keyValue, prepareDBName);
                        continue block4;
                    }
                    if (bigdata.bigdata instanceof InputStream) {
                        PreparedDBUtil.updateBlob((InputStream)bigdata.bigdata, preparedCon, updateKeyInfo.tableName, bigdataField, updateKeyInfo.keyName, updateKeyInfo.keyValue, prepareDBName);
                        continue block4;
                    }
                    throw new SQLException("Blob \u5b57\u6bb5\u5185\u5bb9\u5f02\u5e38\uff1a\u672a\u77e5\u7684\u7c7b\u578b[" + bigdata.bigdata + "]");
                }
                default: {
                    throw new SQLException("\u672a\u77e5\u7684\u5927\u5b57\u6bb5\u7c7b\u578b\uff1a[type=" + bigdata.type + "]");
                }
            }
        }
    }

    public void preparedUpdate(String sql) throws SQLException {
        this.Params = this.buildParams();
        this.Params.action = 1;
        this.preparedSql(this.Params, this.prepareDBName, new NewSQLInfo(sql));
    }

    public void preparedSelect(String sql) throws SQLException {
        this.preparedSelect((Params)null, new NewSQLInfo(sql));
    }

    public void preparedSelect(Params params, NewSQLInfo sql) throws SQLException {
        this.preparedSelect(params, this.prepareDBName, sql);
    }

    public void preparedSelect(SQLParams params_, String sql) throws SQLException {
        params_.buildParams(sql, this.prepareDBName);
        this.preparedSelect(params_.getRealParams(), params_.getNewsql());
    }

    public void preparedSelect(String sql, long offset, int pagesize) throws SQLException {
        this.preparedSelect(this.prepareDBName, sql, offset, pagesize, -1L);
    }

    public void preparedSelect(String sql, long offset, int pagesize, long totalsize) throws SQLException {
        this.preparedSelect(this.prepareDBName, sql, offset, pagesize, totalsize);
    }

    public void preparedSelectWithTotalsizesql(String sql, long offset, int pagesize, String totalsizesql) throws SQLException {
        this.preparedSelectWithTotalsizesql(this.prepareDBName, sql, offset, pagesize, totalsizesql);
    }

    public void preparedSelect(String sql, long offset, int pagesize, String oraclerownum, long totalsize) throws SQLException {
        this.preparedSelect(this.prepareDBName, sql, offset, pagesize, oraclerownum, totalsize);
    }

    public void preparedSelectWithTotalsizesql(String sql, long offset, int pagesize, String oraclerownum, String totalsizesql) throws SQLException {
        this.preparedSelectWithTotalsizesql(this.prepareDBName, sql, offset, pagesize, oraclerownum, totalsizesql);
    }

    public void preparedSelect(String sql, long offset, int pagesize, String oraclerownum) throws SQLException {
        this.preparedSelect(this.prepareDBName, sql, offset, pagesize, oraclerownum, -1L);
    }

    public void preparedSelect(String prepareDBName, String sql) throws SQLException {
        this.Params = this.buildParams();
        this.preparedSelect(this.Params, prepareDBName, new NewSQLInfo(sql));
    }

    public void preparedSelect(Params params, String prepareDBName, NewSQLInfo sql) throws SQLException {
        this.Params = params == null ? this.buildParams() : params;
        this.Params.action = 4;
        this.preparedSql(this.Params, prepareDBName, sql);
    }

    public void preparedSelect(SQLParams params, String prepareDBName, String sql) throws SQLException {
        if (params != null) {
            params.buildParams(sql, prepareDBName);
            this.preparedSelect(params.getRealParams(), prepareDBName, params.getNewsql());
        } else {
            this.preparedSelect((Params)null, prepareDBName, new NewSQLInfo(sql));
        }
    }

    public void preparedSelect(String prepareDBName, String sql, long offset, int pagesize) throws SQLException {
        this.preparedSelect(prepareDBName, sql, offset, pagesize, this.oraclerownum, -1L);
    }

    public void preparedSelect(String prepareDBName, String sql, long offset, int pagesize, long totalsize) throws SQLException {
        this.preparedSelect(prepareDBName, sql, offset, pagesize, this.oraclerownum, totalsize);
    }

    public void preparedSelectWithTotalsizesql(String prepareDBName, String sql, long offset, int pagesize, String totalsizesql) throws SQLException {
        this.preparedSelectWithTotalsizesql(prepareDBName, sql, offset, pagesize, this.oraclerownum, totalsizesql);
    }

    public void preparedSelect(Params params, String prepareDBName, NewSQLInfo sql, long offset, int pagesize, long totalsize) throws SQLException {
        this.preparedSelect(params, prepareDBName, sql, offset, pagesize, this.oraclerownum, totalsize);
    }

    public void preparedSelectWithTotalsizesql(Params params, String prepareDBName, NewSQLInfo sql, long offset, int pagesize) throws SQLException {
        this.preparedSelectWithTotalsizesql(params, prepareDBName, sql, offset, pagesize, this.oraclerownum);
    }

    public void preparedSelect(Params params, String prepareDBName, NewSQLInfo sql, long offset, int pagesize) throws SQLException {
        this.preparedSelect(params, prepareDBName, sql, offset, pagesize, this.oraclerownum, -1L);
    }

    public void preparedSelect(SQLParams params, String prepareDBName, String sql, long offset, int pagesize, long totalsize) throws SQLException {
        if (params != null) {
            params.buildParams(sql, prepareDBName);
            this.preparedSelect(params.getRealParams(), prepareDBName, params.getNewsql(), offset, pagesize, totalsize);
        } else {
            this.preparedSelect((Params)null, prepareDBName, new NewSQLInfo(sql), offset, pagesize, totalsize);
        }
    }

    public void preparedSelectWithTotalsizesql(SQLParams params, String prepareDBName, String sql, long offset, int pagesize, String totalsizesql) throws SQLException {
        if (params != null) {
            params.buildParams(sql, totalsizesql, prepareDBName);
            this.preparedSelectWithTotalsizesql(params.getRealParams(), prepareDBName, params.getNewsql(), offset, pagesize);
        } else {
            this.preparedSelectWithTotalsizesql((Params)null, prepareDBName, new NewSQLInfo(sql, totalsizesql), offset, pagesize);
        }
    }

    public void preparedSelect(SQLParams params, String prepareDBName, String sql, long offset, int pagesize) throws SQLException {
        if (params != null) {
            params.buildParams(sql, prepareDBName);
            this.preparedSelect(params.getRealParams(), prepareDBName, params.getNewsql(), offset, pagesize, -1L);
        } else {
            this.preparedSelect((Params)null, prepareDBName, new NewSQLInfo(sql), offset, pagesize, -1L);
        }
    }

    public void preparedSelect(SQLParams params, String sql, long offset, int pagesize, long totalsize) throws SQLException {
        this.preparedSelect(params, null, sql, offset, pagesize, totalsize);
    }

    public void preparedSelectWithTotalsizesql(SQLParams params, String sql, long offset, int pagesize, String totalsizesql) throws SQLException {
        this.preparedSelectWithTotalsizesql(params, null, sql, offset, pagesize, totalsizesql);
    }

    public void preparedSelect(SQLParams params, String sql, long offset, int pagesize) throws SQLException {
        this.preparedSelect(params, null, sql, offset, pagesize, -1L);
    }

    public void preparedSelect(String prepareDBName, String sql, long offset, int pagesize, String oraclerownum, long totalsize) throws SQLException {
        this.preparedSelect(prepareDBName, SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false), offset, pagesize, oraclerownum, totalsize);
    }

    public void preparedSelect(String prepareDBName, SQLInfo sql, long offset, int pagesize, String oraclerownum, long totalsize) throws SQLException {
        this.Params = this.buildParams();
        this.preparedSelect(this.Params, prepareDBName, new NewSQLInfo(sql), offset, pagesize, oraclerownum, totalsize);
    }

    public void setPagineOrderby(String pagineOrderby) {
        this.Params.setPagineOrderby(pagineOrderby);
    }

    public void preparedSelectWithTotalsizesql(String prepareDBName, String sql, long offset, int pagesize, String oraclerownum, String totalsizesql) throws SQLException {
        this.preparedSelectWithTotalsizesql(prepareDBName, SQLUtil.getGlobalSQLUtil().getSQLInfo(sql, false, false), offset, pagesize, oraclerownum, SQLUtil.getGlobalSQLUtil().getSQLInfo(totalsizesql, false, false));
    }

    public void preparedSelectWithTotalsizesql(String prepareDBName, SQLInfo sql, long offset, int pagesize, String oraclerownum, SQLInfo totalsizesql) throws SQLException {
        this.Params = this.buildParams();
        this.preparedSelectWithTotalsizesql(this.Params, prepareDBName, new NewSQLInfo(sql, totalsizesql), offset, pagesize, oraclerownum);
    }

    public void preparedSelect(String prepareDBName, String sql, long offset, int pagesize, String oraclerownum) throws SQLException {
        this.Params = this.buildParams();
        this.preparedSelect(this.Params, prepareDBName, new NewSQLInfo(sql), offset, pagesize, oraclerownum, -1L);
    }

    public void preparedSelect(Params params, String prepareDBName, NewSQLInfo sql, long offset, int pagesize, String oraclerownum, long totalsize) throws SQLException {
        this.Params = params == null ? this.buildParams() : params;
        this.Params.action = 3;
        this.pagesize = pagesize;
        this.Params.totalsize = totalsize;
        this.offset = StatementInfo.rebuildOffset(offset, pagesize, totalsize);
        this.Params.prepareSqlifo = sql;
        this.oraclerownum = oraclerownum;
        this.preparedSql(this.Params, prepareDBName, sql);
    }

    public void preparedSelectWithTotalsizesql(Params params, String prepareDBName, NewSQLInfo sql, long offset, int pagesize, String oraclerownum) throws SQLException {
        this.Params = params == null ? this.buildParams() : params;
        this.Params.action = 3;
        this.offset = offset;
        this.pagesize = pagesize;
        this.Params.prepareSqlifo = sql;
        this.oraclerownum = oraclerownum;
        this.preparedSql(this.Params, prepareDBName, sql);
    }

    public void preparedSelect(Params params, String prepareDBName, NewSQLInfo sql, long offset, int pagesize, String oraclerownum) throws SQLException {
        this.preparedSelect(params, prepareDBName, sql, offset, pagesize, oraclerownum, -1L);
    }

    public void preparedSelect(SQLParams params, String prepareDBName, String sql, long offset, int pagesize, String oraclerownum, long totalsize) throws SQLException {
        if (params != null) {
            params.buildParams(sql, prepareDBName);
            this.preparedSelect(params.getRealParams(), prepareDBName, params.getNewsql(), offset, pagesize, oraclerownum, totalsize);
        } else {
            this.preparedSelect((Params)null, prepareDBName, new NewSQLInfo(sql), offset, pagesize, oraclerownum, totalsize);
        }
    }

    public void preparedSelectWithTotalsizesql(SQLParams params, String prepareDBName, String sql, long offset, int pagesize, String oraclerownum, String totalsizesql) throws SQLException {
        if (params != null) {
            params.buildParams(sql, totalsizesql, prepareDBName);
            this.preparedSelectWithTotalsizesql(params.getRealParams(), prepareDBName, params.getNewsql(), offset, pagesize, oraclerownum);
        } else {
            this.preparedSelectWithTotalsizesql((Params)null, prepareDBName, new NewSQLInfo(sql, totalsizesql), offset, pagesize, oraclerownum);
        }
    }

    public void preparedSelect(SQLParams params, String prepareDBName, String sql, long offset, int pagesize, String oraclerownum) throws SQLException {
        if (params != null) {
            params.buildParams(sql, prepareDBName);
            this.preparedSelect(params.getRealParams(), prepareDBName, params.getNewsql(), offset, pagesize, oraclerownum, -1L);
        } else {
            this.preparedSelect((Params)null, prepareDBName, new NewSQLInfo(sql), offset, pagesize, oraclerownum, -1L);
        }
    }

    public void preparedSelect(SQLParams params, String sql, long offset, int pagesize, String oraclerownum, long totalsize) throws SQLException {
        this.preparedSelect(params, null, sql, offset, pagesize, oraclerownum, totalsize);
    }

    public void preparedSelectWithTotalsizesql(SQLParams params, String sql, long offset, int pagesize, String oraclerownum, String totalsizesql) throws SQLException {
        this.preparedSelectWithTotalsizesql(params, null, sql, offset, pagesize, oraclerownum, totalsizesql);
    }

    public void preparedSelect(SQLParams params, String sql, long offset, int pagesize, String oraclerownum) throws SQLException {
        this.preparedSelect(params, null, sql, offset, pagesize, oraclerownum, -1L);
    }

    public static String convertOperationType(int action) {
        switch (action) {
            case 3: {
                return "SELECT";
            }
            case 0: {
                return "INSERT";
            }
            case 1: {
                return "UPDATE";
            }
            case 2: {
                return "DELETE";
            }
            case 4: {
                return "SELECT_COMMON";
            }
        }
        return "unkown action";
    }

    public void preparedUpdate(String dbName, String sql) throws SQLException {
        this.Params = this.buildParams();
        this.Params.action = 1;
        this.preparedSql(this.Params, dbName, new NewSQLInfo(sql));
    }

    public void preparedUpdate(Params params, String dbName, NewSQLInfo sql) throws SQLException {
        this.Params = params == null ? this.buildParams() : params;
        this.Params.action = 1;
        this.preparedSql(this.Params, dbName, sql);
    }

    public void preparedUpdate(SQLParams params, String dbName, SQLInfo sql) throws SQLException {
        if (params != null) {
            params.buildParams(sql, dbName);
            this.preparedUpdate(params.getRealParams(), dbName, params.getNewsql());
        } else {
            this.preparedUpdate((Params)null, dbName, new NewSQLInfo(sql));
        }
    }

    public void preparedUpdate(SQLParams params, String dbName, String sql) throws SQLException {
        if (params != null) {
            params.buildParams(sql, dbName);
            this.preparedUpdate(params.getRealParams(), dbName, params.getNewsql());
        } else {
            this.preparedUpdate((Params)null, dbName, new NewSQLInfo(sql));
        }
    }

    public void preparedUpdate(SQLParams params, SQLInfo sql) throws SQLException {
        this.preparedUpdate(params, this.prepareDBName, sql);
    }

    public void preparedUpdate(SQLParams params, String sql) throws SQLException {
        this.preparedUpdate(params, this.prepareDBName, sql);
    }

    public void preparedUpdate(Params params, String sql) throws SQLException {
        this.preparedUpdate(params, this.prepareDBName, new NewSQLInfo(sql));
    }

    public void preparedDelete(String sql) throws SQLException {
        this.preparedDelete((Params)null, sql);
    }

    public void preparedDelete(Params params, String sql) throws SQLException {
        this.preparedDelete(params, this.prepareDBName, new NewSQLInfo(sql));
    }

    public void preparedDelete(String dbName, String sql) throws SQLException {
        this.preparedDelete((Params)null, dbName, new NewSQLInfo(sql));
    }

    public void preparedDelete(Params params, String dbName, NewSQLInfo sql) throws SQLException {
        this.Params = params == null ? this.buildParams() : params;
        this.Params.action = 2;
        this.preparedSql(this.Params, dbName, sql);
    }

    public void preparedDelete(SQLParams params, String dbName, SQLInfo sql) throws SQLException {
        if (params != null) {
            params.buildParams(sql, dbName);
            this.preparedDelete(params.getRealParams(), dbName, params.getNewsql());
        } else {
            this.preparedDelete((Params)null, dbName, new NewSQLInfo(sql));
        }
    }

    public void preparedDelete(SQLParams params, String dbName, String sql) throws SQLException {
        if (params != null) {
            params.buildParams(sql, dbName);
            this.preparedDelete(params.getRealParams(), dbName, params.getNewsql());
        } else {
            this.preparedDelete((Params)null, dbName, new NewSQLInfo(sql));
        }
    }

    public void preparedDelete(SQLParams params, SQLInfo sql) throws SQLException {
        this.preparedDelete(params, this.prepareDBName, sql);
    }

    public void preparedDelete(SQLParams params, String sql) throws SQLException {
        this.preparedDelete(params, this.prepareDBName, sql);
    }

    protected Param buildParam() {
        return new Param();
    }

    protected Params buildParams() {
        return new Params();
    }

    public void addParam(int index, Object data, String method) throws SQLException {
        Param param = this.buildParam();
        param.data = data;
        param.index = index;
        param.method = method;
        this.Params.params.add(param);
    }

    public void setArray(int i, Array x) throws SQLException {
        try {
            this.addParam(i, x, "setArray(int, Array)");
        }
        catch (Exception e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setAsciiStream(int i, InputStream x, int length) throws SQLException {
        try {
            this.addParam(i, new Object[]{x, new Integer(length)}, "setAsciiStream(int, InputStream, int)");
        }
        catch (Exception e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setBigDecimal(int i, BigDecimal x) throws SQLException {
        try {
            this.addParam(i, x, "setBigDecimal(int, BigDecimal)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setBinaryStream(int i, InputStream x, int length) throws SQLException {
        try {
            this.addParam(i, new Object[]{x, new Integer(length)}, "setBinaryStream(int, InputStream, int)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setBlob(int i, byte[] x) throws SQLException {
        try {
            if (x != null) {
                this.addParam(i, x, "setBlob(int, byte[])");
            } else {
                this.setNull(i, 2004);
            }
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setBlob(int i, Blob blob) throws SQLException {
        try {
            if (blob != null) {
                this.addParam(i, blob, "setBlob(int,Blob])");
            } else {
                this.setNull(i, 2004);
            }
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setClob(int i, Clob clob) throws SQLException {
        try {
            if (clob != null) {
                this.addParam(i, clob, "setClob(int, Clob)");
            } else {
                this.setNull(i, 2005);
            }
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setBlob(int i, byte[] x, String field) throws SQLException {
        this.setBlob(i, x);
    }

    public void setBlob(int i, File x) throws SQLException {
        if (x == null) {
            this.setNull(i, 2004);
        } else {
            this.addParam(i, x, "setBlob(int, File)");
        }
    }

    public void setBlob(int i, String x) throws SQLException {
        if (x == null) {
            this.setNull(i, 2004);
        } else {
            this.addParam(i, x, "setBlob(int,Blob])");
        }
    }

    public String getString(File x) throws SQLException {
        FileInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new FileInputStream(x);
            out = new ByteArrayOutputStream();
            byte[] v = new byte[1024];
            int i = 0;
            while ((i = in.read(v)) > 0) {
                out.write(v, 0, i);
            }
            String string = new String(out.toByteArray());
            return string;
        }
        catch (FileNotFoundException e) {
            throw new NestedSQLException((Throwable)e);
        }
        catch (IOException e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getString(InputStream in, String charset) throws SQLException {
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            byte[] v = new byte[1024];
            int i = 0;
            while ((i = in.read(v)) > 0) {
                out.write(v, 0, i);
            }
            if (charset == null) {
                String string = new String(out.toByteArray());
                return string;
            }
            String string = new String(out.toByteArray(), charset);
            return string;
        }
        catch (FileNotFoundException e) {
            throw new NestedSQLException((Throwable)e);
        }
        catch (IOException e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public InputStream getInputStream(File x) throws SQLException {
        FileInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new FileInputStream(x);
            out = new ByteArrayOutputStream();
            byte[] v = new byte[1024];
            int i = 0;
            while ((i = in.read(v)) > 0) {
                out.write(v, 0, i);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            return byteArrayInputStream;
        }
        catch (FileNotFoundException e) {
            throw new NestedSQLException((Throwable)e);
        }
        catch (Exception e) {
            throw new NestedSQLException((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setBlob(int i, File x, String field) throws SQLException {
        this.setBlob(i, x);
    }

    public void setClob(int i, File file) throws SQLException {
        this.addParam(i, file, "setClob(int i, File file)");
    }

    public void setClob(int i, File file, String field) throws SQLException {
        this.setClob(i, file);
    }

    public void setBoolean(int i, boolean x) throws SQLException {
        try {
            this.addParam(i, new Boolean(x), "setBoolean(int, boolean)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setByte(int i, byte b) throws SQLException {
        try {
            this.addParam(i, new Byte(b), "setByte(int, byte)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setBytes(int i, byte[] x) throws SQLException {
        try {
            this.addParam(i, x, "setBytes(int, byte[])");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setCharacterStream(int i, Reader reader, int length) throws SQLException {
        try {
            this.addParam(i, new Object[]{reader, new Integer(length)}, "setCharacterStream(int, Reader, int)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setClob(int i, String content) throws SQLException {
        if (content != null) {
            this.addParam(i, content, "setClob(int, String)");
        } else {
            this.setNull(i, 2005);
        }
    }

    public void setClob(int i, String content, String field) throws SQLException {
        this.setClob(i, content);
    }

    public void setDate(int i, Date d) throws SQLException {
        try {
            this.addParam(i, d, "setDate(int, java.sql.Date)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setDate(int i, java.util.Date d) throws SQLException {
        try {
            if (d != null) {
                this.addParam(i, new Date(d.getTime()), "setDate(int, java.util.Date)");
            } else {
                this.addParam(i, new Integer(91), "setNull(int, int)");
            }
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setDate(int i, Date d, Calendar cal) throws SQLException {
        try {
            this.addParam(i, new Object[]{d, cal}, "setDate(int, Date, Calendar)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setDouble(int i, double d) throws SQLException {
        try {
            this.addParam(i, new Double(d), "setDouble(int, double)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setFloat(int i, float f) throws SQLException {
        try {
            this.addParam(i, new Float(f), "setFloat(int, float)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setInt(int i, int x) throws SQLException {
        try {
            this.addParam(i, new Integer(x), "setInt(int, int)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setLong(int i, long l) throws SQLException {
        try {
            this.addParam(i, new Long(l), "setLong(int, long)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setNull(int i, int sqlType) throws SQLException {
        try {
            this.addParam(i, new Integer(sqlType), "setNull(int, int)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setNull(int i, int sqlType, String typeName) throws SQLException {
        try {
            this.addParam(i, new Object[]{new Integer(sqlType), typeName}, "setNull(int, int, String)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setObject(int i, Object o) throws SQLException {
        try {
            DB db = DBUtil.getDBAdapter(this.prepareDBName);
            if (db == null) {
                this._setObject(i, o);
            } else {
                db.setObject(this, i, o);
            }
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setObject(int i, Object o, int targetType) throws SQLException {
        try {
            this.addParam(i, new Object[]{o, new Integer(targetType)}, "setObject(int, Object, int)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setObject(int i, Object o, int targetType, int scale) throws SQLException {
        try {
            this.addParam(i, new Object[]{o, new Integer(targetType), new Integer(scale)}, "setObject(int, Object, int, int)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setRef(int i, Ref ref) throws SQLException {
        try {
            this.addParam(i, ref, "setRef(int, Ref)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setShort(int i, short s) throws SQLException {
        try {
            this.addParam(i, new Short(s), "setShort(int, short)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setString(int i, String s) throws SQLException {
        try {
            this.addParam(i, s, "setString(int, String)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setTime(int i, Time t) throws SQLException {
        try {
            this.addParam(i, t, "setTime(int, Time)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setTime(int i, Time t, Calendar cal) throws SQLException {
        try {
            this.addParam(i, new Object[]{t, cal}, "setTime(int, Time, Calendar)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setTimestamp(int i, Timestamp t) throws SQLException {
        try {
            this.addParam(i, t, "setTimestamp(int, Timestamp)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setTimestamp(int i, Timestamp t, Calendar cal) throws SQLException {
        try {
            this.addParam(i, new Object[]{t, cal}, "setTimestamp(int, Timestamp, Calendar)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException {
        try {
            this.addParam(i, new Object[]{x, new Integer(length)}, "setUnicodeStream(int, InputStream, int)");
        }
        catch (SQLException e) {
            this.resetFromSetMethod(e);
        }
    }

    public String getPrepareDBName() {
        return this.prepareDBName;
    }

    public void setPrepareDBName(String prepareDBName) {
        this.prepareDBName = prepareDBName;
    }

    public static void main(String[] args) {
        PreparedDBUtil dbUtil = new PreparedDBUtil();
        String sql = "insert into tableinfo(1) values(?)";
        try {
            dbUtil.preparedInsert(sql);
            dbUtil.setInt(0, 1);
            Object object = dbUtil.executePrepared();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void resetPrepare() {
        try {
            this.resetFromSetMethod(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addPreparedBatch() {
        if (this.batchparams == null) {
            this.batchparams = new ArrayList<Params>();
        }
        this.batchparams.add(this.Params);
        NewSQLInfo old = this.Params.prepareSqlifo;
        this.Params = this.buildParams();
        this.Params.prepareSqlifo = old;
    }

    public void addPreparedBatch(ListSQLParams batchsqlparams_) throws SQLException {
        if (batchsqlparams_ == null || batchsqlparams_.getSqlparams() == null || batchsqlparams_.getSqlparams().size() == 0) {
            throw new SQLException("batchsqlparams == null || batchsqlparams.size() == 0");
        }
        if (this.batchparams == null) {
            this.batchparams = new ArrayList<Params>();
        }
        List<SQLParams> batchsqlparams = batchsqlparams_.getSqlparams();
        int i = 0;
        boolean multiparser = batchsqlparams_.multiparser();
        NewSQLInfo newsql = null;
        for (SQLParams sqlParams : batchsqlparams) {
            if (!multiparser) {
                if (i == 0) {
                    sqlParams.buildParams(this.prepareDBName);
                    newsql = sqlParams.getNewsql();
                    ++i;
                } else {
                    sqlParams.buildParamsNewSQLInfo(this.prepareDBName, newsql);
                }
            } else {
                sqlParams.buildParams(this.prepareDBName);
            }
            this.Params = sqlParams.getRealParams();
            this.Params.prepareSqlifo = sqlParams.getNewsql();
            this.batchparams.add(this.Params);
        }
    }

    public void setBatchOptimize(boolean batchOptimize) {
        this.batchOptimize = batchOptimize;
    }

    private String buildInfo(int[] r) {
        if (r.length == 0) {
            return "No sql been executed.";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < r.length; ++i) {
            if (i == 0) {
                ret.append(i).append(":").append(r[i]);
                continue;
            }
            ret.append(",").append(i).append(":").append(r[i]);
        }
        return ret.toString();
    }

    public void executePreparedBatch(Connection con_) throws SQLException {
        this.executePreparedBatch(con_, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executePreparedBatch(Connection con_, GetCUDResult CUDResult) throws SQLException {
        if (this.batchparams == null || this.batchparams.size() == 0) {
            log.info("Can not execute single prepared statement as batch prepared operation,Please call method executePrepared(Connection con)!");
            return;
        }
        StatementInfo stmtInfo = null;
        Statement statement = null;
        ArrayList resources = null;
        try {
            boolean getCUDResult;
            stmtInfo = new StatementInfo(this.prepareDBName, null, false, con_, false);
            stmtInfo.init();
            boolean bl = getCUDResult = CUDResult != null;
            if (getCUDResult) {
                JDBCPool pool = SQLManager.getInstance().getPool(this.prepareDBName);
                stmtInfo.setRETURN_GENERATED_KEYS(pool.getRETURN_GENERATED_KEYS());
            }
            if (this.batchOptimize) {
                Collections.sort(this.batchparams);
            }
            NewSQLInfo old_sql = null;
            boolean showsql = PreparedDBUtil.showsql(stmtInfo.getDbname());
            int i = 0;
            while (i < this.batchparams.size()) {
                int[] ret2;
                Params Params2 = this.batchparams.get(i);
                ++i;
                if (Params2.action == 3) {
                    throw new SQLException("Batch prepared Operation do not support pagine query opations.");
                }
                if (Params2.action == 4) {
                    throw new SQLException("Batch prepared Operation do not support query opations.");
                }
                if (old_sql == null) {
                    old_sql = Params2.prepareSqlifo;
                    if (showsql && log.isInfoEnabled()) {
                        log.info("Execute JDBC prepared batch statement:{}", (Object)Params2.prepareSqlifo.getNewsql());
                    }
                    statement = stmtInfo.prepareStatement(Params2.prepareSqlifo.getNewsql(), getCUDResult);
                    if (resources == null) {
                        resources = new ArrayList();
                    }
                    this.setUpParams(stmtInfo, Params2, (PreparedStatement)statement, resources);
                    statement.addBatch();
                } else if (!old_sql.equals(Params2.prepareSqlifo)) {
                    try {
                        ret2 = statement.executeBatch();
                        if (showsql && log.isInfoEnabled()) {
                            log.info("Execute prepared Batch sql[" + old_sql.getNewsql() + "] success");
                        }
                    }
                    finally {
                        try {
                            statement.close();
                        }
                        catch (Exception ret2) {}
                        statement = null;
                        if (resources != null) {
                            this.releaseResources(resources);
                            resources = null;
                        }
                    }
                    old_sql = Params2.prepareSqlifo;
                    if (showsql && log.isInfoEnabled()) {
                        log.debug("Execute JDBC prepared batch statement:{}", (Object)Params2.prepareSqlifo.getNewsql());
                    }
                    statement = stmtInfo.prepareStatement(Params2.prepareSqlifo.getNewsql(), getCUDResult);
                    if (resources == null) {
                        resources = new ArrayList();
                    }
                    this.setUpParams(stmtInfo, Params2, (PreparedStatement)statement, resources);
                    statement.addBatch();
                } else {
                    if (resources == null) {
                        resources = new ArrayList();
                    }
                    this.setUpParams(stmtInfo, Params2, (PreparedStatement)statement, resources);
                    statement.addBatch();
                }
                if (i != this.batchparams.size()) continue;
                try {
                    ret2 = statement.executeBatch();
                    if (showsql && log.isInfoEnabled()) {
                        log.info("Execute prepared Batch sql[" + old_sql.getNewsql() + "] success");
                    }
                    if (CUDResult == null) return;
                    List<Object> morekeys = StatementInfo.getGeneratedKeys((PreparedStatement)statement);
                    CUDResult.setKeys(morekeys);
                    CUDResult.setResult(ret2);
                    CUDResult.setUpdatecount(ret2);
                    return;
                }
                finally {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                    statement = null;
                    if (resources != null) {
                        this.releaseResources(resources);
                        resources = null;
                    }
                    return;
                }
            }
        }
        catch (BatchUpdateException error) {
            if (stmtInfo == null) throw error;
            stmtInfo.errorHandle(error);
            throw error;
        }
        catch (Exception e) {
            if (stmtInfo != null) {
                stmtInfo.errorHandle(e);
            }
            if (!(e instanceof SQLException)) throw new NestedSQLException(e.getMessage(), (Throwable)e);
            throw (SQLException)e;
        }
        finally {
            if (stmtInfo != null) {
                stmtInfo.dofinally();
            }
            stmtInfo = null;
            if (resources != null) {
                this.releaseResources(resources);
            }
            if (this.batchparams != null) {
                this.batchparams.clear();
            }
            this.resetFromSetMethod(null);
        }
    }

    public void _setObject(int i, Object o) throws SQLException {
        if (o == null || o instanceof Timestamp) {
            this.addParam(i, o, "setObject(int, Object)");
        } else if (o instanceof Date) {
            o = new Timestamp(((Date)o).getTime());
            this.addParam(i, o, "setObject(int, Object)");
        } else if (o instanceof java.util.Date) {
            o = new Timestamp(((java.util.Date)o).getTime());
            this.addParam(i, o, "setObject(int, Object)");
        } else {
            this.addParam(i, o, "setObject(int, Object)");
        }
    }

    public static class UpdateKeyInfo {
        String tableName;
        String keyName;
        String keyValue;
        String type;
    }

    class BigData {
        static final int BLOB = 1;
        static final int CLOB = 2;
        static final int TEXT = 3;
        static final int NUMERIC = 4;
        int type;
        Object bigdata;
        String bigdataField;
        int index;

        BigData() {
        }
    }
}

