/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.ITypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.DB2TypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.MySqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.OracleTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.PostgreSqlTypeConvert;
import com.baomidou.mybatisplus.generator.config.converts.SqlServerTypeConvert;
import com.baomidou.mybatisplus.generator.config.querys.DB2Query;
import com.baomidou.mybatisplus.generator.config.querys.MariadbQuery;
import com.baomidou.mybatisplus.generator.config.querys.MySqlQuery;
import com.baomidou.mybatisplus.generator.config.querys.OracleQuery;
import com.baomidou.mybatisplus.generator.config.querys.PostgreSqlQuery;
import com.baomidou.mybatisplus.generator.config.querys.SqlServerQuery;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class DataSourceConfig {
    private IDbQuery dbQuery;
    private DbType dbType;
    private String schemaName;
    private ITypeConvert typeConvert;
    private String url;
    private String driverName;
    private String username;
    private String password;

    public IDbQuery getDbQuery() {
        if (null == this.dbQuery) {
            switch (this.getDbType()) {
                case ORACLE: {
                    this.dbQuery = new OracleQuery();
                    break;
                }
                case SQL_SERVER: {
                    this.dbQuery = new SqlServerQuery();
                    break;
                }
                case POSTGRE_SQL: {
                    this.dbQuery = new PostgreSqlQuery();
                    break;
                }
                case DB2: {
                    this.dbQuery = new DB2Query();
                    break;
                }
                case MARIADB: {
                    this.dbQuery = new MariadbQuery();
                    break;
                }
                default: {
                    this.dbQuery = new MySqlQuery();
                }
            }
        }
        return this.dbQuery;
    }

    public DbType getDbType() {
        if (null == this.dbType) {
            if (this.driverName.contains("mysql")) {
                this.dbType = DbType.MYSQL;
            } else if (this.driverName.contains("oracle")) {
                this.dbType = DbType.ORACLE;
            } else if (this.driverName.contains("postgresql")) {
                this.dbType = DbType.POSTGRE_SQL;
            } else if (this.driverName.contains("db2")) {
                this.dbType = DbType.DB2;
            } else if (this.driverName.contains("mariadb")) {
                this.dbType = DbType.MARIADB;
            } else {
                throw ExceptionUtils.mpe((String)"Unknown type of database!", (Object[])new Object[0]);
            }
        }
        return this.dbType;
    }

    public ITypeConvert getTypeConvert() {
        if (null == this.typeConvert) {
            switch (this.getDbType()) {
                case ORACLE: {
                    this.typeConvert = new OracleTypeConvert();
                    break;
                }
                case SQL_SERVER: {
                    this.typeConvert = new SqlServerTypeConvert();
                    break;
                }
                case POSTGRE_SQL: {
                    this.typeConvert = new PostgreSqlTypeConvert();
                    break;
                }
                case DB2: {
                    this.typeConvert = new DB2TypeConvert();
                    break;
                }
                case MARIADB: {
                    this.typeConvert = new MySqlTypeConvert();
                    break;
                }
                default: {
                    this.typeConvert = new MySqlTypeConvert();
                }
            }
        }
        return this.typeConvert;
    }

    public Connection getConn() {
        Connection conn = null;
        try {
            Class.forName(this.driverName);
            conn = DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        return conn;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public DataSourceConfig setDbQuery(IDbQuery dbQuery) {
        this.dbQuery = dbQuery;
        return this;
    }

    public DataSourceConfig setDbType(DbType dbType) {
        this.dbType = dbType;
        return this;
    }

    public DataSourceConfig setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public DataSourceConfig setTypeConvert(ITypeConvert typeConvert) {
        this.typeConvert = typeConvert;
        return this;
    }

    public DataSourceConfig setUrl(String url) {
        this.url = url;
        return this;
    }

    public DataSourceConfig setDriverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    public DataSourceConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public DataSourceConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceConfig)) {
            return false;
        }
        DataSourceConfig other = (DataSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IDbQuery this$dbQuery = this.getDbQuery();
        IDbQuery other$dbQuery = other.getDbQuery();
        if (this$dbQuery == null ? other$dbQuery != null : !this$dbQuery.equals(other$dbQuery)) {
            return false;
        }
        DbType this$dbType = this.getDbType();
        DbType other$dbType = other.getDbType();
        if (this$dbType == null ? other$dbType != null : !this$dbType.equals(other$dbType)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        ITypeConvert this$typeConvert = this.getTypeConvert();
        ITypeConvert other$typeConvert = other.getTypeConvert();
        if (this$typeConvert == null ? other$typeConvert != null : !this$typeConvert.equals(other$typeConvert)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$driverName = this.getDriverName();
        String other$driverName = other.getDriverName();
        if (this$driverName == null ? other$driverName != null : !this$driverName.equals(other$driverName)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IDbQuery $dbQuery = this.getDbQuery();
        result = result * 59 + ($dbQuery == null ? 43 : $dbQuery.hashCode());
        DbType $dbType = this.getDbType();
        result = result * 59 + ($dbType == null ? 43 : $dbType.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        ITypeConvert $typeConvert = this.getTypeConvert();
        result = result * 59 + ($typeConvert == null ? 43 : $typeConvert.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $driverName = this.getDriverName();
        result = result * 59 + ($driverName == null ? 43 : $driverName.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "DataSourceConfig(dbQuery=" + this.getDbQuery() + ", dbType=" + this.getDbType() + ", schemaName=" + this.getSchemaName() + ", typeConvert=" + this.getTypeConvert() + ", url=" + this.getUrl() + ", driverName=" + this.getDriverName() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

