/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.traverser;

import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.traverser.VerticesArgs;
import com.baidu.hugegraph.util.E;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomizedPathsRequest {
    @JsonProperty(value="sources")
    private VerticesArgs sources = null;
    @JsonProperty(value="steps")
    private List<Step> steps = new ArrayList<Step>();
    @JsonProperty(value="sort_by")
    private SortBy sortBy = SortBy.NONE;
    @JsonProperty(value="capacity")
    private long capacity = 10000000L;
    @JsonProperty(value="limit")
    private long limit = 10L;
    @JsonProperty(value="with_vertex")
    private boolean withVertex = false;

    private CustomizedPathsRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("CustomizedPathsRequest{sourceVertex=%s,steps=%s,sortBy=%s,capacity=%s,limit=%s,withVertex=%s}", new Object[]{this.sources, this.steps, this.sortBy, this.capacity, this.limit, this.withVertex});
    }

    public static enum SortBy {
        INCR,
        DECR,
        NONE;

    }

    public static class Step {
        @JsonProperty(value="direction")
        private String direction = null;
        @JsonProperty(value="labels")
        private List<String> labels = new ArrayList<String>();
        @JsonProperty(value="properties")
        private Map<String, Object> properties = new HashMap<String, Object>();
        @JsonProperty(value="weight_by")
        private String weightBy = null;
        @JsonProperty(value="default_weight")
        private double defaultWeight = 0.0;
        @JsonProperty(value="degree")
        private long degree = 10000L;
        @JsonProperty(value="sample")
        private long sample = 100L;

        private Step() {
        }

        public String toString() {
            return String.format("Step{direction=%s,labels=%s,properties=%s,weightBy=%s,defaultWeight=%s,degree=%s,sample=%s}", this.direction, this.labels, this.properties, this.weightBy, this.defaultWeight, this.degree, this.sample);
        }

        public static class Builder {
            private Step step = new Step();

            private Builder() {
            }

            public Builder direction(Direction direction) {
                this.step.direction = direction.toString();
                return this;
            }

            public Builder labels(List<String> labels) {
                this.step.labels.addAll(labels);
                return this;
            }

            public Builder labels(String ... labels) {
                this.step.labels.addAll(Arrays.asList(labels));
                return this;
            }

            public Builder properties(Map<String, Object> properties) {
                this.step.properties = properties;
                return this;
            }

            public Builder properties(String key, Object value) {
                this.step.properties.put(key, value);
                return this;
            }

            public Builder weightBy(String property) {
                this.step.weightBy = property;
                return this;
            }

            public Builder defaultWeight(double weight) {
                this.step.defaultWeight = weight;
                return this;
            }

            public Builder degree(long degree) {
                TraversersAPI.checkDegree(degree);
                this.step.degree = degree;
                return this;
            }

            public Builder sample(int sample) {
                E.checkArgument(((long)sample == -1L || sample > 0 ? 1 : 0) != 0, (String)"The sample must be > 0, but got: %s", (Object[])new Object[]{sample});
                this.step.sample = sample;
                return this;
            }

            private Step build() {
                TraversersAPI.checkDegree(this.step.degree);
                E.checkArgument((this.step.sample > 0L || this.step.sample == -1L ? 1 : 0) != 0, (String)"The sample must be > 0, but got: %s", (Object[])new Object[]{this.step.sample});
                E.checkArgument((this.step.degree == -1L || this.step.degree >= this.step.sample ? 1 : 0) != 0, (String)"Degree must be greater than or equal to sample, but got degree %s and sample %s", (Object[])new Object[]{this.step.degree, this.step.sample});
                return this.step;
            }
        }
    }

    public static class Builder {
        private CustomizedPathsRequest request = new CustomizedPathsRequest();
        private VerticesArgs.Builder sourcesBuilder = VerticesArgs.builder();
        private List<Step.Builder> stepBuilders = new ArrayList<Step.Builder>();

        private Builder() {
        }

        public VerticesArgs.Builder sources() {
            return this.sourcesBuilder;
        }

        public Step.Builder steps() {
            Step.Builder builder = new Step.Builder();
            this.stepBuilders.add(builder);
            return builder;
        }

        public Builder sortBy(SortBy sortBy) {
            this.request.sortBy = sortBy;
            return this;
        }

        public Builder capacity(long capacity) {
            TraversersAPI.checkCapacity(capacity);
            this.request.capacity = capacity;
            return this;
        }

        public Builder limit(long limit) {
            TraversersAPI.checkLimit(limit);
            this.request.limit = limit;
            return this;
        }

        public Builder withVertex(boolean withVertex) {
            this.request.withVertex = withVertex;
            return this;
        }

        public CustomizedPathsRequest build() {
            this.request.sources = this.sourcesBuilder.build();
            for (Step.Builder builder : this.stepBuilders) {
                this.request.steps.add(builder.build());
            }
            E.checkArgument((this.request.sources != null ? 1 : 0) != 0, (String)"Source vertices can't be null", (Object[])new Object[0]);
            E.checkArgument((this.request.steps != null && !this.request.steps.isEmpty() ? 1 : 0) != 0, (String)"Steps can't be null or empty", (Object[])new Object[0]);
            TraversersAPI.checkCapacity(this.request.capacity);
            TraversersAPI.checkLimit(this.request.limit);
            return this.request;
        }
    }
}

