/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.traverser;

import com.baidu.hugegraph.structure.traverser.EdgeStep;
import com.baidu.hugegraph.util.E;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class CountRequest {
    @JsonProperty(value="source")
    private Object source = null;
    @JsonProperty(value="steps")
    private List<EdgeStep> steps = new ArrayList<EdgeStep>();
    @JsonProperty(value="contains_traversed")
    public boolean containsTraversed = false;
    @JsonProperty(value="dedup_size")
    public long dedupSize = 1000000L;

    private CountRequest() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("CountRequest{source=%s,steps=%s,containsTraversed=%s,dedupSize=%s", this.source, this.steps, this.containsTraversed, this.dedupSize);
    }

    private static void checkDedupSize(long dedupSize) {
        E.checkArgument((dedupSize >= 0L || dedupSize == -1L ? 1 : 0) != 0, (String)"The dedup size must be >= 0 or == %s, but got: %s", (Object[])new Object[]{-1L, dedupSize});
    }

    public static class Builder {
        private CountRequest request = new CountRequest();
        private List<EdgeStep.Builder> stepBuilders = new ArrayList<EdgeStep.Builder>();

        private Builder() {
        }

        public Builder source(Object source) {
            E.checkArgumentNotNull((Object)source, (String)"The source can't be null", (Object[])new Object[0]);
            this.request.source = source;
            return this;
        }

        public EdgeStep.Builder steps() {
            EdgeStep.Builder builder = EdgeStep.builder();
            this.stepBuilders.add(builder);
            return builder;
        }

        public Builder containsTraversed(boolean containsTraversed) {
            this.request.containsTraversed = containsTraversed;
            return this;
        }

        public Builder dedupSize(long dedupSize) {
            CountRequest.checkDedupSize(dedupSize);
            this.request.dedupSize = dedupSize;
            return this;
        }

        public CountRequest build() {
            E.checkArgumentNotNull((Object)this.request.source, (String)"The source can't be null", (Object[])new Object[0]);
            for (EdgeStep.Builder builder : this.stepBuilders) {
                this.request.steps.add(builder.build());
            }
            E.checkArgument((this.request.steps != null && !this.request.steps.isEmpty() ? 1 : 0) != 0, (String)"The steps can't be null or empty", (Object[])new Object[0]);
            CountRequest.checkDedupSize(this.request.dedupSize);
            return this.request;
        }
    }
}

