/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.schema;

import com.baidu.hugegraph.driver.SchemaManager;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.baidu.hugegraph.structure.constant.IdStrategy;
import com.baidu.hugegraph.structure.schema.SchemaBuilder;
import com.baidu.hugegraph.structure.schema.SchemaLabel;
import com.baidu.hugegraph.util.CollectionUtil;
import com.baidu.hugegraph.util.E;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class VertexLabel
extends SchemaLabel {
    @JsonProperty(value="id_strategy")
    private IdStrategy idStrategy = IdStrategy.DEFAULT;
    @JsonProperty(value="primary_keys")
    private List<String> primaryKeys = new CopyOnWriteArrayList<String>();
    @JsonProperty(value="ttl")
    private long ttl = 0L;
    @JsonProperty(value="ttl_start_time")
    private String ttlStartTime = null;

    @JsonCreator
    public VertexLabel(@JsonProperty(value="name") String name) {
        super(name);
    }

    @Override
    public String type() {
        return HugeType.VERTEX_LABEL.string();
    }

    public IdStrategy idStrategy() {
        return this.idStrategy;
    }

    public List<String> primaryKeys() {
        return this.primaryKeys;
    }

    public long ttl() {
        return this.ttl;
    }

    public String ttlStartTime() {
        return this.ttlStartTime;
    }

    @Override
    public String toString() {
        return String.format("{name=%s, idStrategy=%s, primaryKeys=%s, indexLabels=%s, nullableKeys=%s, properties=%s, ttl=%s, ttlStartTime=%s, status=%s}", new Object[]{this.name, this.idStrategy, this.primaryKeys, this.indexLabels, this.nullableKeys, this.properties, this.ttl, this.ttlStartTime, this.status});
    }

    public VertexLabelV53 switchV53() {
        return new VertexLabelV53(this);
    }

    public static class VertexLabelV53
    extends SchemaLabel {
        @JsonProperty(value="id_strategy")
        private IdStrategy idStrategy;
        @JsonProperty(value="primary_keys")
        private List<String> primaryKeys;

        @JsonCreator
        public VertexLabelV53(@JsonProperty(value="name") String name) {
            super(name);
            this.idStrategy = IdStrategy.DEFAULT;
            this.primaryKeys = new CopyOnWriteArrayList<String>();
        }

        private VertexLabelV53(VertexLabel vertexLabel) {
            super(vertexLabel.name);
            this.idStrategy = vertexLabel.idStrategy;
            this.primaryKeys = vertexLabel.primaryKeys;
            this.id = vertexLabel.id();
            this.properties = vertexLabel.properties();
            this.userdata = vertexLabel.userdata();
            this.checkExist = vertexLabel.checkExist();
            this.nullableKeys = vertexLabel.nullableKeys;
            this.enableLabelIndex = vertexLabel.enableLabelIndex;
        }

        public IdStrategy idStrategy() {
            return this.idStrategy;
        }

        public List<String> primaryKeys() {
            return this.primaryKeys;
        }

        @Override
        public String toString() {
            return String.format("{name=%s, idStrategy=%s, primaryKeys=%s, nullableKeys=%s, properties=%s}", new Object[]{this.name, this.idStrategy, this.primaryKeys, this.nullableKeys, this.properties});
        }

        @Override
        public String type() {
            return HugeType.VERTEX_LABEL.string();
        }
    }

    public static class BuilderImpl
    implements Builder {
        private VertexLabel vertexLabel;
        private SchemaManager manager;

        public BuilderImpl(String name, SchemaManager manager) {
            this.vertexLabel = new VertexLabel(name);
            this.manager = manager;
        }

        @Override
        public VertexLabel build() {
            return this.vertexLabel;
        }

        @Override
        public VertexLabel create() {
            return this.manager.addVertexLabel(this.vertexLabel);
        }

        @Override
        public VertexLabel append() {
            return this.manager.appendVertexLabel(this.vertexLabel);
        }

        @Override
        public VertexLabel eliminate() {
            return this.manager.eliminateVertexLabel(this.vertexLabel);
        }

        @Override
        public void remove() {
            this.manager.removeVertexLabel(this.vertexLabel.name);
        }

        @Override
        public Builder idStrategy(IdStrategy idStrategy) {
            this.checkIdStrategy();
            this.vertexLabel.idStrategy = idStrategy;
            return this;
        }

        @Override
        public Builder useAutomaticId() {
            this.checkIdStrategy();
            this.vertexLabel.idStrategy = IdStrategy.AUTOMATIC;
            return this;
        }

        @Override
        public Builder usePrimaryKeyId() {
            this.checkIdStrategy();
            this.vertexLabel.idStrategy = IdStrategy.PRIMARY_KEY;
            return this;
        }

        @Override
        public Builder useCustomizeStringId() {
            this.checkIdStrategy();
            this.vertexLabel.idStrategy = IdStrategy.CUSTOMIZE_STRING;
            return this;
        }

        @Override
        public Builder useCustomizeNumberId() {
            this.checkIdStrategy();
            this.vertexLabel.idStrategy = IdStrategy.CUSTOMIZE_NUMBER;
            return this;
        }

        @Override
        public Builder useCustomizeUuidId() {
            this.checkIdStrategy();
            this.vertexLabel.idStrategy = IdStrategy.CUSTOMIZE_UUID;
            return this;
        }

        @Override
        public Builder properties(String ... properties) {
            this.vertexLabel.properties.addAll(Arrays.asList(properties));
            return this;
        }

        @Override
        public Builder primaryKeys(String ... keys) {
            E.checkArgument((boolean)this.vertexLabel.primaryKeys.isEmpty(), (String)"Not allowed to assign primary keys multi times", (Object[])new Object[0]);
            List<String> primaryKeys = Arrays.asList(keys);
            E.checkArgument((boolean)CollectionUtil.allUnique(primaryKeys), (String)"Invalid primary keys %s, which contains some duplicate properties", (Object[])new Object[]{primaryKeys});
            this.vertexLabel.primaryKeys.addAll(primaryKeys);
            return this;
        }

        @Override
        public Builder nullableKeys(String ... keys) {
            this.vertexLabel.nullableKeys.addAll(Arrays.asList(keys));
            return this;
        }

        @Override
        public Builder ttl(long ttl) {
            E.checkArgument((ttl >= 0L ? 1 : 0) != 0, (String)"The ttl must >= 0, but got: %s", (Object[])new Object[]{ttl});
            this.vertexLabel.ttl = ttl;
            return this;
        }

        @Override
        public Builder ttlStartTime(String ttlStartTime) {
            this.vertexLabel.ttlStartTime = ttlStartTime;
            return this;
        }

        @Override
        public Builder enableLabelIndex(boolean enable) {
            this.vertexLabel.enableLabelIndex = enable;
            return this;
        }

        @Override
        public Builder userdata(String key, Object val) {
            E.checkArgumentNotNull((Object)key, (String)"The user data key can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)val, (String)"The user data value can't be null", (Object[])new Object[0]);
            this.vertexLabel.userdata.put(key, val);
            return this;
        }

        @Override
        public Builder ifNotExist() {
            this.vertexLabel.checkExist = false;
            return this;
        }

        private void checkIdStrategy() {
            E.checkArgument((this.vertexLabel.idStrategy == IdStrategy.DEFAULT ? 1 : 0) != 0, (String)"Not allowed to change id strategy for vertex label '%s'", (Object[])new Object[]{this.vertexLabel.name});
        }
    }

    public static interface Builder
    extends SchemaBuilder<VertexLabel> {
        public Builder idStrategy(IdStrategy var1);

        public Builder useAutomaticId();

        public Builder usePrimaryKeyId();

        public Builder useCustomizeStringId();

        public Builder useCustomizeNumberId();

        public Builder useCustomizeUuidId();

        public Builder properties(String ... var1);

        public Builder primaryKeys(String ... var1);

        public Builder nullableKeys(String ... var1);

        public Builder ttl(long var1);

        public Builder ttlStartTime(String var1);

        public Builder enableLabelIndex(boolean var1);

        public Builder userdata(String var1, Object var2);

        public Builder ifNotExist();
    }
}

