/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.schema;

import com.baidu.hugegraph.exception.InvalidOperationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class BuilderProxy<T>
implements InvocationHandler {
    private boolean finished = false;
    private T builder;
    private T proxy;

    public BuilderProxy(T builder) {
        this.builder = builder;
        this.proxy = Proxy.newProxyInstance(builder.getClass().getClassLoader(), builder.getClass().getInterfaces(), (InvocationHandler)this);
    }

    public T proxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.finished) {
            throw new InvalidOperationException("Can't access builder which is completed", new Object[0]);
        }
        Object result = method.invoke(this.builder, args);
        if (result == this.builder) {
            result = this.proxy;
        } else {
            this.finished = true;
        }
        return result;
    }
}

