/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.gremlin;

import com.baidu.hugegraph.driver.GraphManager;
import com.baidu.hugegraph.rest.SerializeException;
import com.baidu.hugegraph.serializer.PathDeserializer;
import com.baidu.hugegraph.structure.constant.GraphAttachable;
import com.baidu.hugegraph.structure.graph.Edge;
import com.baidu.hugegraph.structure.graph.Path;
import com.baidu.hugegraph.structure.graph.Vertex;
import com.baidu.hugegraph.structure.gremlin.Result;
import com.baidu.hugegraph.util.E;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ResultSet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private GraphManager graphManager = null;
    @JsonProperty
    private List<Object> data;
    @JsonProperty
    private Map<String, ?> meta;

    public void graphManager(GraphManager graphManager) {
        this.graphManager = graphManager;
    }

    public List<Object> data() {
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    public Result get(int index) {
        if (index >= this.data.size()) {
            return null;
        }
        Object object = this.data().get(index);
        if (object == null) {
            return null;
        }
        Class<?> clazz = this.parseResultClass(object);
        if (clazz.equals(object.getClass())) {
            return new Result(object);
        }
        try {
            String rawValue = MAPPER.writeValueAsString(object);
            object = MAPPER.readValue(rawValue, clazz);
            if (object instanceof GraphAttachable) {
                ((GraphAttachable)object).attachManager(this.graphManager);
            }
            return new Result(object);
        }
        catch (Exception e) {
            throw new SerializeException("Failed to deserialize: %s", (Throwable)e, new Object[]{object});
        }
    }

    private Class<?> parseResultClass(Object object) {
        if (object.getClass().equals(LinkedHashMap.class)) {
            Map map = (Map)object;
            String type = (String)map.get("type");
            if (type != null) {
                if ("vertex".equals(type)) {
                    return Vertex.class;
                }
                if ("edge".equals(type)) {
                    return Edge.class;
                }
            } else if (map.get("labels") != null) {
                return Path.class;
            }
        }
        return object.getClass();
    }

    public Iterator<Result> iterator() {
        E.checkState((this.data != null ? 1 : 0) != 0, (String)"Invalid response from server", (Object[])new Object[0]);
        E.checkState((this.graphManager != null ? 1 : 0) != 0, (String)"Must hold a graph manager", (Object[])new Object[0]);
        return new Iterator<Result>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ResultSet.this.data.size();
            }

            @Override
            public Result next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ResultSet.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Path.class, (JsonDeserializer)new PathDeserializer());
        MAPPER.registerModule((Module)module);
    }
}

