/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.structure.graph;

import com.baidu.hugegraph.structure.graph.UpdateStrategy;
import com.baidu.hugegraph.structure.graph.Vertex;
import com.baidu.hugegraph.util.E;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchVertexRequest {
    @JsonProperty(value="vertices")
    private List<Vertex> vertices = null;
    @JsonProperty(value="update_strategies")
    private Map<String, UpdateStrategy> updateStrategies = null;
    @JsonProperty(value="create_if_not_exist")
    private boolean createIfNotExist = true;

    public static Builder createBuilder() {
        return new Builder();
    }

    public String toString() {
        return String.format("BatchVertexRequest{vertices=%s,updateStrategies=%s,createIfNotExist=%s}", this.vertices, this.updateStrategies, this.createIfNotExist);
    }

    public static class Builder {
        private BatchVertexRequest req = new BatchVertexRequest();

        public Builder vertices(List<Vertex> vertices) {
            this.req.vertices = vertices;
            return this;
        }

        public Builder updatingStrategies(Map<String, UpdateStrategy> map) {
            this.req.updateStrategies = new HashMap<String, UpdateStrategy>(map);
            return this;
        }

        public Builder updatingStrategy(String property, UpdateStrategy strategy) {
            this.req.updateStrategies.put(property, strategy);
            return this;
        }

        public Builder createIfNotExist(boolean createIfNotExist) {
            this.req.createIfNotExist = createIfNotExist;
            return this;
        }

        public BatchVertexRequest build() {
            E.checkArgumentNotNull((Object)this.req, (String)"BatchVertexRequest can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.req.vertices, (String)"Parameter 'vertices' can't be null", (Object[])new Object[0]);
            E.checkArgument((this.req.updateStrategies != null && !this.req.updateStrategies.isEmpty() ? 1 : 0) != 0, (String)"Parameter 'update_strategies' can't be empty", (Object[])new Object[0]);
            E.checkArgument((this.req.createIfNotExist ? 1 : 0) != 0, (String)"Parameter 'create_if_not_exist' dose not support false now", (Object[])new Object[0]);
            return this.req;
        }
    }
}

