/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.serializer;

import com.baidu.hugegraph.exception.InvalidResponseException;
import com.baidu.hugegraph.structure.graph.Edge;
import com.baidu.hugegraph.structure.graph.Path;
import com.baidu.hugegraph.structure.graph.Vertex;
import com.baidu.hugegraph.util.JsonUtil;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class PathDeserializer
extends JsonDeserializer<Path> {
    public Path deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonNode objectsNode;
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        Path path = new Path();
        JsonNode labelsNode = node.get("labels");
        if (labelsNode != null) {
            if (labelsNode.getNodeType() != JsonNodeType.ARRAY) {
                throw InvalidResponseException.expectField("labels", node);
            }
            Object labels = JsonUtil.convertValue(labelsNode, Object.class);
            ((List)labels).forEach(xva$0 -> path.labels(xva$0));
        }
        if ((objectsNode = node.get("objects")) == null || objectsNode.getNodeType() != JsonNodeType.ARRAY) {
            throw InvalidResponseException.expectField("objects", node);
        }
        Iterator objects = objectsNode.elements();
        while (objects.hasNext()) {
            JsonNode objectNode = (JsonNode)objects.next();
            JsonNode typeNode = objectNode.get("type");
            Object object = typeNode != null ? this.parseTypedNode(objectNode, typeNode) : JsonUtil.convertValue(objectNode, Object.class);
            path.objects(object);
        }
        JsonNode crosspointNode = node.get("crosspoint");
        if (crosspointNode != null) {
            Object object = JsonUtil.convertValue(crosspointNode, Object.class);
            path.crosspoint(object);
        }
        return path;
    }

    private Object parseTypedNode(JsonNode objectNode, JsonNode typeNode) {
        String type = typeNode.asText();
        if ("vertex".equals(type)) {
            return JsonUtil.convertValue(objectNode, Vertex.class);
        }
        if ("edge".equals(type)) {
            return JsonUtil.convertValue(objectNode, Edge.class);
        }
        throw InvalidResponseException.expectField("vertex/edge", type);
    }
}

