/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.driver;

import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.driver.AuthManager;
import com.baidu.hugegraph.driver.GraphManager;
import com.baidu.hugegraph.driver.GraphsManager;
import com.baidu.hugegraph.driver.GremlinManager;
import com.baidu.hugegraph.driver.HugeClientBuilder;
import com.baidu.hugegraph.driver.JobManager;
import com.baidu.hugegraph.driver.MetricsManager;
import com.baidu.hugegraph.driver.SchemaManager;
import com.baidu.hugegraph.driver.TaskManager;
import com.baidu.hugegraph.driver.TraverserManager;
import com.baidu.hugegraph.driver.VariablesManager;
import com.baidu.hugegraph.driver.VersionManager;
import com.baidu.hugegraph.rest.ClientException;
import com.baidu.hugegraph.util.VersionUtil;
import com.baidu.hugegraph.version.ClientVersion;
import java.io.Closeable;
import javax.ws.rs.ProcessingException;

public class HugeClient
implements Closeable {
    private final RestClient client;
    private VersionManager version;
    private GraphsManager graphs;
    private SchemaManager schema;
    private GraphManager graph;
    private GremlinManager gremlin;
    private TraverserManager traverser;
    private VariablesManager variable;
    private JobManager job;
    private TaskManager task;
    private AuthManager auth;
    private MetricsManager metrics;

    public HugeClient(HugeClientBuilder builder) {
        try {
            this.client = new RestClient(builder.url(), builder.username(), builder.password(), builder.timeout(), builder.maxConns(), builder.maxConnsPerRoute(), builder.trustStoreFile(), builder.trustStorePassword());
        }
        catch (ProcessingException e) {
            throw new ClientException("Failed to connect url '%s'", new Object[]{builder.url()});
        }
        try {
            this.initManagers(this.client, builder.graph());
        }
        catch (Throwable e) {
            this.client.close();
            throw e;
        }
    }

    public static HugeClientBuilder builder(String url, String graph) {
        return new HugeClientBuilder(url, graph);
    }

    @Override
    public void close() {
        this.client.close();
    }

    private void initManagers(RestClient client, String graph) {
        assert (client != null);
        this.version = new VersionManager(client);
        this.checkServerApiVersion();
        this.graphs = new GraphsManager(client);
        this.schema = new SchemaManager(client, graph);
        this.graph = new GraphManager(client, graph);
        this.gremlin = new GremlinManager(client, graph, this.graph);
        this.traverser = new TraverserManager(client, this.graph);
        this.variable = new VariablesManager(client, graph);
        this.job = new JobManager(client, graph);
        this.task = new TaskManager(client, graph);
        this.auth = new AuthManager(client, graph);
        this.metrics = new MetricsManager(client);
    }

    private void checkServerApiVersion() {
        VersionUtil.Version apiVersion = VersionUtil.Version.of((String)this.version.getApiVersion());
        VersionUtil.check((VersionUtil.Version)apiVersion, (String)"0.38", (String)"0.59", (String)"hugegraph-api in server");
        this.client.apiVersion(apiVersion);
    }

    public GraphsManager graphs() {
        return this.graphs;
    }

    public SchemaManager schema() {
        return this.schema;
    }

    public GraphManager graph() {
        return this.graph;
    }

    public GremlinManager gremlin() {
        return this.gremlin;
    }

    public TraverserManager traverser() {
        return this.traverser;
    }

    public VariablesManager variables() {
        return this.variable;
    }

    public JobManager job() {
        return this.job;
    }

    public TaskManager task() {
        return this.task;
    }

    public AuthManager auth() {
        return this.auth;
    }

    public MetricsManager metrics() {
        return this.metrics;
    }

    static {
        ClientVersion.check();
    }
}

