/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.client;

import com.baidu.hugegraph.exception.ServerException;
import com.baidu.hugegraph.rest.AbstractRestClient;
import com.baidu.hugegraph.rest.ClientException;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.serializer.PathDeserializer;
import com.baidu.hugegraph.structure.graph.Path;
import com.baidu.hugegraph.util.E;
import com.baidu.hugegraph.util.VersionUtil;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import javax.ws.rs.core.Response;

public class RestClient
extends AbstractRestClient {
    private static final int SECOND = 1000;
    private VersionUtil.Version apiVersion = null;

    public RestClient(String url, String username, String password, int timeout) {
        super(url, username, password, timeout * 1000);
    }

    public RestClient(String url, String username, String password, int timeout, int maxConns, int maxConnsPerRoute, String trustStoreFile, String trustStorePassword) {
        super(url, username, password, timeout * 1000, maxConns, maxConnsPerRoute, trustStoreFile, trustStorePassword);
    }

    public void apiVersion(VersionUtil.Version version) {
        E.checkNotNull((Object)version, (String)"api version");
        this.apiVersion = version;
    }

    public VersionUtil.Version apiVersion() {
        return this.apiVersion;
    }

    public void checkApiVersion(String minVersion, String message) {
        if (this.apiVersionLt(minVersion)) {
            throw new ClientException("HugeGraphServer API version must be >= %s to support %s, but current HugeGraphServer API version is: %s", new Object[]{minVersion, message, this.apiVersion.get()});
        }
    }

    public boolean apiVersionLt(String minVersion) {
        String apiVersion = this.apiVersion == null ? null : this.apiVersion.get();
        return apiVersion != null && !VersionUtil.gte((String)apiVersion, (String)minVersion);
    }

    protected void checkStatus(Response response, Response.Status ... statuses) {
        boolean match = false;
        for (Response.Status status : statuses) {
            if (status.getStatusCode() != response.getStatus()) continue;
            match = true;
            break;
        }
        if (!match) {
            throw ServerException.fromResponse(response);
        }
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Path.class, (JsonDeserializer)new PathDeserializer());
        RestResult.registerModule((Module)module);
    }
}

