/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.traverser.WeightedPath;
import com.baidu.hugegraph.util.E;
import java.util.LinkedHashMap;

public class WeightedShortestPathAPI
extends TraversersAPI {
    public WeightedShortestPathAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "weightedshortestpath";
    }

    public WeightedPath get(Object sourceId, Object targetId, Direction direction, String label, String weight, long degree, long skipDegree, long capacity, boolean withVertex) {
        this.client.checkApiVersion("0.51", "weighted shortest path");
        String source = GraphAPI.formatVertexId(sourceId, false);
        String target = GraphAPI.formatVertexId(targetId, false);
        E.checkNotNull((Object)weight, (String)"weight");
        WeightedShortestPathAPI.checkDegree(degree);
        WeightedShortestPathAPI.checkCapacity(capacity);
        WeightedShortestPathAPI.checkSkipDegree(skipDegree, degree, capacity);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("target", target);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("weight", weight);
        params.put("max_degree", degree);
        params.put("skip_degree", skipDegree);
        params.put("capacity", capacity);
        params.put("with_vertex", withVertex);
        RestResult result = this.client.get(this.path(), params);
        return (WeightedPath)result.readObject(WeightedPath.class);
    }
}

