/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.traverser.WeightedPaths;
import com.baidu.hugegraph.util.E;
import java.util.LinkedHashMap;

public class SingleSourceShortestPathAPI
extends TraversersAPI {
    public SingleSourceShortestPathAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "singlesourceshortestpath";
    }

    public WeightedPaths get(Object sourceId, Direction direction, String label, String weight, long degree, long skipDegree, long capacity, long limit, boolean withVertex) {
        this.client.checkApiVersion("0.51", "single source shortest path");
        String source = GraphAPI.formatVertexId(sourceId, false);
        E.checkNotNull((Object)weight, (String)"weight");
        SingleSourceShortestPathAPI.checkDegree(degree);
        SingleSourceShortestPathAPI.checkCapacity(capacity);
        SingleSourceShortestPathAPI.checkSkipDegree(skipDegree, degree, capacity);
        SingleSourceShortestPathAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("weight", weight);
        params.put("max_degree", degree);
        params.put("skip_degree", skipDegree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        params.put("with_vertex", withVertex);
        RestResult result = this.client.get(this.path(), params);
        return (WeightedPaths)result.readObject(WeightedPaths.class);
    }
}

