/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.graph.Path;
import java.util.LinkedHashMap;
import java.util.List;

public class RingsAPI
extends TraversersAPI {
    public RingsAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "rings";
    }

    public List<Path> get(Object sourceId, Direction direction, String label, int depth, boolean sourceInRing, long degree, long capacity, long limit) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        RingsAPI.checkPositive(depth, "Max depth of path");
        RingsAPI.checkDegree(degree);
        RingsAPI.checkCapacity(capacity);
        RingsAPI.checkLimit(limit);
        if (sourceInRing) {
            this.client.checkApiVersion("0.40", "source_in_ring arg of ring API");
        }
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", depth);
        params.put("source_in_ring", sourceInRing);
        params.put("max_degree", degree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList(this.type(), Path.class);
    }
}

