/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.graph.Path;
import java.util.LinkedHashMap;
import java.util.List;

public class RaysAPI
extends TraversersAPI {
    public RaysAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "rays";
    }

    public List<Path> get(Object sourceId, Direction direction, String label, int depth, long degree, long capacity, long limit) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        RaysAPI.checkPositive(depth, "Max depth of path");
        RaysAPI.checkDegree(degree);
        RaysAPI.checkCapacity(capacity);
        RaysAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", depth);
        params.put("max_degree", degree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList(this.type(), Path.class);
    }
}

