/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.traverser.Ranks;
import com.baidu.hugegraph.util.E;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NeighborRankAPI
extends TraversersAPI {
    public NeighborRankAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "neighborrank";
    }

    public List<Ranks> post(Request request) {
        RestResult result = this.client.post(this.path(), request);
        return result.readList("ranks", Ranks.class);
    }

    public static class Request {
        @JsonProperty(value="source")
        private Object source = null;
        @JsonProperty(value="steps")
        private List<Step> steps = new ArrayList<Step>();
        @JsonProperty(value="alpha")
        private double alpha = 0.9;
        @JsonProperty(value="capacity")
        private long capacity = 10000000L;

        private Request() {
        }

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            return String.format("Request{source=%s,steps=%s,alpha=%s,capacity=%s}", this.source, this.steps, this.alpha, this.capacity);
        }

        public static class Step {
            @JsonProperty(value="direction")
            private String direction = null;
            @JsonProperty(value="labels")
            private List<String> labels = new ArrayList<String>();
            @JsonProperty(value="degree")
            private long degree = 10000L;
            @JsonProperty(value="top")
            private int top = 10;

            private Step() {
            }

            public String toString() {
                return String.format("Step{direction=%s,labels=%s,degree=%s,top=%s}", this.direction, this.labels, this.degree, this.top);
            }

            public static class Builder {
                private Step step = new Step();

                private Builder() {
                }

                public Builder direction(Direction direction) {
                    this.step.direction = direction.toString();
                    return this;
                }

                public Builder labels(List<String> labels) {
                    this.step.labels.addAll(labels);
                    return this;
                }

                public Builder labels(String ... labels) {
                    this.step.labels.addAll(Arrays.asList(labels));
                    return this;
                }

                public Builder degree(long degree) {
                    TraversersAPI.checkDegree(degree);
                    this.step.degree = degree;
                    return this;
                }

                public Builder top(int top) {
                    E.checkArgument((top > 0 && top <= 1000 ? 1 : 0) != 0, (String)"The top of each layer can't exceed %s", (Object[])new Object[]{1000});
                    this.step.top = top;
                    return this;
                }

                private Step build() {
                    TraversersAPI.checkDegree(this.step.degree);
                    E.checkArgument((this.step.top > 0 && this.step.top <= 1000 ? 1 : 0) != 0, (String)"The top of each layer can't exceed %s", (Object[])new Object[]{1000});
                    return this.step;
                }
            }
        }

        public static class Builder {
            private Request request = new Request();
            private List<Step.Builder> stepBuilders = new ArrayList<Step.Builder>();

            private Builder() {
            }

            public Builder source(Object source) {
                E.checkArgument((source != null ? 1 : 0) != 0, (String)"The label of request for neighbor rank can't be null", (Object[])new Object[0]);
                this.request.source = source;
                return this;
            }

            public Step.Builder steps() {
                Step.Builder builder = new Step.Builder();
                this.stepBuilders.add(builder);
                return builder;
            }

            public Builder alpha(double alpha) {
                TraversersAPI.checkAlpha(alpha);
                this.request.alpha = alpha;
                return this;
            }

            public Builder capacity(long capacity) {
                TraversersAPI.checkCapacity(capacity);
                this.request.capacity = capacity;
                return this;
            }

            public Request build() {
                for (Step.Builder builder : this.stepBuilders) {
                    this.request.steps.add(builder.build());
                }
                E.checkArgument((this.request.source != null ? 1 : 0) != 0, (String)"Source vertex can't be null", (Object[])new Object[0]);
                E.checkArgument((this.request.steps != null && !this.request.steps.isEmpty() ? 1 : 0) != 0, (String)"Steps can't be null or empty", (Object[])new Object[0]);
                TraversersAPI.checkCapacity(this.request.capacity);
                TraversersAPI.checkAlpha(this.request.alpha);
                return this.request;
            }
        }
    }
}

