/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.traverser.Kout;
import com.baidu.hugegraph.structure.traverser.KoutRequest;
import java.util.LinkedHashMap;
import java.util.List;

public class KoutAPI
extends TraversersAPI {
    public KoutAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "kout";
    }

    public List<Object> get(Object sourceId, Direction direction, String label, int depth, boolean nearest, long degree, long limit, long capacity) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        KoutAPI.checkPositive(depth, "Depth of k-out");
        KoutAPI.checkDegree(degree);
        KoutAPI.checkCapacity(capacity);
        KoutAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", depth);
        params.put("nearest", nearest);
        params.put("max_degree", degree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList("vertices", Object.class);
    }

    public Kout post(KoutRequest request) {
        this.client.checkApiVersion("0.58", "customized kout");
        RestResult result = this.client.post(this.path(), request);
        return (Kout)result.readObject(Kout.class);
    }
}

