/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.traverser.SingleSourceJaccardSimilarityRequest;
import com.baidu.hugegraph.util.E;
import java.util.LinkedHashMap;
import java.util.Map;

public class JaccardSimilarityAPI
extends TraversersAPI {
    private static final String JACCARD_SIMILARITY = "jaccard_similarity";

    public JaccardSimilarityAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "jaccardsimilarity";
    }

    public double get(Object vertexId, Object otherId, Direction direction, String label, long degree) {
        this.client.checkApiVersion("0.51", "jaccard similarity");
        String vertex = GraphAPI.formatVertexId(vertexId, false);
        String other = GraphAPI.formatVertexId(otherId, false);
        JaccardSimilarityAPI.checkDegree(degree);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vertex", vertex);
        params.put("other", other);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_degree", degree);
        RestResult result = this.client.get(this.path(), params);
        Map jaccard = (Map)result.readObject(Map.class);
        E.checkState((boolean)jaccard.containsKey(JACCARD_SIMILARITY), (String)"The result doesn't have key '%s'", (Object[])new Object[]{JACCARD_SIMILARITY});
        return (Double)jaccard.get(JACCARD_SIMILARITY);
    }

    public Map<Object, Double> post(SingleSourceJaccardSimilarityRequest request) {
        this.client.checkApiVersion("0.58", "jaccard similar");
        RestResult result = this.client.post(this.path(), request);
        return (Map)result.readObject(Map.class);
    }
}

