/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.traverser;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.api.traverser.TraversersAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.Direction;
import com.baidu.hugegraph.structure.graph.Path;
import java.util.LinkedHashMap;
import java.util.List;

public class CrosspointsAPI
extends TraversersAPI {
    public CrosspointsAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "crosspoints";
    }

    public List<Path> get(Object sourceId, Object targetId, Direction direction, String label, int maxDepth, long degree, long capacity, long limit) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        String target = GraphAPI.formatVertexId(targetId, false);
        CrosspointsAPI.checkPositive(maxDepth, "Max depth of path");
        CrosspointsAPI.checkDegree(degree);
        CrosspointsAPI.checkCapacity(capacity);
        CrosspointsAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("target", target);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", maxDepth);
        params.put("max_degree", degree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList("crosspoints", Path.class);
    }
}

