/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.schema;

import com.baidu.hugegraph.api.schema.SchemaAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.SchemaElement;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.baidu.hugegraph.structure.schema.PropertyKey;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class PropertyKeyAPI
extends SchemaAPI {
    public PropertyKeyAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.PROPERTY_KEY.string();
    }

    public PropertyKey create(PropertyKey propertyKey) {
        Object pkey = this.checkCreateOrUpdate(propertyKey);
        RestResult result = this.client.post(this.path(), pkey);
        return (PropertyKey)result.readObject(PropertyKey.class);
    }

    public PropertyKey append(PropertyKey propertyKey) {
        String id = propertyKey.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"append");
        Object pkey = this.checkCreateOrUpdate(propertyKey);
        RestResult result = this.client.put(this.path(), id, pkey, (Map)params);
        return (PropertyKey)result.readObject(PropertyKey.class);
    }

    public PropertyKey eliminate(PropertyKey propertyKey) {
        String id = propertyKey.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"eliminate");
        Object pkey = this.checkCreateOrUpdate(propertyKey);
        RestResult result = this.client.put(this.path(), id, pkey, (Map)params);
        return (PropertyKey)result.readObject(PropertyKey.class);
    }

    public PropertyKey get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return (PropertyKey)result.readObject(PropertyKey.class);
    }

    public List<PropertyKey> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), PropertyKey.class);
    }

    public List<PropertyKey> list(List<String> names) {
        this.client.checkApiVersion("0.48", "getting schema by names");
        E.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (String)"The property key names can't be null or empty", (Object[])new Object[0]);
        ImmutableMap params = ImmutableMap.of((Object)"names", names);
        RestResult result = this.client.get(this.path(), (Map)params);
        return result.readList(this.type(), PropertyKey.class);
    }

    public void delete(String name) {
        this.client.delete(this.path(), name);
    }

    @Override
    protected Object checkCreateOrUpdate(SchemaElement schemaElement) {
        PropertyKey propertyKey;
        SchemaElement pkey = propertyKey = (PropertyKey)schemaElement;
        if (this.client.apiVersionLt("0.47")) {
            E.checkArgument((boolean)propertyKey.aggregateType().isNone(), (String)"Not support aggregate property until api version 0.47", (Object[])new Object[0]);
            pkey = propertyKey.switchV46();
        }
        return pkey;
    }
}

