/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.schema;

import com.baidu.hugegraph.api.schema.SchemaAPI;
import com.baidu.hugegraph.api.task.TaskAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.exception.NotSupportException;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.SchemaElement;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.baidu.hugegraph.structure.constant.IndexType;
import com.baidu.hugegraph.structure.schema.IndexLabel;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class IndexLabelAPI
extends SchemaAPI {
    public IndexLabelAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.INDEX_LABEL.string();
    }

    public IndexLabel.CreatedIndexLabel create(IndexLabel indexLabel) {
        Object il = this.checkCreateOrUpdate(indexLabel);
        RestResult result = this.client.post(this.path(), il);
        return (IndexLabel.CreatedIndexLabel)result.readObject(IndexLabel.CreatedIndexLabel.class);
    }

    public IndexLabel append(IndexLabel indexLabel) {
        if (this.client.apiVersionLt("0.50")) {
            throw new NotSupportException("action append on index label", new Object[0]);
        }
        String id = indexLabel.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"append");
        Object il = this.checkCreateOrUpdate(indexLabel);
        RestResult result = this.client.put(this.path(), id, il, (Map)params);
        return (IndexLabel)result.readObject(IndexLabel.class);
    }

    public IndexLabel eliminate(IndexLabel indexLabel) {
        if (this.client.apiVersionLt("0.50")) {
            throw new NotSupportException("action eliminate on index label", new Object[0]);
        }
        String id = indexLabel.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"eliminate");
        Object il = this.checkCreateOrUpdate(indexLabel);
        RestResult result = this.client.put(this.path(), id, il, (Map)params);
        return (IndexLabel)result.readObject(IndexLabel.class);
    }

    public IndexLabel get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return (IndexLabel)result.readObject(IndexLabel.class);
    }

    public List<IndexLabel> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), IndexLabel.class);
    }

    public List<IndexLabel> list(List<String> names) {
        this.client.checkApiVersion("0.48", "getting schema by names");
        E.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (String)"The index label names can't be null or empty", (Object[])new Object[0]);
        ImmutableMap params = ImmutableMap.of((Object)"names", names);
        RestResult result = this.client.get(this.path(), (Map)params);
        return result.readList(this.type(), IndexLabel.class);
    }

    public long delete(String name) {
        RestResult result = this.client.delete(this.path(), name);
        Map task = (Map)result.readObject(Map.class);
        return TaskAPI.parseTaskId(task);
    }

    @Override
    protected Object checkCreateOrUpdate(SchemaElement schemaElement) {
        IndexLabel indexLabel = (IndexLabel)schemaElement;
        if (indexLabel.indexType() == IndexType.SHARD) {
            this.client.checkApiVersion("0.43", "shard index");
        } else if (indexLabel.indexType() == IndexType.UNIQUE) {
            this.client.checkApiVersion("0.44", "unique index");
        }
        IndexLabel il = indexLabel;
        if (this.client.apiVersionLt("0.50")) {
            E.checkArgument((indexLabel.userdata() == null || indexLabel.userdata().isEmpty() ? 1 : 0) != 0, (String)"Not support userdata of index label until api version 0.50", (Object[])new Object[0]);
            E.checkArgument((boolean)indexLabel.rebuild(), (String)"Not support rebuild of index label until api version 0.57", (Object[])new Object[0]);
            il = indexLabel.switchV49();
        } else if (this.client.apiVersionLt("0.57")) {
            E.checkArgument((boolean)indexLabel.rebuild(), (String)"Not support rebuild of index label until api version 0.57", (Object[])new Object[0]);
            il = indexLabel.switchV56();
        }
        return il;
    }
}

