/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.schema;

import com.baidu.hugegraph.api.schema.SchemaAPI;
import com.baidu.hugegraph.api.task.TaskAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.SchemaElement;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.baidu.hugegraph.structure.schema.EdgeLabel;
import com.baidu.hugegraph.structure.schema.SchemaLabel;
import com.baidu.hugegraph.util.E;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class EdgeLabelAPI
extends SchemaAPI {
    public EdgeLabelAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.EDGE_LABEL.string();
    }

    public EdgeLabel create(EdgeLabel edgeLabel) {
        Object el = this.checkCreateOrUpdate(edgeLabel);
        RestResult result = this.client.post(this.path(), el);
        return (EdgeLabel)result.readObject(EdgeLabel.class);
    }

    public EdgeLabel append(EdgeLabel edgeLabel) {
        String id = edgeLabel.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"append");
        Object el = this.checkCreateOrUpdate(edgeLabel);
        RestResult result = this.client.put(this.path(), id, el, (Map)params);
        return (EdgeLabel)result.readObject(EdgeLabel.class);
    }

    public EdgeLabel eliminate(EdgeLabel edgeLabel) {
        String id = edgeLabel.name();
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"eliminate");
        Object el = this.checkCreateOrUpdate(edgeLabel);
        RestResult result = this.client.put(this.path(), id, el, (Map)params);
        return (EdgeLabel)result.readObject(EdgeLabel.class);
    }

    public EdgeLabel get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return (EdgeLabel)result.readObject(EdgeLabel.class);
    }

    public List<EdgeLabel> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), EdgeLabel.class);
    }

    public List<EdgeLabel> list(List<String> names) {
        this.client.checkApiVersion("0.48", "getting schema by names");
        E.checkArgument((names != null && !names.isEmpty() ? 1 : 0) != 0, (String)"The edge label names can't be null or empty", (Object[])new Object[0]);
        ImmutableMap params = ImmutableMap.of((Object)"names", names);
        RestResult result = this.client.get(this.path(), (Map)params);
        return result.readList(this.type(), EdgeLabel.class);
    }

    public long delete(String name) {
        RestResult result = this.client.delete(this.path(), name);
        Map task = (Map)result.readObject(Map.class);
        return TaskAPI.parseTaskId(task);
    }

    @Override
    protected Object checkCreateOrUpdate(SchemaElement schemaElement) {
        EdgeLabel edgeLabel;
        SchemaLabel el = edgeLabel = (EdgeLabel)schemaElement;
        if (this.client.apiVersionLt("0.54")) {
            E.checkArgument((edgeLabel.ttl() == 0L && edgeLabel.ttlStartTime() == null ? 1 : 0) != 0, (String)"Not support ttl until api version 0.54", (Object[])new Object[0]);
            el = edgeLabel.switchV53();
        }
        return el;
    }
}

