/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.graphs;

import com.baidu.hugegraph.api.API;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.exception.InvalidResponseException;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.GraphMode;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class GraphsAPI
extends API {
    public GraphsAPI(RestClient client) {
        super(client);
        this.path(this.type());
    }

    @Override
    protected String type() {
        return HugeType.GRAPHS.string();
    }

    public Map<String, String> get(String name) {
        RestResult result = this.client.get(this.path(), name);
        return (Map)result.readObject(Map.class);
    }

    public List<String> list() {
        RestResult result = this.client.get(this.path());
        return result.readList(this.type(), String.class);
    }

    public void mode(String graph, GraphMode mode) {
        String path = String.join((CharSequence)"/", this.path(), graph);
        this.client.put(path, "mode", (Object)mode);
    }

    public GraphMode mode(String graph) {
        String path = String.join((CharSequence)"/", this.path(), graph);
        RestResult result = this.client.get(path, "mode");
        Map mode = (Map)result.readObject(Map.class);
        String value = (String)mode.get("mode");
        if (value == null) {
            throw new InvalidResponseException("mode", "mode response");
        }
        try {
            return GraphMode.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidResponseException("Invalid GraphMode value '%s'", value);
        }
    }

    public void clear(String graph, String message) {
        String path = String.join((CharSequence)"/", this.path(), graph, "clear");
        this.client.delete(path, (Map)ImmutableMap.of((Object)"confirm_message", (Object)message));
    }
}

