/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.graph;

import com.baidu.hugegraph.api.graph.GraphAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.exception.NotAllCreatedException;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.baidu.hugegraph.structure.graph.BatchVertexRequest;
import com.baidu.hugegraph.structure.graph.Vertex;
import com.baidu.hugegraph.structure.graph.Vertices;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class VertexAPI
extends GraphAPI {
    public VertexAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.VERTEX.string();
    }

    public Vertex create(Vertex vertex) {
        RestResult result = this.client.post(this.path(), vertex);
        return (Vertex)result.readObject(Vertex.class);
    }

    public List<Object> create(List<Vertex> vertices) {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.putSingle((Object)"Content-Encoding", (Object)"gzip");
        RestResult result = this.client.post(this.batchPath(), vertices, (MultivaluedMap)headers);
        List ids = result.readList(Object.class);
        if (vertices.size() != ids.size()) {
            throw new NotAllCreatedException("Not all vertices are successfully created, expect '%s', the actual is '%s'", ids, vertices.size(), ids.size());
        }
        return ids;
    }

    public List<Vertex> update(BatchVertexRequest request) {
        this.client.checkApiVersion("0.45", "batch property update");
        MultivaluedHashMap headers = new MultivaluedHashMap();
        headers.putSingle((Object)"Content-Encoding", (Object)"gzip");
        RestResult result = this.client.put(this.batchPath(), null, request, (MultivaluedMap)headers);
        return result.readList(this.type(), Vertex.class);
    }

    public Vertex append(Vertex vertex) {
        String id = GraphAPI.formatVertexId(vertex.id());
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"append");
        RestResult result = this.client.put(this.path(), id, vertex, (Map)params);
        return (Vertex)result.readObject(Vertex.class);
    }

    public Vertex eliminate(Vertex vertex) {
        String id = GraphAPI.formatVertexId(vertex.id());
        ImmutableMap params = ImmutableMap.of((Object)"action", (Object)"eliminate");
        RestResult result = this.client.put(this.path(), id, vertex, (Map)params);
        return (Vertex)result.readObject(Vertex.class);
    }

    public Vertex get(Object id) {
        String vertexId = GraphAPI.formatVertexId(id);
        RestResult result = this.client.get(this.path(), vertexId);
        return (Vertex)result.readObject(Vertex.class);
    }

    public Vertices list(int limit) {
        return this.list(null, null, 0, null, limit);
    }

    public Vertices list(String label, Map<String, Object> properties, int offset, String page, int limit) {
        return this.list(label, properties, false, offset, page, limit);
    }

    public Vertices list(String label, Map<String, Object> properties, boolean keepP, int offset, String page, int limit) {
        VertexAPI.checkOffset(offset);
        VertexAPI.checkLimit(limit, "Limit");
        String props = GraphAPI.formatProperties(properties);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("label", label);
        params.put("properties", props);
        params.put("keep_start_p", keepP);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("page", page);
        RestResult result = this.client.get(this.path(), params);
        return (Vertices)result.readObject(Vertices.class);
    }

    public void delete(Object id) {
        String vertexId = GraphAPI.formatVertexId(id);
        this.client.delete(this.path(), vertexId);
    }
}

