/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.hugegraph.api.auth;

import com.baidu.hugegraph.api.auth.AuthAPI;
import com.baidu.hugegraph.client.RestClient;
import com.baidu.hugegraph.rest.RestResult;
import com.baidu.hugegraph.structure.auth.Target;
import com.baidu.hugegraph.structure.constant.HugeType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class TargetAPI
extends AuthAPI {
    public TargetAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return HugeType.TARGET.string();
    }

    public Target create(Target target) {
        RestResult result = this.client.post(this.path(), target);
        return (Target)result.readObject(Target.class);
    }

    public Target get(Object id) {
        RestResult result = this.client.get(this.path(), TargetAPI.formatEntityId(id));
        return (Target)result.readObject(Target.class);
    }

    public List<Target> list(int limit) {
        TargetAPI.checkLimit(limit, "Limit");
        ImmutableMap params = ImmutableMap.of((Object)"limit", (Object)limit);
        RestResult result = this.client.get(this.path(), (Map)params);
        return result.readList(this.type(), Target.class);
    }

    public Target update(Target target) {
        String id = TargetAPI.formatEntityId(target.id());
        RestResult result = this.client.put(this.path(), id, target);
        return (Target)result.readObject(Target.class);
    }

    public void delete(Object id) {
        this.client.delete(this.path(), TargetAPI.formatEntityId(id));
    }
}

