/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.Extent;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.SysException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class ExtentImp
implements Extent {
    private Hashtable participants_ = null;
    private boolean queried_ = false;
    private Stack directs_;

    public ExtentImp() {
        this.participants_ = new Hashtable();
        this.directs_ = new Stack();
    }

    public ExtentImp(Hashtable participants, Stack directs) {
        this.participants_ = (Hashtable)participants.clone();
        this.directs_ = (Stack)directs.clone();
    }

    public void addRemoteParticipants(Dictionary participants) throws IllegalStateException, SysException {
        if (participants == null) {
            return;
        }
        Enumeration enumm = participants.keys();
        while (enumm.hasMoreElements()) {
            String participant = (String)enumm.nextElement();
            Integer count = (Integer)this.participants_.get(participant);
            if (count == null) {
                count = new Integer(0);
            }
            Integer cnt = (Integer)participants.get(participant);
            count = new Integer(count + cnt);
            this.participants_.put(participant, count);
        }
    }

    public Hashtable getRemoteParticipants() {
        this.queried_ = true;
        return (Hashtable)this.participants_.clone();
    }

    public Stack getParticipants() {
        this.queried_ = true;
        return (Stack)this.directs_.clone();
    }

    public synchronized void add(Participant participant, int count) throws SysException, IllegalStateException {
        Hashtable<String, Integer> table = new Hashtable<String, Integer>();
        table.put(participant.getURI(), new Integer(count));
        this.addRemoteParticipants(table);
        this.directs_.push(participant);
    }

    public synchronized void add(Extent extent) throws IllegalStateException, SysException {
        if (this.queried_) {
            throw new IllegalStateException("Adding extent no longer allowed");
        }
        this.addRemoteParticipants(extent.getRemoteParticipants());
        Enumeration enumm = extent.getParticipants().elements();
        while (enumm.hasMoreElements()) {
            Participant part = (Participant)enumm.nextElement();
            this.directs_.push(part);
        }
    }
}

