/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.HeuristicMessage;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.imp.PropagationException;
import com.atomikos.icatch.imp.PropagationMessage;
import com.atomikos.icatch.imp.Result;
import com.atomikos.icatch.system.Configuration;

class CommitMessage
extends PropagationMessage {
    protected boolean onephase_ = false;
    protected int retrycount_ = 0;

    public CommitMessage(Participant participant, Result result, boolean onephase) {
        super(participant, result);
        this.onephase_ = onephase;
    }

    protected Object send() throws PropagationException {
        Participant part = this.getParticipant();
        HeuristicMessage[] msgs = null;
        try {
            msgs = part.commit(this.onephase_);
            return msgs;
        }
        catch (RollbackException rb) {
            throw new PropagationException((Exception)((Object)rb), false);
        }
        catch (HeurMixedException heurm) {
            throw new PropagationException((Exception)((Object)heurm), false);
        }
        catch (HeurRollbackException heurr) {
            throw new PropagationException((Exception)((Object)heurr), false);
        }
        catch (Exception e) {
            String msg = "Unexpected error in commit";
            Configuration.logWarning(msg, e);
            HeurHazardException heurh = new HeurHazardException(part.getHeuristicMessages());
            throw new PropagationException((Exception)heurh, true);
        }
    }

    public String toString() {
        return "CommitMessage to " + this.getParticipant();
    }
}

