/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter.tools;

import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import java.io.File;
import java.net.ConnectException;

public class ConvertDocument {
    static final int EXIT_CODE_SUCCESS = 0;
    static final int EXIT_CODE_CONNECTION_FAILED = 1;
    static final int EXIT_CODE_TOO_FEW_ARGS = 255;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int process(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("USAGE: " + ConvertDocument.class.getName() + " <input-file> <output-file>");
            return 255;
        }
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        SocketOpenOfficeConnection connection = new SocketOpenOfficeConnection();
        try {
            connection.connect();
        }
        catch (ConnectException officeNotRunning) {
            System.err.println("ERROR: connection failed. Please make sure OpenOffice.org is running and listening on port 8100.");
            return 1;
        }
        try {
            OpenOfficeDocumentConverter converter = new OpenOfficeDocumentConverter(connection);
            converter.convert(inputFile, outputFile);
        }
        finally {
            connection.disconnect();
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        System.exit(ConvertDocument.process(args));
    }
}

