/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter.openoffice.converter;

import com.artofsolving.jodconverter.DocumentConverter;
import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.artofsolving.jodconverter.XmlDocumentFormatRegistry;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.XComponent;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XRefreshable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractOpenOfficeDocumentConverter
implements DocumentConverter {
    protected OpenOfficeConnection openOfficeConnection;
    private DocumentFormatRegistry documentFormatRegistry;

    public AbstractOpenOfficeDocumentConverter(OpenOfficeConnection connection) {
        this(connection, new XmlDocumentFormatRegistry());
    }

    public AbstractOpenOfficeDocumentConverter(OpenOfficeConnection openOfficeConnection, DocumentFormatRegistry documentFormatRegistry) {
        this.openOfficeConnection = openOfficeConnection;
        this.documentFormatRegistry = documentFormatRegistry;
    }

    protected DocumentFormatRegistry getDocumentFormatRegistry() {
        return this.documentFormatRegistry;
    }

    public void convert(File inputFile, File outputFile) {
        this.convert(inputFile, outputFile, null);
    }

    public void convert(File inputFile, File outputFile, DocumentFormat outputFormat) {
        this.convert(inputFile, null, outputFile, outputFormat);
    }

    public void convert(InputStream inputStream, DocumentFormat inputFormat, OutputStream outputStream, DocumentFormat outputFormat) {
        this.ensureNotNull("inputStream", inputStream);
        this.ensureNotNull("inputFormat", inputFormat);
        this.ensureNotNull("outputStream", outputStream);
        this.ensureNotNull("outputFormat", outputFormat);
        this.convertInternal(inputStream, inputFormat, outputStream, outputFormat);
    }

    public void convert(File inputFile, DocumentFormat inputFormat, File outputFile, DocumentFormat outputFormat) {
        this.ensureNotNull("inputFile", inputFile);
        this.ensureNotNull("outputFile", outputFile);
        if (!inputFile.exists()) {
            throw new IllegalArgumentException("inputFile doesn't exist: " + inputFile);
        }
        if (inputFormat == null) {
            inputFormat = this.guessDocumentFormat(inputFile);
        }
        if (outputFormat == null) {
            outputFormat = this.guessDocumentFormat(outputFile);
        }
        if (!inputFormat.isImportable()) {
            throw new IllegalArgumentException("unsupported input format: " + inputFormat.getName());
        }
        if (!inputFormat.isExportableTo(outputFormat)) {
            throw new IllegalArgumentException("unsupported conversion: from " + inputFormat.getName() + " to " + outputFormat.getName());
        }
        this.convertInternal(inputFile, inputFormat, outputFile, outputFormat);
    }

    protected abstract void convertInternal(InputStream var1, DocumentFormat var2, OutputStream var3, DocumentFormat var4);

    protected abstract void convertInternal(File var1, DocumentFormat var2, File var3, DocumentFormat var4);

    private void ensureNotNull(String argumentName, Object argumentValue) {
        if (argumentValue == null) {
            throw new IllegalArgumentException(argumentName + " is null");
        }
    }

    private DocumentFormat guessDocumentFormat(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName());
        DocumentFormat format = this.getDocumentFormatRegistry().getFormatByFileExtension(extension);
        if (format == null) {
            throw new IllegalArgumentException("unknown document format for file: " + file);
        }
        return format;
    }

    protected void refreshDocument(XComponent document) {
        XRefreshable refreshable = (XRefreshable)UnoRuntime.queryInterface((Class)XRefreshable.class, (Object)document);
        if (refreshable != null) {
            refreshable.refresh();
        }
    }

    protected static PropertyValue property(String name, Object value) {
        PropertyValue property = new PropertyValue();
        property.Name = name;
        property.Value = value;
        return property;
    }

    protected static PropertyValue[] toPropertyValues(Map properties) {
        PropertyValue[] propertyValues = new PropertyValue[properties.size()];
        int i = 0;
        Iterator iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            propertyValues[i++] = AbstractOpenOfficeDocumentConverter.property((String)entry.getKey(), entry.getValue());
        }
        return propertyValues;
    }
}

