/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.local;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.io.IFileOp;
import com.android.sdklib.local.LocalAddonPkgInfo;
import com.android.sdklib.local.LocalAndroidVersionPkgInfo;
import com.android.sdklib.local.LocalBuildToolPkgInfo;
import com.android.sdklib.local.LocalDocPkgInfo;
import com.android.sdklib.local.LocalExtraPkgInfo;
import com.android.sdklib.local.LocalFullRevisionPkgInfo;
import com.android.sdklib.local.LocalPkgInfo;
import com.android.sdklib.local.LocalPlatformPkgInfo;
import com.android.sdklib.local.LocalPlatformToolPkgInfo;
import com.android.sdklib.local.LocalSamplePkgInfo;
import com.android.sdklib.local.LocalSourcePkgInfo;
import com.android.sdklib.local.LocalSysImgPkgInfo;
import com.android.sdklib.local.LocalToolPkgInfo;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.NoPreviewRevision;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.zip.Adler32;

public class LocalSdk {
    public static final int PKG_ALL = 65535;
    public static final int PKG_TOOLS = 1;
    public static final int PKG_PLATFORM_TOOLS = 2;
    public static final int PKG_BUILD_TOOLS = 4;
    public static final int PKG_DOCS = 16;
    public static final int PKG_EXTRAS = 32;
    public static final int PKG_PLATFORMS = 256;
    public static final int PKG_SYS_IMAGES = 512;
    public static final int PKG_ADDONS = 1024;
    public static final int PKG_SAMPLES = 2048;
    public static final int PKG_SOURCES = 4096;
    private File mSdkRoot;
    private final IFileOp mFileOp;
    private final Multimap<Integer, LocalPkgInfo> mLocalPackages = TreeMultimap.create();
    private final Multimap<Integer, DirInfo> mVisitedDirs = HashMultimap.create();
    private BuildToolInfo mLegacyBuildTools;
    private static final Map<Integer, String> sFolderName = Maps.newHashMap();

    public LocalSdk() {
        this.mFileOp = new FileOp();
    }

    public LocalSdk(@NonNull File sdkRoot) {
        this();
        this.setLocation(sdkRoot);
    }

    protected LocalSdk(@NonNull IFileOp fileOp) {
        this.mFileOp = fileOp;
    }

    public IFileOp getFileOp() {
        return this.mFileOp;
    }

    public void setLocation(@NonNull File sdkRoot) {
        assert (sdkRoot != null);
        this.mSdkRoot = sdkRoot;
        this.clearLocalPkg(65535);
    }

    @Nullable
    public File getLocation() {
        return this.mSdkRoot;
    }

    public void clearLocalPkg(int filters) {
        int minf;
        this.mLegacyBuildTools = null;
        for (int filter = minf = Integer.lowestOneBit(filters); filters != 0 && filter <= 65535; filter <<= 1) {
            if ((filters & filter) == 0) continue;
            filters ^= filter;
            this.mVisitedDirs.removeAll((Object)filter);
            this.mLocalPackages.removeAll((Object)filter);
        }
    }

    public boolean hasChanged(int filters) {
        int minf;
        for (int filter = minf = Integer.lowestOneBit(filters); filters != 0 && filter <= 65535; filter <<= 1) {
            if ((filters & filter) == 0) continue;
            filters ^= filter;
            for (DirInfo dirInfo : this.mVisitedDirs.get((Object)filter)) {
                if (!dirInfo.hasChanged()) continue;
                return true;
            }
        }
        return false;
    }

    public LocalPkgInfo getPkgInfo(int filter, AndroidVersion version) {
        assert (filter == 256 || filter == 2048 || filter == 4096);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            LocalAndroidVersionPkgInfo p;
            if (!(pkg instanceof LocalAndroidVersionPkgInfo) || !(p = (LocalAndroidVersionPkgInfo)pkg).getAndroidVersion().equals(version)) continue;
            return p;
        }
        return null;
    }

    public LocalPkgInfo getPkgInfo(int filter, FullRevision revision) {
        assert (filter == 4);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            LocalFullRevisionPkgInfo p;
            if (!(pkg instanceof LocalFullRevisionPkgInfo) || !(p = (LocalFullRevisionPkgInfo)pkg).getFullRevision().equals(revision)) continue;
            return p;
        }
        return null;
    }

    public LocalPkgInfo getPkgInfo(int filter, String vendorPath) {
        assert (filter == 32 || filter == 1024 || filter == 256);
        for (LocalPkgInfo pkg : this.getPkgsInfos(filter)) {
            if (!pkg.hasPath() || !vendorPath.equals(pkg.getPath())) continue;
            return pkg;
        }
        return null;
    }

    public LocalExtraPkgInfo getExtra(String vendorPath) {
        return (LocalExtraPkgInfo)this.getPkgInfo(32, vendorPath);
    }

    public LocalPkgInfo getPkgInfo(int filter) {
        assert (filter == 1 || filter == 2 || filter == 16);
        switch (filter) {
            case 1: 
            case 2: 
            case 16: {
                break;
            }
            default: {
                return null;
            }
        }
        Collection existing = this.mLocalPackages.get((Object)filter);
        assert (existing.size() <= 1);
        if (existing.size() > 0) {
            return (LocalPkgInfo)existing.iterator().next();
        }
        File uniqueDir = new File(this.mSdkRoot, sFolderName.get(filter));
        LocalPkgInfo info = null;
        if (!this.mVisitedDirs.containsEntry((Object)filter, (Object)uniqueDir)) {
            switch (filter) {
                case 1: {
                    info = this.scanTools(uniqueDir);
                    break;
                }
                case 2: {
                    info = this.scanPlatformTools(uniqueDir);
                    break;
                }
                case 16: {
                    info = this.scanDoc(uniqueDir);
                }
            }
        }
        this.mVisitedDirs.put((Object)filter, (Object)new DirInfo(uniqueDir));
        if (info != null) {
            this.mLocalPackages.put((Object)filter, (Object)info);
        }
        return info;
    }

    public LocalPkgInfo[] getPkgsInfos(int filters) {
        int minf;
        ArrayList list = Lists.newArrayList();
        block13: for (int filter = minf = Integer.lowestOneBit(filters); filters != 0 && filter <= 65535; filter <<= 1) {
            if ((filters & filter) == 0) continue;
            filters ^= filter;
            switch (filter) {
                case 1: 
                case 2: 
                case 16: {
                    LocalPkgInfo info = this.getPkgInfo(filter);
                    if (info == null) continue block13;
                    list.add(info);
                    continue block13;
                }
                case 4: 
                case 32: 
                case 256: 
                case 512: 
                case 1024: 
                case 2048: 
                case 4096: {
                    Collection existing = this.mLocalPackages.get((Object)filter);
                    if (existing.size() > 0) {
                        list.addAll(existing);
                        continue block13;
                    }
                    File subDir = new File(this.mSdkRoot, sFolderName.get(filter));
                    if (this.mVisitedDirs.containsEntry((Object)filter, (Object)subDir)) continue block13;
                    switch (filter) {
                        case 4: {
                            this.scanBuildTools(subDir, existing);
                            break;
                        }
                        case 256: {
                            this.scanPlatforms(subDir, existing);
                            break;
                        }
                        case 512: {
                            this.scanSysImages(subDir, existing);
                            break;
                        }
                        case 1024: {
                            this.scanAddons(subDir, existing);
                            break;
                        }
                        case 2048: {
                            this.scanSamples(subDir, existing);
                            break;
                        }
                        case 4096: {
                            this.scanSources(subDir, existing);
                            break;
                        }
                        case 32: {
                            this.scanExtras(subDir, existing);
                        }
                    }
                    this.mVisitedDirs.put((Object)filter, (Object)new DirInfo(subDir));
                    list.addAll(existing);
                }
            }
        }
        return list.toArray(new LocalPkgInfo[list.size()]);
    }

    @Nullable
    public BuildToolInfo getBuildTool(@Nullable FullRevision revision) {
        LocalPkgInfo pkg = this.getPkgInfo(4, revision);
        if (pkg instanceof LocalBuildToolPkgInfo) {
            return ((LocalBuildToolPkgInfo)pkg).getBuildToolInfo();
        }
        return null;
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool() {
        if (this.mLegacyBuildTools != null) {
            return this.mLegacyBuildTools;
        }
        Object[] pkgs = this.getPkgsInfos(4);
        if (pkgs.length == 0) {
            LocalPkgInfo ptPkg = this.getPkgInfo(2);
            if (ptPkg instanceof LocalPlatformToolPkgInfo && ptPkg.getFullRevision().compareTo(new FullRevision(17)) < 0) {
                this.mLegacyBuildTools = this.createLegacyBuildTools((LocalPlatformToolPkgInfo)ptPkg);
                return this.mLegacyBuildTools;
            }
            return null;
        }
        assert (pkgs.length > 0);
        Arrays.sort(pkgs);
        Object pkg = pkgs[pkgs.length - 1];
        if (pkg instanceof LocalBuildToolPkgInfo) {
            return ((LocalBuildToolPkgInfo)pkg).getBuildToolInfo();
        }
        return null;
    }

    private BuildToolInfo createLegacyBuildTools(LocalPlatformToolPkgInfo ptInfo) {
        File platformTools = new File(this.getLocation(), "platform-tools");
        File platformToolsLib = ptInfo.getLocalDir();
        File platformToolsRs = new File(platformTools, "renderscript");
        return new BuildToolInfo(ptInfo.getFullRevision(), platformTools, new File(platformTools, SdkConstants.FN_AAPT), new File(platformTools, SdkConstants.FN_AIDL), new File(platformTools, SdkConstants.FN_DX), new File(platformToolsLib, "dx.jar"), new File(platformTools, SdkConstants.FN_RENDERSCRIPT), new File(platformToolsRs, "include"), new File(platformToolsRs, "clang-include"), null, null, null, null);
    }

    @Nullable
    public IAndroidTarget getTargetFromHashString(@Nullable String hash) {
        if (hash != null) {
            LocalPkgInfo[] pkgs;
            boolean isPlatform = AndroidTargetHash.isPlatform(hash);
            for (LocalPkgInfo pkg : pkgs = this.getPkgsInfos(isPlatform ? 256 : 1024)) {
                IAndroidTarget target;
                if (!(pkg instanceof LocalPlatformPkgInfo) || (target = ((LocalPlatformPkgInfo)pkg).getAndroidTarget()) == null || !hash.equals(AndroidTargetHash.getTargetHashString(target))) continue;
                return target;
            }
        }
        return null;
    }

    private LocalToolPkgInfo scanTools(File toolFolder) {
        File[] files;
        Properties props = this.parseProperties(new File(toolFolder, "source.properties"));
        FullRevision rev = PackageParserUtils.getPropertyFullRevision(props);
        if (rev == null) {
            return null;
        }
        LocalToolPkgInfo info = new LocalToolPkgInfo(this, toolFolder, props, rev);
        boolean hasEmulator = false;
        boolean hasAndroid = false;
        String android1 = SdkConstants.androidCmdName().replace(".bat", ".exe");
        String android2 = android1.indexOf(46) == -1 ? null : android1.replace(".exe", ".bat");
        for (File file : files = this.mFileOp.listFiles(toolFolder)) {
            String name = file.getName();
            if (SdkConstants.FN_EMULATOR.equals(name)) {
                hasEmulator = true;
            }
            if (!android1.equals(name) && (android2 == null || !android2.equals(name))) continue;
            hasAndroid = true;
        }
        if (!hasAndroid) {
            info.appendLoadError("Missing %1$s", SdkConstants.androidCmdName());
        }
        if (!hasEmulator) {
            info.appendLoadError("Missing %1$s", SdkConstants.FN_EMULATOR);
        }
        return info;
    }

    private LocalPlatformToolPkgInfo scanPlatformTools(File ptFolder) {
        Properties props = this.parseProperties(new File(ptFolder, "source.properties"));
        FullRevision rev = PackageParserUtils.getPropertyFullRevision(props);
        if (rev == null) {
            return null;
        }
        LocalPlatformToolPkgInfo info = new LocalPlatformToolPkgInfo(this, ptFolder, props, rev);
        return info;
    }

    private LocalDocPkgInfo scanDoc(File docFolder) {
        Properties props = this.parseProperties(new File(docFolder, "source.properties"));
        MajorRevision rev = PackageParserUtils.getPropertyMajorRevision(props);
        if (rev == null) {
            return null;
        }
        LocalDocPkgInfo info = new LocalDocPkgInfo(this, docFolder, props, rev);
        if (!this.mFileOp.isFile(new File(docFolder, "index.html"))) {
            info.appendLoadError("Missing index.html", new Object[0]);
        }
        return info;
    }

    private void scanBuildTools(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File buildToolDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(buildToolDir) || this.mVisitedDirs.containsEntry((Object)4, (Object)buildToolDir)) continue;
            this.mVisitedDirs.put((Object)4, (Object)new DirInfo(buildToolDir));
            Properties props = this.parseProperties(new File(buildToolDir, "source.properties"));
            FullRevision rev = PackageParserUtils.getPropertyFullRevision(props);
            if (rev == null) continue;
            BuildToolInfo btInfo = new BuildToolInfo(rev, buildToolDir);
            LocalBuildToolPkgInfo pkgInfo = new LocalBuildToolPkgInfo(this, buildToolDir, props, rev, btInfo);
            outCollection.add(pkgInfo);
        }
    }

    private void scanPlatforms(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(platformDir) || this.mVisitedDirs.containsEntry((Object)256, (Object)platformDir)) continue;
            this.mVisitedDirs.put((Object)256, (Object)new DirInfo(platformDir));
            Properties props = this.parseProperties(new File(platformDir, "source.properties"));
            MajorRevision rev = PackageParserUtils.getPropertyMajorRevision(props);
            if (rev == null) continue;
            try {
                AndroidVersion vers = new AndroidVersion(props);
                LocalPlatformPkgInfo pkgInfo = new LocalPlatformPkgInfo(this, platformDir, props, vers, rev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanAddons(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File addonDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(addonDir) || this.mVisitedDirs.containsEntry((Object)1024, (Object)addonDir)) continue;
            this.mVisitedDirs.put((Object)1024, (Object)new DirInfo(addonDir));
            Properties props = this.parseProperties(new File(addonDir, "source.properties"));
            MajorRevision rev = PackageParserUtils.getPropertyMajorRevision(props);
            if (rev == null) continue;
            try {
                AndroidVersion vers = new AndroidVersion(props);
                LocalAddonPkgInfo pkgInfo = new LocalAddonPkgInfo(this, addonDir, props, vers, rev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanSysImages(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(platformDir) || this.mVisitedDirs.containsEntry((Object)512, (Object)platformDir)) continue;
            this.mVisitedDirs.put((Object)512, (Object)new DirInfo(platformDir));
            for (File abiDir : this.mFileOp.listFiles(platformDir)) {
                if (!this.mFileOp.isDirectory(abiDir) || this.mVisitedDirs.containsEntry((Object)512, (Object)abiDir)) continue;
                this.mVisitedDirs.put((Object)512, (Object)new DirInfo(abiDir));
                Properties props = this.parseProperties(new File(abiDir, "source.properties"));
                MajorRevision rev = PackageParserUtils.getPropertyMajorRevision(props);
                if (rev == null) continue;
                try {
                    AndroidVersion vers = new AndroidVersion(props);
                    LocalSysImgPkgInfo pkgInfo = new LocalSysImgPkgInfo(this, abiDir, props, vers, abiDir.getName(), rev);
                    outCollection.add(pkgInfo);
                }
                catch (AndroidVersion.AndroidVersionException e) {
                    // empty catch block
                }
            }
        }
    }

    private void scanSamples(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(platformDir) || this.mVisitedDirs.containsEntry((Object)2048, (Object)platformDir)) continue;
            this.mVisitedDirs.put((Object)2048, (Object)new DirInfo(platformDir));
            Properties props = this.parseProperties(new File(platformDir, "source.properties"));
            MajorRevision rev = PackageParserUtils.getPropertyMajorRevision(props);
            if (rev == null) continue;
            try {
                AndroidVersion vers = new AndroidVersion(props);
                LocalSamplePkgInfo pkgInfo = new LocalSamplePkgInfo(this, platformDir, props, vers, rev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanSources(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File platformDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(platformDir) || this.mVisitedDirs.containsEntry((Object)4096, (Object)platformDir)) continue;
            this.mVisitedDirs.put((Object)4096, (Object)new DirInfo(platformDir));
            Properties props = this.parseProperties(new File(platformDir, "source.properties"));
            MajorRevision rev = PackageParserUtils.getPropertyMajorRevision(props);
            if (rev == null) continue;
            try {
                AndroidVersion vers = new AndroidVersion(props);
                LocalSourcePkgInfo pkgInfo = new LocalSourcePkgInfo(this, platformDir, props, vers, rev);
                outCollection.add(pkgInfo);
            }
            catch (AndroidVersion.AndroidVersionException e) {
                // empty catch block
            }
        }
    }

    private void scanExtras(File collectionDir, Collection<LocalPkgInfo> outCollection) {
        for (File vendorDir : this.mFileOp.listFiles(collectionDir)) {
            if (!this.mFileOp.isDirectory(vendorDir) || this.mVisitedDirs.containsEntry((Object)32, (Object)vendorDir)) continue;
            this.mVisitedDirs.put((Object)32, (Object)new DirInfo(vendorDir));
            for (File extraDir : this.mFileOp.listFiles(vendorDir)) {
                if (!this.mFileOp.isDirectory(extraDir) || this.mVisitedDirs.containsEntry((Object)32, (Object)extraDir)) continue;
                this.mVisitedDirs.put((Object)32, (Object)new DirInfo(extraDir));
                Properties props = this.parseProperties(new File(extraDir, "source.properties"));
                NoPreviewRevision rev = PackageParserUtils.getPropertyNoPreviewRevision(props);
                if (rev == null) continue;
                LocalExtraPkgInfo pkgInfo = new LocalExtraPkgInfo(this, extraDir, props, vendorDir.getName(), extraDir.getName(), rev);
                outCollection.add(pkgInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties parseProperties(File propsFile) {
        InputStream fis = null;
        try {
            if (this.mFileOp.exists(propsFile)) {
                fis = this.mFileOp.newFileInputStream(propsFile);
                Properties props = new Properties();
                props.load(fis);
                if (props.size() > 0) {
                    Properties properties = props;
                    return properties;
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    static {
        sFolderName.put(1, "tools");
        sFolderName.put(2, "platform-tools");
        sFolderName.put(4, "build-tools");
        sFolderName.put(16, "docs");
        sFolderName.put(256, "platforms");
        sFolderName.put(512, "system-images");
        sFolderName.put(1024, "add-ons");
        sFolderName.put(4096, "sources");
        sFolderName.put(2048, "samples");
        sFolderName.put(32, "extras");
    }

    private class DirInfo {
        @NonNull
        private final File mDir;
        private final long mDirModifiedTS;
        private final long mPropsModifiedTS;
        private final long mPropsChecksum;

        public DirInfo(File dir) {
            this.mDir = dir;
            this.mDirModifiedTS = LocalSdk.this.mFileOp.lastModified(dir);
            long propsChecksum = 0L;
            long propsModifiedTS = 0L;
            File props = new File(dir, "source.properties");
            if (LocalSdk.this.mFileOp.isFile(props)) {
                propsModifiedTS = LocalSdk.this.mFileOp.lastModified(props);
                propsChecksum = this.getFileChecksum(props);
            }
            this.mPropsModifiedTS = propsModifiedTS;
            this.mPropsChecksum = propsChecksum;
        }

        public boolean hasChanged() {
            boolean hadProps;
            if (!LocalSdk.this.mFileOp.isDirectory(this.mDir)) {
                return true;
            }
            if (this.mDirModifiedTS != LocalSdk.this.mFileOp.lastModified(this.mDir)) {
                return true;
            }
            File props = new File(this.mDir, "source.properties");
            boolean bl = hadProps = this.mPropsModifiedTS != 0L;
            if (hadProps != LocalSdk.this.mFileOp.isFile(props)) {
                return true;
            }
            if (hadProps) {
                if (this.mPropsModifiedTS != LocalSdk.this.mFileOp.lastModified(props)) {
                    return true;
                }
                if (this.mPropsChecksum != this.getFileChecksum(props)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getFileChecksum(@NonNull File file) {
            InputStream fis = null;
            try {
                int n;
                fis = LocalSdk.this.mFileOp.newFileInputStream(file);
                Adler32 a = new Adler32();
                byte[] buf = new byte[1024];
                while ((n = fis.read(buf)) > 0) {
                    a.update(buf, 0, n);
                }
                long l = a.getValue();
                return l;
            }
            catch (Exception ignore) {
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception ignore) {}
            }
            return 0L;
        }

        public String toString() {
            String s = String.format("<DirInfo %1$s TS=%2$d", this.mDir, this.mDirModifiedTS);
            if (this.mPropsModifiedTS != 0L) {
                s = s + String.format(" | Props TS=%1$d, Chksum=%2$s", this.mPropsModifiedTS, this.mPropsChecksum);
            }
            return s + ">";
        }

        public int hashCode() {
            return this.mDir.hashCode();
        }

        public boolean equals(Object obj) {
            return this.mDir.equals(obj);
        }
    }
}

