/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.io;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.sdklib.io.IFileOp;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Properties;

public class FileOp
implements IFileOp {
    private static Method sFileSetExecutable = null;
    private static final Object[] sFileSetExecutableParams = new Object[]{Boolean.TRUE, Boolean.FALSE};

    public static File append(@NonNull File base, String ... segments) {
        for (String segment : segments) {
            base = new File(base, segment);
        }
        return base;
    }

    public static File append(@NonNull String base, String ... segments) {
        return FileOp.append(new File(base), segments);
    }

    @Override
    public void deleteFileOrFolder(@NonNull File fileOrFolder) {
        if (fileOrFolder != null) {
            File[] files;
            if (this.isDirectory(fileOrFolder) && (files = fileOrFolder.listFiles()) != null) {
                for (File item : files) {
                    this.deleteFileOrFolder(item);
                }
            }
            if (!this.exists(fileOrFolder)) {
                return;
            }
            if (SdkConstants.CURRENT_PLATFORM == 2) {
                for (int i = 0; i < 5; ++i) {
                    if (fileOrFolder.delete()) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                fileOrFolder.deleteOnExit();
            } else if (!fileOrFolder.delete()) {
                fileOrFolder.deleteOnExit();
            }
        }
    }

    @Override
    public void setExecutablePermission(@NonNull File file) throws IOException {
        if (sFileSetExecutable != null) {
            try {
                sFileSetExecutable.invoke((Object)file, sFileSetExecutableParams);
                return;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        Runtime.getRuntime().exec(new String[]{"chmod", "+x", file.getAbsolutePath()});
    }

    @Override
    public void setReadOnly(@NonNull File file) {
        file.setReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFile(@NonNull File source, @NonNull File dest) throws IOException {
        byte[] buffer = new byte[8192];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int read;
            fis = new FileInputStream(source);
            fos = new FileOutputStream(dest);
            while ((read = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, read);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSameFile(@NonNull File file1, @NonNull File file2) throws IOException {
        if (file1.length() != file2.length()) {
            return false;
        }
        FileInputStream fis1 = null;
        FileInputStream fis2 = null;
        try {
            boolean bl;
            fis1 = new FileInputStream(file1);
            fis2 = new FileInputStream(file2);
            byte[] buffer1 = new byte[8192];
            byte[] buffer2 = new byte[8192];
            do {
                int n;
                int read1;
                if ((read1 = fis1.read(buffer1)) == -1) return true;
                int read2 = 0;
                while (read2 < read1 && (n = fis2.read(buffer2, read2, read1 - read2)) != -1) {
                }
                if (read2 == read1) continue;
                bl = false;
                return bl;
            } while (Arrays.equals(buffer1, buffer2));
            bl = false;
            return bl;
        }
        finally {
            if (fis2 != null) {
                try {
                    fis2.close();
                }
                catch (IOException e) {}
            }
            if (fis1 != null) {
                try {
                    fis1.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public boolean isFile(@NonNull File file) {
        return file.isFile();
    }

    @Override
    public boolean isDirectory(@NonNull File file) {
        return file.isDirectory();
    }

    @Override
    public boolean exists(@NonNull File file) {
        return file.exists();
    }

    @Override
    public long length(@NonNull File file) {
        return file.length();
    }

    @Override
    public boolean delete(@NonNull File file) {
        return file.delete();
    }

    @Override
    public boolean mkdirs(@NonNull File file) {
        return file.mkdirs();
    }

    @Override
    @NonNull
    public File[] listFiles(@NonNull File file) {
        File[] r = file.listFiles();
        if (r == null) {
            return new File[0];
        }
        return r;
    }

    @Override
    public boolean renameTo(@NonNull File oldFile, @NonNull File newFile) {
        return oldFile.renameTo(newFile);
    }

    @Override
    @NonNull
    public OutputStream newFileOutputStream(@NonNull File file) throws FileNotFoundException {
        return new FileOutputStream(file);
    }

    @Override
    @NonNull
    public InputStream newFileInputStream(@NonNull File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NonNull
    public Properties loadProperties(@NonNull File file) {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            props.load(fis);
        }
        catch (IOException ignore) {
            Closeables.closeQuietly((Closeable)fis);
            catch (Throwable throwable) {
                Closeables.closeQuietly(fis);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)fis);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveProperties(@NonNull File file, @NonNull Properties props, @NonNull String comments) {
        OutputStream fos = null;
        try {
            fos = this.newFileOutputStream(file);
            props.store(fos, comments);
            boolean bl = true;
            return bl;
        }
        catch (IOException ignore) {
        }
        finally {
            Closeables.closeQuietly((Closeable)fos);
        }
        return false;
    }

    @Override
    public long lastModified(@NonNull File file) {
        return file.lastModified();
    }

    static {
        try {
            sFileSetExecutable = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

