/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.annotations.NonNull;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.BrokenPackage;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.IPlatformDependency;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class SystemImagePackage
extends MajorRevisionPackage
implements IAndroidVersionProvider,
IPlatformDependency {
    private final AndroidVersion mVersion;
    private final String mAbi;

    public SystemImagePackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        int apiLevel = PackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = PackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        this.mVersion = new AndroidVersion(apiLevel, codeName);
        this.mAbi = PackageParserUtils.getXmlString(packageNode, "abi");
    }

    public SystemImagePackage(AndroidVersion platformVersion, int revision, String abi, Properties props, String localOsPath) {
        this(null, platformVersion, revision, abi, props, localOsPath);
    }

    protected SystemImagePackage(SdkSource source, AndroidVersion platformVersion, int revision, String abi, Properties props, String localOsPath) {
        super(source, props, revision, null, null, null, Archive.Os.getCurrentOs(), Archive.Arch.getCurrentArch(), localOsPath);
        this.mVersion = platformVersion;
        if (abi == null && props != null) {
            abi = props.getProperty("SystemImage.Abi");
        }
        assert (abi != null) : "To use this SystemImagePackage constructor you must pass an ABI as a parameter or as a PROP_ABI property";
        this.mAbi = abi;
    }

    public static Package createBroken(File abiDir, Properties props) {
        AndroidVersion version = null;
        String abiType = abiDir.getName();
        String error = null;
        if (props == null) {
            error = String.format("Missing file %1$s", "source.properties");
        } else {
            try {
                version = new AndroidVersion(props);
                String abi = props.getProperty("SystemImage.Abi");
                if (abi != null) {
                    abiType = abi;
                } else {
                    error = String.format("Invalid file %1$s: Missing property %2$s", "source.properties", "SystemImage.Abi");
                }
            }
            catch (AndroidVersion.AndroidVersionException e) {
                error = String.format("Invalid file %1$s: %2$s", "source.properties", e.getMessage());
            }
        }
        if (version == null) {
            try {
                String platform = abiDir.getParentFile().getName();
                platform = platform.replaceAll("[^0-9]+", " ").trim();
                int pos = platform.indexOf(32);
                if (pos >= 0) {
                    platform = platform.substring(0, pos);
                }
                int apiLevel = Integer.parseInt(platform);
                version = new AndroidVersion(apiLevel, null);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder(String.format("Broken %1$s System Image", SystemImagePackage.getAbiDisplayNameInternal(abiType)));
        if (version != null) {
            sb.append(String.format(", API %1$s", version.getApiString()));
        }
        String shortDesc = sb.toString();
        if (error != null) {
            sb.append('\n').append(error);
        }
        String longDesc = sb.toString();
        return new BrokenPackage(props, shortDesc, longDesc, 0, version == null ? 0 : version.getApiLevel(), abiDir.getAbsolutePath());
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
        props.setProperty("SystemImage.Abi", this.mAbi);
    }

    public String getAbi() {
        return this.mAbi;
    }

    public String getAbiDisplayName() {
        return SystemImagePackage.getAbiDisplayNameInternal(this.mAbi);
    }

    private static String getAbiDisplayNameInternal(String abi) {
        return abi.replace("armeabi", "ARM EABI").replace("x86", "Intel x86 Atom").replace("mips", "MIPS").replace("-", " ");
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    @Override
    public String installId() {
        return "sysimg-" + this.mVersion.getApiString();
    }

    @Override
    public String getListDescription() {
        return String.format("%1$s System Image%2$s", this.getAbiDisplayName(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        return String.format("%1$s System Image, Android API %2$s, revision %3$s%4$s", this.getAbiDisplayName(), this.mVersion.getApiString(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = this.getDescription();
        if (s == null || s.length() == 0) {
            s = this.getShortDescription();
        }
        if (s.indexOf("revision") == -1) {
            s = s + String.format("\nRevision %1$s%2$s", this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        s = s + String.format("\nRequires SDK Platform Android API %1$s", this.mVersion.getApiString());
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File folder = new File(osSdkRoot, "system-images");
        folder = new File(folder, "android-" + this.mVersion.getApiString());
        String abi = this.mAbi;
        abi = abi.toLowerCase(Locale.US);
        abi = abi.replaceAll("[^a-z0-9_-]+", "_");
        abi = abi.replaceAll("_+", "_");
        folder = new File(folder, abi);
        return folder;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof SystemImagePackage) {
            SystemImagePackage newPkg = (SystemImagePackage)pkg;
            return this.getAbi().equals(newPkg.getAbi()) && this.getAndroidVersion().equals(newPkg.getAndroidVersion());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mAbi == null ? 0 : this.mAbi.hashCode());
        result = 31 * result + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SystemImagePackage)) {
            return false;
        }
        SystemImagePackage other = (SystemImagePackage)obj;
        if (this.mAbi == null ? other.mAbi != null : !this.mAbi.equals(other.mAbi)) {
            return false;
        }
        return !(this.mVersion == null ? other.mVersion != null : !this.mVersion.equals(other.mVersion));
    }

    @Override
    protected String comparisonKey() {
        String s = super.comparisonKey();
        int pos = s.indexOf("|r:");
        assert (pos > 0);
        s = s.substring(0, pos) + "|abi:" + this.getAbiDisplayName() + s.substring(pos);
        return s;
    }
}

