/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.packages.IExactApiLevelDependency;
import com.android.sdklib.internal.repository.packages.IMinApiLevelDependency;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import java.io.File;
import java.util.Properties;

public class BrokenPackage
extends MajorRevisionPackage
implements IExactApiLevelDependency,
IMinApiLevelDependency {
    private final int mMinApiLevel;
    private final int mExactApiLevel;
    private final String mShortDescription;
    private final String mLongDescription;

    BrokenPackage(Properties props, String shortDescription, String longDescription, int minApiLevel, int exactApiLevel, String archiveOsPath) {
        super(null, props, 0, null, longDescription, null, Archive.Os.ANY, Archive.Arch.ANY, archiveOsPath);
        this.mShortDescription = shortDescription;
        this.mLongDescription = longDescription;
        this.mMinApiLevel = minApiLevel;
        this.mExactApiLevel = exactApiLevel;
    }

    @Override
    public void saveProperties(Properties props) {
    }

    @Override
    public int getMinApiLevel() {
        return this.mMinApiLevel;
    }

    @Override
    public int getExactApiLevel() {
        return this.mExactApiLevel;
    }

    @Override
    public String installId() {
        return "";
    }

    @Override
    public String getListDescription() {
        return this.mShortDescription;
    }

    @Override
    public String getShortDescription() {
        return this.mShortDescription;
    }

    @Override
    public String getLongDescription() {
        String s = this.mLongDescription;
        if (s != null && s.length() != 0) {
            return s;
        }
        s = this.getDescription();
        if (s != null && s.length() != 0) {
            return s;
        }
        return this.getShortDescription();
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        return null;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof BrokenPackage) {
            return this.mShortDescription.equals(((BrokenPackage)pkg).mShortDescription) && this.getDescription().equals(pkg.getDescription()) && this.getMinApiLevel() == ((BrokenPackage)pkg).getMinApiLevel();
        }
        return false;
    }

    @Override
    public boolean preInstallHook(Archive archive, ITaskMonitor monitor, String osSdkRoot, File installFolder) {
        return super.preInstallHook(archive, monitor, osSdkRoot, installFolder);
    }

    @Override
    public void postInstallHook(Archive archive, ITaskMonitor monitor, File installFolder) {
        super.postInstallHook(archive, monitor, installFolder);
    }
}

