package com.allcam.mss.ability.transcode.request;

import com.allcam.common.base.BaseRequest;
import com.allcam.common.utils.RegularUtil;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class CreateLiveTranscodeRequest extends BaseRequest
{
    private static final long serialVersionUID = -3513379272983407724L;

    private String contentId;

    @Verification(type = VerifyType.REGULAR, param = RegularUtil.URI_REGULAR)
    private String liveUrl;

    @Verification(type = VerifyType.HAS_TEXT)
    private String templateId;
}
