package com.allcam.mss.ability.transcode.model;

import com.allcam.common.base.AcBaseBean;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class TranscodeTemplateInfo extends AcBaseBean
{
    private static final long serialVersionUID = -1295286508489134894L;

    private String templateId;

    private String templateName;

    private String templateDesc;

    private String templateContent;

    private int templateType;

    private String creatorId;

    private Date createDate;

    private Date lastDate;

    private List<TranscodeParam> templateParams;

    public void addParam(TranscodeParam param)
    {
        if (null == param)
        {
            return;
        }
        if (null == templateParams)
        {
            templateParams = new ArrayList<>();
        }
        templateParams.add(param);
    }

    public void addParam(String name, String value)
    {
        addParam(new TranscodeParam(name, value));
    }
}
