package com.allcam.mss.ability.transcode;

import com.allcam.common.base.BaseResponse;
import com.allcam.mss.ability.transcode.request.*;

public interface LiveTranscodeService
{
    /**
     * 获取直播流转码模板
     *
     * @param request 请求
     * @return 响应
     */
    GetTemplateResponse getTemplateList(GetTemplateRequest request);

    /**
     * 创建摄像头转码任务
     *
     * @param request 请求
     * @return 响应
     */
    CreateTranscodeTaskResponse createCameraTranscode(CreateCameraTranscodeRequest request);

    /**
     * 创建直播流转码任务
     *
     * @param request 请求
     * @return 响应
     */
    CreateTranscodeTaskResponse createLiveTranscode(CreateLiveTranscodeRequest request);

    /**
     * 删除转码任务
     *
     * @param request 请求
     * @return 响应
     */
    BaseResponse deleteTranscode(DeleteLiveTranscodeRequest request);

    /**
     * 查询转码任务详情
     *
     * @param request 请求
     * @return 响应
     */
    LiveTranscodeDetailResponse getTranscodeDetail(LiveTranscodeDetailRequest request);
}
