package com.allcam.mss.ability.stream.request;

import com.allcam.common.base.BaseRequest;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import com.allcam.mss.ability.constant.MediaConst;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class GetLiveUrlRequest extends BaseRequest
{
    private static final long serialVersionUID = 3485381801757862156L;

    @Verification(type = VerifyType.HAS_TEXT)
    private String contentId;

    @Verification(type = VerifyType.BETWEEN, param = "1,2")
    private int streamType = 1;

    @Verification(type = VerifyType.BETWEEN, param = "1,5")
    private int urlType;

    @Verification(type = VerifyType.BETWEEN, param = "1,2")
    private int agent = MediaConst.AgentType.PUBLIC;
}
