package com.allcam.mss.ability.stream;

import com.allcam.mss.ability.constant.UrlType;
import com.allcam.mss.ability.stream.request.GetLiveUrlRequest;
import com.allcam.mss.ability.stream.request.GetLiveUrlResponse;

/**
 * @author Beowulf
 */
public interface StreamUrlService
{
    /**
     * 流类型-摄像头转码
     */
    int STREAM_CAMERA = 1;

    /**
     * 流类型-推流直播
     */
    int STREAM_PUSH = 2;

    /**
     * 获取直播播放地址
     *
     * @param request 请求
     * @return 响应
     */
    GetLiveUrlResponse requestLiveUrl(GetLiveUrlRequest request);

    /**
     * 获取直播播放地址, 失败返回异常
     *
     * @param contentId  流内容ID
     * @param streamType 流类型
     * @param urlType    流类型
     * @param agent      网关类型
     * @return 播放地址
     */
    String getLiveUrl(String contentId, int streamType, UrlType urlType, int agent);

    /**
     * 获取直播播放地址, 失败返回null
     *
     * @param contentId  流内容ID
     * @param streamType 流类型
     * @param urlType    流类型
     * @param agent      网关类型
     * @return 播放地址
     */
    String optLiveUrl(String contentId, int streamType, UrlType urlType, int agent);

    /**
     * 获取视频流RTMP播放地址
     *
     * @param contentId  流内容ID
     * @param streamType 流类型
     * @return RTMP播放地址
     */
    String getStreamRtmpUrl(String contentId, int streamType);

    /**
     * 获取视频流RTMP播放地址
     *
     * @param contentId  流内容ID
     * @param streamType 流类型
     * @param agentType  接入类型
     * @return RTMP播放地址
     */
    String getStreamRtmpUrl(String contentId, int streamType, int agentType);

    /**
     * 获取视频流HLS播放地址
     *
     * @param contentId  流内容ID
     * @param streamType 流类型
     * @return HLS播放地址
     */
    String getStreamHlsUrl(String contentId, int streamType);

    /**
     * 获取视频流HLS播放地址
     *
     * @param contentId  流内容ID
     * @param streamType 流类型
     * @param agentType  接入类型
     * @return HLS播放地址
     */
    String getStreamHlsUrl(String contentId, int streamType, int agentType);
}
