package com.allcam.mss.ability.storage.model;

import com.allcam.common.base.AcBaseBean;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class UploadSearchInfo extends AcBaseBean
{
    private static final long serialVersionUID = 6543003596051184454L;

    @Verification(type = VerifyType.HAS_TEXT)
    private String beginTime;

    @Verification(type = VerifyType.HAS_TEXT)
    private String endTime;

    /**
     * 用来数据库检索，不用于接口字段
     */
    @JsonIgnore
    private String uploaderId;
}
