package com.allcam.mss.ability.storage;

import com.allcam.mss.ability.storage.model.UploadFileInfo;
import com.allcam.mss.ability.storage.request.*;

/**
 * 资源上传管理服务
 *
 * @author Beowulf
 */
public interface UploadManageService
{

    /**
     * 根据文件ID获取上传文件信息
     *
     * @param fileId 文件ID
     * @return 上传文件信息
     */
    UploadFileInfo getFileById(String fileId);

    /**
     * 获取AllMedia上传文件详细信息
     *
     * @param request 获取请求
     * @return 上传文件详细信息
     */
    GetFileDetailResponse getFileDetail(GetFileDetailRequest request);

    /**
     * 获取AllMedia上传地址
     *
     * @param request 获取请求
     * @return 最小负载的AllMedia上传URL地址
     */
    GetUploadUrlResponse getUploadUrl(GetUploadUrlRequest request);

    /**
     * 获取已上传文件
     *
     * @param request 获取请求
     * @return 获取响应
     */
    UploadFileListResponse getUploadFiles(UploadFileListRequest request);

    /**
     * 获取文件下载地址
     *
     * @param request 获取请求
     * @return 文件下载地址
     */
    GetDownloadUrlResponse getDownloadUrl(GetDownloadUrlRequest request);

    /**
     * 根据文件编号获取内网地址，如果fileId对应的文件不存在，则抛出异常
     *
     * @param fileId 件编号
     * @return 内网下载地址
     */
    String getInnerDownloadUrlById(String fileId);

    /**
     * 根据文件编号获取内网地址，如果fileId对应的文件不存在，则返回默认值
     *
     * @param fileId   件编号
     * @param defValue 默认值
     * @return 内网下载地址
     */
    String optInnerDownloadUrlById(String fileId, String defValue);

    /**
     * 根据文件编号获取外网地址，如果fileId对应的文件不存在，则抛出异常
     *
     * @param fileId 件编号
     * @return 外网下载地址
     */
    String getDownloadUrlById(String fileId);

    /**
     * 根据文件编号获取外网地址，如果fileId对应的文件不存在，则返回默认值
     *
     * @param fileId   文件编号
     * @param defValue 默认值
     * @return 外网下载地址
     */
    String optDownloadUrlById(String fileId, String defValue);

    /**
     * 批量删除已上传文件
     *
     * @param request 获取请求
     * @return 获取响应
     */
    DelUploadFileResponse delUploadFiles(DelUploadFileRequest request);
}
