package com.allcam.mss.ability.storage;

import com.allcam.mss.ability.storage.model.FileInfo;
import com.allcam.mss.ability.storage.model.PathInfo;

import java.util.List;

/**
 * @author Beowulf
 */
public interface StorageManageService
{
    /**
     * 获取AllMedia存储信息
     *
     * @return 各路径（bucket）下使用空间与剩余空间
     */
    List<PathInfo> getStoragePathStat();

    /**
     * 查看在vpath（bucket）下目录下文件与文件夹
     *
     * @param vpath vpath（bucket）
     * @param dir   指定要查看路径
     * @return 目录下文件与文件夹
     */
    List<FileInfo> getFilesInPath(String vpath, String dir);

    /**
     * 查看在vpath（bucket）下目录下文件与文件夹，多路径/bucket方式
     *
     * @param paths 多路径/bucket
     * @return 目录下文件与文件夹
     */
    List<FileInfo> getFilesInPath(List<PathInfo> paths);

    /**
     * 在vpath（bucket）下创建目录（文件夹）
     *
     * @param vpath vpath（bucket）
     * @param dir   目录（文件夹）
     */
    void makeDir(String vpath, String dir);

    /**
     * 删除指定vpath（bucket）下文件
     *
     * @param vpath    vpath（bucket）
     * @param filePath 文件路径，包含路径与文件名
     */
    void deleteFileInPath(String vpath, String filePath);

    /**
     * 删除指定vpath（bucket）下多个文件
     *
     * @param vpath        vpath（bucket）
     * @param filePathList 多个文件路径，包含路径与文件名
     */
    void deleteFilesInPath(String vpath, List<String> filePathList);

    /**
     * 删除多个vpath（bucket）下多个文件
     *
     * @param pathFiles 多个vpath（bucket）下多个文件
     */
    void deleteFiles(List<PathInfo> pathFiles);
}
