package com.allcam.mss.ability.media.request;

import com.allcam.common.base.BaseRequest;
import com.allcam.common.utils.verify.Verification;
import com.allcam.common.utils.verify.VerifyType;
import lombok.Getter;
import lombok.Setter;

/**
 * @author Beowulf
 */
@Getter
@Setter
public class VodPlayUrlRequest extends BaseRequest
{

    private static final long serialVersionUID = 917955788285461657L;

    /**
     * 文件编号
     */
    @Verification(type = VerifyType.HAS_TEXT)
    private String fileId;

    /**
     * 播放类型：
     * 1.	RTMP
     * 2.	HLS
     */
    @Verification(type = VerifyType.NOT_ZERO)
    private int urlType;

    /**
     * 播放回调通知地址
     */
    private String callbackUrl;
}
